/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import tests.support.Support_HttpConstants;
import tests.support.Support_TestWebData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Support_TestWebServer
implements Support_HttpConstants {
    private static final String LOGTAG = "httpsv";
    private final Map<String, Request> pathToRequest = new ConcurrentHashMap<String, Request>();
    int timeout = 0;
    static final int DEFAULT_TIMEOUT = 5000;
    protected String HTTP_VERSION_STRING = "HTTP/1.1";
    private boolean http11 = true;
    private AcceptThread acceptT;
    int mTimeout;
    int mPort;
    boolean mLog = false;
    boolean keepAlive = true;
    boolean chunked = false;
    int maxChunkSize = 1024;
    String redirectHost = null;
    int redirectCode = -1;
    int acceptLimit = 100;
    int acceptedConnections = 0;
    static final int BUF_SIZE = 2048;
    static final byte[] EOL = new byte[]{13, 10};

    public int initServer(boolean log) throws Exception {
        return this.initServer(0, 5000, log);
    }

    public int initServer(int port, boolean log) throws Exception {
        return this.initServer(port, 5000, log);
    }

    public int initServer(int port, String servePath, String contentType) throws Exception {
        Support_TestWebData.initDynamicTestWebData(servePath, contentType);
        return this.initServer(port, 5000, false);
    }

    public int initServer(int port, int timeout, boolean log) throws Exception {
        this.mTimeout = timeout;
        this.mLog = log;
        this.keepAlive = true;
        if (this.acceptT == null) {
            this.acceptT = new AcceptThread();
            this.mPort = this.acceptT.init(port);
            this.acceptT.start();
        }
        return this.mPort;
    }

    protected void log(String s) {
        if (this.mLog) {
            Logger.global.fine(s);
        }
    }

    public void setHttpVersion11(boolean set) {
        this.http11 = set;
        this.HTTP_VERSION_STRING = set ? "HTTP/1.1" : "HTTP/1.0";
    }

    public void setKeepAlive(boolean value) {
        this.keepAlive = value;
    }

    public void setChunked(boolean value) {
        this.chunked = value;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public void setAcceptLimit(int limit) {
        this.acceptLimit = limit;
    }

    public void setRedirect(String redirect, int code) {
        this.redirectHost = redirect;
        this.redirectCode = code;
        this.log("Server will redirect output to " + redirect + " code " + code);
    }

    public Map<String, Request> pathToRequest() {
        return this.pathToRequest;
    }

    public int getNumAcceptedConnections() {
        return this.acceptedConnections;
    }

    public void close() {
        if (this.acceptT != null) {
            this.log("Closing AcceptThread" + this.acceptT);
            this.acceptT.close();
            this.acceptT = null;
        }
    }

    class Worker
    implements Support_HttpConstants,
    Runnable {
        byte[] buf;
        private Socket s;
        private int requestMethod;
        private String testID;
        private String path;
        private int testNum;
        private boolean readStarted;
        private boolean hasContent = false;
        private Map<String, String> headers = new LinkedHashMap<String, String>();

        Worker(Socket s) {
            this.buf = new byte[2048];
            this.s = s;
        }

        public synchronized void run() {
            try {
                this.handleClient();
            }
            catch (Exception e) {
                Support_TestWebServer.this.log("Exception during handleClient in the TestWebServer: " + e.getMessage());
            }
            Support_TestWebServer.this.log(this + " terminated");
        }

        private void clearBuffer() {
            for (int i = 0; i < 2048; ++i) {
                this.buf[i] = 0;
            }
        }

        private int readOneLine(InputStream is) {
            int read = 0;
            this.clearBuffer();
            try {
                Support_TestWebServer.this.log("Reading one line: started =" + this.readStarted + " avail=" + is.available());
                StringBuilder log = new StringBuilder();
                while (!this.readStarted || is.available() > 0) {
                    int data = is.read();
                    if (data == -1) {
                        Support_TestWebServer.this.log("EOF returned");
                        return -1;
                    }
                    this.buf[read] = (byte)data;
                    log.append((char)data);
                    this.readStarted = true;
                    if (this.buf[read++] != 10) continue;
                    Support_TestWebServer.this.log(log.toString());
                    return read;
                }
            }
            catch (IOException e) {
                Support_TestWebServer.this.log("IOException from readOneLine");
            }
            return read;
        }

        private int readData(InputStream is, int length) {
            int read = 0;
            byte[] buf = new byte[length];
            try {
                while (is.available() > 0) {
                    int count = is.read(buf, read, length - read);
                    read += count;
                }
            }
            catch (IOException e) {
                Support_TestWebServer.this.log("IOException from readData");
            }
            return read;
        }

        private int parseStatusLine(InputStream is) {
            int index;
            int nread = 0;
            Support_TestWebServer.this.log("Parse status line");
            nread = this.readOneLine(is);
            if (nread == -1) {
                this.requestMethod = 0;
                return -1;
            }
            if (this.buf[0] == 71 && this.buf[1] == 69 && this.buf[2] == 84 && this.buf[3] == 32) {
                this.requestMethod = 1;
                Support_TestWebServer.this.log("GET request");
                index = 4;
            } else if (this.buf[0] == 72 && this.buf[1] == 69 && this.buf[2] == 65 && this.buf[3] == 68 && this.buf[4] == 32) {
                this.requestMethod = 2;
                Support_TestWebServer.this.log("HEAD request");
                index = 5;
            } else if (this.buf[0] == 80 && this.buf[1] == 79 && this.buf[2] == 83 && this.buf[3] == 84 && this.buf[4] == 32) {
                this.requestMethod = 3;
                Support_TestWebServer.this.log("POST request");
                index = 5;
            } else {
                this.requestMethod = 0;
                return -1;
            }
            if (this.requestMethod > 0) {
                int i = index;
                while (this.buf[i] != 32) {
                    if (this.buf[i] == 10 || this.buf[i] == 13) {
                        this.requestMethod = 0;
                        return -1;
                    }
                    ++i;
                }
                this.path = new String(this.buf, 0, index, i - index);
                this.testID = this.path.substring(1);
                return nread;
            }
            return -1;
        }

        private int parseHeader(InputStream is) {
            int index = 0;
            int nread = 0;
            Support_TestWebServer.this.log("Parse a header");
            nread = this.readOneLine(is);
            if (nread == -1) {
                this.requestMethod = 0;
                return -1;
            }
            int i = index;
            while (this.buf[i] != 58) {
                if (this.buf[i] == 10 || this.buf[i] == 13) {
                    return 0;
                }
                ++i;
            }
            String headerName = new String(this.buf, 0, i);
            ++i;
            while (this.buf[i] == 32) {
                ++i;
            }
            String headerValue = new String(this.buf, i, nread - i - 2);
            this.headers.put(headerName, headerValue);
            return nread;
        }

        private int readHeaders(InputStream is) {
            int headerLen;
            int nread = 0;
            Support_TestWebServer.this.log("Read headers");
            do {
                headerLen = 0;
                headerLen = this.parseHeader(is);
                if (headerLen == -1) {
                    return -1;
                }
                nread += headerLen;
            } while (headerLen > 2);
            return nread;
        }

        private int readContent(InputStream is) {
            boolean nread = false;
            Support_TestWebServer.this.log("Read content");
            String lengthString = this.headers.get(requestHeaders[32]);
            int length = new Integer(lengthString);
            length = this.readData(is, length);
            return length;
        }

        void handleClient() throws IOException {
            BufferedInputStream is = new BufferedInputStream(this.s.getInputStream());
            PrintStream ps = new PrintStream(this.s.getOutputStream());
            int nread = 0;
            this.s.setSoTimeout(Support_TestWebServer.this.mTimeout);
            this.s.setTcpNoDelay(true);
            do {
                block20: {
                    block19: {
                        nread = this.parseStatusLine(is);
                        if (this.requestMethod != 0) {
                            nread = this.readHeaders(is);
                            Support_TestWebServer.this.pathToRequest().put(this.path, new Request(this.path, this.headers));
                            if (this.headers.get(requestHeaders[32]) != null) {
                                nread = this.readContent(is);
                            }
                        } else {
                            if (nread > 0) {
                                ps.print(Support_TestWebServer.this.HTTP_VERSION_STRING + " " + 405 + " unsupported method type: ");
                                ps.write(this.buf, 0, 5);
                                ps.write(EOL);
                                ps.flush();
                            }
                            if (!Support_TestWebServer.this.keepAlive || nread <= 0) {
                                this.headers.clear();
                                this.readStarted = false;
                                Support_TestWebServer.this.log("SOCKET CLOSED");
                                this.s.close();
                                return;
                            }
                        }
                        this.testNum = -1;
                        this.printStatus(ps);
                        this.printHeaders(ps);
                        this.psWriteEOL(ps);
                        if (Support_TestWebServer.this.redirectCode != -1) break block19;
                        switch (this.requestMethod) {
                            case 1: {
                                if (this.testNum < -1 || this.testNum > Support_TestWebData.tests.length - 1) {
                                    this.send404(ps);
                                    break;
                                }
                                this.sendFile(ps);
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                if (this.testNum > 0 || this.testNum < Support_TestWebData.tests.length - 1) {
                                    this.sendFile(ps);
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block20;
                    }
                    switch (Support_TestWebServer.this.redirectCode) {
                        case 301: {
                            this.psPrint(ps, Support_TestWebData.testServerResponse[0]);
                            break;
                        }
                        case 302: {
                            this.psPrint(ps, Support_TestWebData.testServerResponse[1]);
                            break;
                        }
                        case 303: {
                            this.psPrint(ps, Support_TestWebData.testServerResponse[2]);
                            break;
                        }
                        case 307: {
                            this.psPrint(ps, Support_TestWebData.testServerResponse[3]);
                            break;
                        }
                    }
                }
                ps.flush();
                this.readStarted = false;
                this.headers.clear();
            } while (Support_TestWebServer.this.keepAlive);
            Support_TestWebServer.this.log("SOCKET CLOSED");
            this.s.close();
        }

        void psPrint(PrintStream ps, String s) throws IOException {
            Support_TestWebServer.this.log(s);
            ps.print(s);
        }

        void psWrite(PrintStream ps, byte[] bytes, int offset, int count) throws IOException {
            Support_TestWebServer.this.log(new String(bytes));
            ps.write(bytes, offset, count);
        }

        void psWriteEOL(PrintStream ps) throws IOException {
            Support_TestWebServer.this.log("CRLF");
            ps.write(EOL);
        }

        void printStatus(PrintStream ps) throws IOException {
            if (Support_TestWebServer.this.redirectCode != -1) {
                Support_TestWebServer.this.log("REDIRECTING TO " + Support_TestWebServer.this.redirectHost + " status " + Support_TestWebServer.this.redirectCode);
                this.psPrint(ps, Support_TestWebServer.this.HTTP_VERSION_STRING + " " + Support_TestWebServer.this.redirectCode + " Moved permanently");
                this.psWriteEOL(ps);
                this.psPrint(ps, "Location: " + Support_TestWebServer.this.redirectHost);
                this.psWriteEOL(ps);
                return;
            }
            if (this.testID.startsWith("test")) {
                this.testNum = Integer.valueOf(this.testID.substring(4)) - 1;
            }
            if (this.testNum < -1 || this.testNum > Support_TestWebData.tests.length - 1) {
                this.psPrint(ps, Support_TestWebServer.this.HTTP_VERSION_STRING + " " + 404 + " not found");
                this.psWriteEOL(ps);
            } else {
                this.psPrint(ps, Support_TestWebServer.this.HTTP_VERSION_STRING + " " + 200 + " OK");
                this.psWriteEOL(ps);
            }
            Support_TestWebServer.this.log("Status sent");
        }

        void printHeaders(PrintStream ps) throws IOException {
            if (this.testNum < -1 || this.testNum > Support_TestWebData.tests.length - 1) {
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss");
            this.psPrint(ps, "Server: TestWebServer" + Support_TestWebServer.this.mPort);
            this.psWriteEOL(ps);
            this.psPrint(ps, "Date: " + df.format(new Date()));
            this.psWriteEOL(ps);
            this.psPrint(ps, "Connection: " + (Support_TestWebServer.this.keepAlive ? "Keep-Alive" : "Close"));
            this.psWriteEOL(ps);
            if (Support_TestWebServer.this.redirectCode == -1) {
                if (this.testNum == -1) {
                    if (!Support_TestWebData.test0DataAvailable) {
                        Support_TestWebServer.this.log("testdata was not initilaized");
                        return;
                    }
                    if (Support_TestWebServer.this.chunked) {
                        this.psPrint(ps, "Transfer-Encoding: chunked");
                    } else {
                        this.psPrint(ps, "Content-length: " + Support_TestWebData.test0Data.length);
                    }
                    this.psWriteEOL(ps);
                    this.psPrint(ps, "Last Modified: " + new Date(Support_TestWebData.test0Params.testLastModified));
                    this.psWriteEOL(ps);
                    this.psPrint(ps, "Content-type: " + Support_TestWebData.test0Params.testType);
                    this.psWriteEOL(ps);
                    if (Support_TestWebData.testParams[this.testNum].testExp > 0L) {
                        long exp = Support_TestWebData.testParams[this.testNum].testExp;
                        this.psPrint(ps, "expires: " + df.format(exp) + " GMT");
                        this.psWriteEOL(ps);
                    }
                } else if (!Support_TestWebData.testParams[this.testNum].testDir) {
                    if (Support_TestWebServer.this.chunked) {
                        this.psPrint(ps, "Transfer-Encoding: chunked");
                    } else {
                        this.psPrint(ps, "Content-length: " + Support_TestWebData.testParams[this.testNum].testLength);
                    }
                    this.psWriteEOL(ps);
                    this.psPrint(ps, "Last Modified: " + new Date(Support_TestWebData.testParams[this.testNum].testLastModified));
                    this.psWriteEOL(ps);
                    this.psPrint(ps, "Content-type: " + Support_TestWebData.testParams[this.testNum].testType);
                    this.psWriteEOL(ps);
                    if (Support_TestWebData.testParams[this.testNum].testExp > 0L) {
                        long exp = Support_TestWebData.testParams[this.testNum].testExp;
                        this.psPrint(ps, "expires: " + df.format(exp) + " GMT");
                        this.psWriteEOL(ps);
                    }
                } else {
                    this.psPrint(ps, "Content-type: text/html");
                    this.psWriteEOL(ps);
                }
            } else {
                this.psPrint(ps, "Content-length: " + Support_TestWebData.testServerResponse[0].length());
                this.psWriteEOL(ps);
                this.psWriteEOL(ps);
            }
            Support_TestWebServer.this.log("Headers sent");
        }

        void send404(PrintStream ps) throws IOException {
            ps.println("Not Found\n\nThe requested resource was not found.\n");
        }

        void sendFile(PrintStream ps) throws IOException {
            if (this.testNum == -1) {
                if (!Support_TestWebData.test0DataAvailable) {
                    Support_TestWebServer.this.log("test data was not initialized");
                    return;
                }
                this.sendFile(ps, Support_TestWebData.test0Data);
            } else {
                this.sendFile(ps, Support_TestWebData.tests[this.testNum]);
            }
        }

        void sendFile(PrintStream ps, byte[] bytes) throws IOException {
            if (Support_TestWebServer.this.chunked) {
                int chunkSize;
                for (int offset = 0; offset < bytes.length; offset += chunkSize) {
                    chunkSize = Math.min(bytes.length - offset, Support_TestWebServer.this.maxChunkSize);
                    this.psPrint(ps, Integer.toHexString(chunkSize));
                    this.psWriteEOL(ps);
                    this.psWrite(ps, bytes, offset, chunkSize);
                    this.psWriteEOL(ps);
                }
                this.psPrint(ps, "0");
                this.psWriteEOL(ps);
                this.psWriteEOL(ps);
            } else {
                this.psWrite(ps, bytes, 0, bytes.length);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request {
        private final String path;
        private final Map<String, String> headers;

        public Request(String path, Map<String, String> headers) {
            this.path = path;
            this.headers = new LinkedHashMap<String, String>(headers);
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    class AcceptThread
    extends Thread {
        ServerSocket ss = null;
        boolean running = false;

        AcceptThread() {
        }

        public int init(int port) throws IOException {
            this.ss = new ServerSocket(port);
            this.ss.setSoTimeout(5000);
            this.ss.setReuseAddress(true);
            return this.ss.getLocalPort();
        }

        public synchronized void run() {
            this.running = true;
            while (this.running) {
                try {
                    Socket s = this.ss.accept();
                    ++Support_TestWebServer.this.acceptedConnections;
                    if (Support_TestWebServer.this.acceptedConnections >= Support_TestWebServer.this.acceptLimit) {
                        this.running = false;
                    }
                    new Thread((Runnable)new Worker(s), "additional worker").start();
                }
                catch (SocketException e) {
                    Support_TestWebServer.this.log(e.getMessage());
                }
                catch (IOException e) {
                    Support_TestWebServer.this.log(e.getMessage());
                }
            }
            Support_TestWebServer.this.log("AcceptThread terminated" + this);
        }

        public void close() {
            try {
                this.running = false;
                this.ss.close();
            }
            catch (IOException e) {
                Support_TestWebServer.this.log("IOException caught by server socket close");
            }
        }
    }
}

