/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class Support_TestWebData {
    public static final byte[] test1 = Support_TestWebData.utfBytes();
    public static final byte[] test2 = Support_TestWebData.newBinaryFile(8192);
    public static final String postContent = "user=111";
    public static final byte[][] tests = new byte[][]{test1, test2};
    public static Support_TestWebData[] testParams = new Support_TestWebData[]{new Support_TestWebData(test1.length, 14000000, "test1", "text/html", false, 0L), new Support_TestWebData(test2.length, 14000002, "test2", "unknown/unknown", false, new Date().getTime() + 100000L)};
    public static String[] testServerResponse = new String[]{"Redirecting 301", "Redirecting 302", "Redirecting 303", "Redirecting 307"};
    public static final int REDIRECT_301 = 0;
    public static final int REDIRECT_302 = 1;
    public static final int REDIRECT_303 = 2;
    public static final int REDIRECT_307 = 3;
    public long testLength;
    public long testLastModified;
    public String testName;
    public String testType;
    public long testExp;
    public boolean testDir;
    public static boolean test0DataAvailable = false;
    public static byte[] test0Data;
    public static Support_TestWebData test0Params;

    private static byte[] utfBytes() {
        try {
            return "<html>\n<body>\n<h1>Hello World!</h1>\n</body>\n</html>\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError();
        }
    }

    private static byte[] newBinaryFile(int byteCount) {
        byte[] result = new byte[byteCount];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)i;
        }
        return result;
    }

    Support_TestWebData(int length, int lastModified, String name, String type, boolean isDir, long expDate) {
        this.testLength = length;
        this.testLastModified = lastModified;
        this.testName = name;
        this.testType = type;
        this.testDir = isDir;
        this.testExp = expDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Support_TestWebData(String path, String type) {
        File file = new File(path);
        this.testLength = file.length();
        this.testLastModified = file.lastModified();
        this.testName = file.getName();
        this.testType = type;
        this.testDir = file.isDirectory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            while (in.available() > 0) {
                out.write(in.read());
            }
            in.close();
            out.flush();
            test0Data = out.toByteArray();
            out.close();
            test0DataAvailable = true;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void initDynamicTestWebData(String path, String type) {
        test0Params = new Support_TestWebData(path, type);
    }
}

