/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.IOException;
import java.io.Reader;

public class Support_StringReader
extends Reader {
    private String str;
    private int markpos = -1;
    private int pos = 0;
    private int count;

    public Support_StringReader(String str) {
        super(str);
        this.str = str;
        this.count = str.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.str = null;
            }
        }
    }

    private boolean isOpen() {
        return this.str != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) throws IOException {
        if (readLimit >= 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen()) {
                    throw new IOException("StringReader is closed");
                }
                this.markpos = this.pos;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.pos != this.count) {
                    return this.str.charAt(this.pos++);
                }
                return -1;
            }
            throw new IOException("StringReader is closed");
        }
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        if (0 <= offset && offset <= buf.length && 0 <= count && count <= buf.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isOpen()) {
                    if (this.pos == this.count) {
                        return -1;
                    }
                    int end = this.pos + count > this.count ? this.count : this.pos + count;
                    this.str.getChars(this.pos, end, buf, offset);
                    int read = end - this.pos;
                    this.pos = end;
                    return read;
                }
                throw new IOException("StringReader is closed");
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                return true;
            }
            throw new IOException("StringReader is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException("StringReader is closed");
            }
            this.pos = this.markpos != -1 ? this.markpos : 0;
        }
    }

    public long skip(long count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (count <= 0L) {
                    return 0L;
                }
                long skipped = 0L;
                if (count < (long)(this.count - this.pos)) {
                    this.pos += (int)count;
                    skipped = count;
                } else {
                    skipped = this.count - this.pos;
                    this.pos = this.count;
                }
                return skipped;
            }
            throw new IOException("StringReader is closed");
        }
    }
}

