/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.IOException;
import java.io.OutputStream;

public class Support_OutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 32;
    private byte[] buffer;
    private int position;
    private int size;
    private boolean throwsException;

    public Support_OutputStream() {
        this(32);
    }

    public Support_OutputStream(boolean throwException) {
        this(32);
        this.throwsException = throwException;
    }

    public Support_OutputStream(int bufferSize) {
        this.buffer = new byte[bufferSize];
        this.position = 0;
        this.size = bufferSize;
        this.throwsException = false;
    }

    public void close() throws IOException {
        if (this.throwsException) {
            throw new IOException("Exception thrown for testing purposes.");
        }
        super.close();
    }

    public void flush() throws IOException {
        if (this.throwsException) {
            throw new IOException("Exception thrown for testing purposes.");
        }
        super.flush();
    }

    public void write(byte[] buffer) throws IOException {
        if (this.throwsException) {
            throw new IOException("Exception thrown for testing purposes.");
        }
        for (int i = 0; i < buffer.length; ++i) {
            this.write(buffer[i]);
        }
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (this.throwsException) {
            throw new IOException("Exception thrown for testing purposes.");
        }
        if (offset < 0 || count < 0 || offset + count > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = offset; i < offset + count; ++i) {
            this.write(buffer[i]);
        }
    }

    public void write(int oneByte) throws IOException {
        if (this.throwsException) {
            throw new IOException("Exception thrown for testing purposes.");
        }
        if (this.position < this.size) {
            this.buffer[this.position] = (byte)(oneByte & 0xFF);
            ++this.position;
        } else {
            throw new IOException("Internal buffer overflow.");
        }
    }

    public byte[] toByteArray() {
        byte[] toReturn = new byte[this.position];
        System.arraycopy(this.buffer, 0, toReturn, 0, this.position);
        return toReturn;
    }

    public String toString() {
        return new String(this.buffer, 0, this.position);
    }

    public int size() {
        return this.position;
    }

    public void setThrowsException(boolean newValue) {
        this.throwsException = newValue;
    }
}

