/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import dalvik.annotation.TestTargetClass;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import tests.support.Support_CollectionTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestTargetClass(value=List.class)
public class Support_ListTest
extends TestCase {
    List<Integer> list;

    public Support_ListTest(String p1) {
        super(p1);
    }

    public Support_ListTest(String p1, List<Integer> l) {
        super(p1);
        this.list = l;
    }

    public void runTest() {
        int hashCode = 1;
        for (int counter = 0; counter < 100; ++counter) {
            Integer elem = this.list.get(counter);
            hashCode = 31 * hashCode + ((Object)elem).hashCode();
            Support_ListTest.assertTrue((String)"ListTest - get failed", (boolean)((Object)elem).equals(new Integer(counter)));
        }
        Support_ListTest.assertTrue((String)"ListTest - hashCode failed", (hashCode == ((Object)this.list).hashCode() ? 1 : 0) != 0);
        this.list.add(50, new Integer(1000));
        Support_ListTest.assertTrue((String)"ListTest - a) add with index failed--did not insert", (boolean)this.list.get(50).equals(new Integer(1000)));
        Support_ListTest.assertTrue((String)"ListTest - b) add with index failed--did not move following elements", (boolean)this.list.get(51).equals(new Integer(50)));
        Support_ListTest.assertTrue((String)"ListTest - c) add with index failed--affected previous elements", (boolean)this.list.get(49).equals(new Integer(49)));
        this.list.set(50, new Integer(2000));
        Support_ListTest.assertTrue((String)"ListTest - a) set failed--did not set", (boolean)this.list.get(50).equals(new Integer(2000)));
        Support_ListTest.assertTrue((String)"ListTest - b) set failed--affected following elements", (boolean)this.list.get(51).equals(new Integer(50)));
        Support_ListTest.assertTrue((String)"ListTest - c) set failed--affected previous elements", (boolean)this.list.get(49).equals(new Integer(49)));
        this.list.remove(50);
        Support_ListTest.assertTrue((String)"ListTest - a) remove with index failed--did not remove", (boolean)this.list.get(50).equals(new Integer(50)));
        Support_ListTest.assertTrue((String)"ListTest - b) remove with index failed--did not move following elements", (boolean)this.list.get(51).equals(new Integer(51)));
        Support_ListTest.assertTrue((String)"ListTest - c) remove with index failed--affected previous elements", (boolean)this.list.get(49).equals(new Integer(49)));
        LinkedList<Integer> myList = new LinkedList<Integer>();
        myList.add(new Integer(500));
        myList.add(new Integer(501));
        myList.add(new Integer(502));
        this.list.addAll(50, myList);
        Support_ListTest.assertTrue((String)"ListTest - a) addAll with index failed--did not insert", (boolean)this.list.get(50).equals(new Integer(500)));
        Support_ListTest.assertTrue((String)"ListTest - b) addAll with index failed--did not insert", (boolean)this.list.get(51).equals(new Integer(501)));
        Support_ListTest.assertTrue((String)"ListTest - c) addAll with index failed--did not insert", (boolean)this.list.get(52).equals(new Integer(502)));
        Support_ListTest.assertTrue((String)"ListTest - d) addAll with index failed--did not move following elements", (boolean)this.list.get(53).equals(new Integer(50)));
        Support_ListTest.assertTrue((String)"ListTest - e) addAll with index failed--affected previous elements", (boolean)this.list.get(49).equals(new Integer(49)));
        List<Integer> mySubList = this.list.subList(50, 53);
        Support_ListTest.assertEquals((int)3, (int)mySubList.size());
        Support_ListTest.assertTrue((String)"ListTest - a) sublist Failed--does not contain correct elements", (boolean)mySubList.get(0).equals(new Integer(500)));
        Support_ListTest.assertTrue((String)"ListTest - b) sublist Failed--does not contain correct elements", (boolean)mySubList.get(1).equals(new Integer(501)));
        Support_ListTest.assertTrue((String)"ListTest - c) sublist Failed--does not contain correct elements", (boolean)mySubList.get(2).equals(new Integer(502)));
        this.t_listIterator(mySubList);
        mySubList.clear();
        Support_ListTest.assertEquals((String)"ListTest - Clearing the sublist did not remove the appropriate elements from the original list", (int)100, (int)this.list.size());
        this.t_listIterator(this.list);
        ListIterator<Integer> li = this.list.listIterator();
        int counter = 0;
        while (li.hasNext()) {
            Integer elem = li.next();
            Support_ListTest.assertTrue((String)"ListTest - listIterator failed", (boolean)((Object)elem).equals(new Integer(counter)));
            ++counter;
        }
        new Support_CollectionTest("", this.list).runTest();
    }

    public void t_listIterator(List<Integer> list) {
        int i;
        ListIterator<Integer> li = list.listIterator(1);
        Support_ListTest.assertTrue((String)"listIterator(1)", (li.next() == list.get(1) ? 1 : 0) != 0);
        int orgSize = list.size();
        li = list.listIterator();
        for (i = 0; i <= orgSize; ++i) {
            if (i == 0) {
                Support_ListTest.assertTrue((String)("list iterator hasPrevious(): " + i), (!li.hasPrevious() ? 1 : 0) != 0);
            } else {
                Support_ListTest.assertTrue((String)("list iterator hasPrevious(): " + i), (boolean)li.hasPrevious());
            }
            if (i == list.size()) {
                Support_ListTest.assertTrue((String)("list iterator hasNext(): " + i), (!li.hasNext() ? 1 : 0) != 0);
            } else {
                Support_ListTest.assertTrue((String)("list iterator hasNext(): " + i), (boolean)li.hasNext());
            }
            Support_ListTest.assertTrue((String)("list iterator nextIndex(): " + i), (li.nextIndex() == i ? 1 : 0) != 0);
            Support_ListTest.assertTrue((String)("list iterator previousIndex(): " + i), (li.previousIndex() == i - 1 ? 1 : 0) != 0);
            boolean exception = false;
            try {
                Support_ListTest.assertTrue((String)("list iterator next(): " + i), (li.next() == list.get(i) ? 1 : 0) != 0);
            }
            catch (NoSuchElementException e) {
                exception = true;
            }
            if (i == list.size()) {
                Support_ListTest.assertTrue((String)("list iterator next() exception: " + i), (boolean)exception);
                continue;
            }
            Support_ListTest.assertTrue((String)("list iterator next() exception: " + i), (!exception ? 1 : 0) != 0);
        }
        for (i = orgSize - 1; i >= 0; --i) {
            Support_ListTest.assertTrue((String)("list iterator previous(): " + i), (li.previous() == list.get(i) ? 1 : 0) != 0);
            Support_ListTest.assertTrue((String)("list iterator nextIndex()2: " + i), (li.nextIndex() == i ? 1 : 0) != 0);
            Support_ListTest.assertTrue((String)("list iterator previousIndex()2: " + i), (li.previousIndex() == i - 1 ? 1 : 0) != 0);
            if (i == 0) {
                Support_ListTest.assertTrue((String)("list iterator hasPrevious()2: " + i), (!li.hasPrevious() ? 1 : 0) != 0);
            } else {
                Support_ListTest.assertTrue((String)("list iterator hasPrevious()2: " + i), (boolean)li.hasPrevious());
            }
            Support_ListTest.assertTrue((String)("list iterator hasNext()2: " + i), (boolean)li.hasNext());
        }
        boolean exception = false;
        try {
            li.previous();
        }
        catch (NoSuchElementException e) {
            exception = true;
        }
        Support_ListTest.assertTrue((String)"list iterator previous() exception", (boolean)exception);
        Integer add1 = new Integer(600);
        Integer add2 = new Integer(601);
        li.add(add1);
        Support_ListTest.assertTrue((String)"list iterator add(), size()", (list.size() == orgSize + 1 ? 1 : 0) != 0);
        Support_ListTest.assertEquals((String)"list iterator add(), nextIndex()", (int)1, (int)li.nextIndex());
        Support_ListTest.assertEquals((String)"list iterator add(), previousIndex()", (int)0, (int)li.previousIndex());
        Integer next = li.next();
        Support_ListTest.assertTrue((String)("list iterator add(), next(): " + next), (next == list.get(1) ? 1 : 0) != 0);
        li.add(add2);
        Integer previous = li.previous();
        Support_ListTest.assertTrue((String)("list iterator add(), previous(): " + previous), (previous == add2 ? 1 : 0) != 0);
        Support_ListTest.assertEquals((String)"list iterator add(), nextIndex()2", (int)2, (int)li.nextIndex());
        Support_ListTest.assertEquals((String)"list iterator add(), previousIndex()2", (int)1, (int)li.previousIndex());
        li.remove();
        Support_ListTest.assertTrue((String)"list iterator remove(), size()", (list.size() == orgSize + 1 ? 1 : 0) != 0);
        Support_ListTest.assertEquals((String)"list iterator remove(), nextIndex()", (int)2, (int)li.nextIndex());
        Support_ListTest.assertEquals((String)"list iterator remove(), previousIndex()", (int)1, (int)li.previousIndex());
        Support_ListTest.assertTrue((String)"list iterator previous()2", (li.previous() == list.get(1) ? 1 : 0) != 0);
        Support_ListTest.assertTrue((String)"list iterator previous()3", (li.previous() == list.get(0) ? 1 : 0) != 0);
        Support_ListTest.assertTrue((String)"list iterator next()2", (li.next() == list.get(0) ? 1 : 0) != 0);
        li.remove();
        Support_ListTest.assertTrue((String)"list iterator hasPrevious()3", (!li.hasPrevious() ? 1 : 0) != 0);
        Support_ListTest.assertTrue((String)"list iterator hasNext()3", (boolean)li.hasNext());
        Support_ListTest.assertTrue((String)"list iterator size()", (list.size() == orgSize ? 1 : 0) != 0);
        Support_ListTest.assertEquals((String)"list iterator nextIndex()3", (int)0, (int)li.nextIndex());
        Support_ListTest.assertEquals((String)"list iterator previousIndex()3", (int)-1, (int)li.previousIndex());
    }
}

