/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class Support_GetLocal {
    static Hashtable<String, File> cache = new Hashtable(20);

    public static File getLocalFile(String url) throws IOException, MalformedURLException {
        url = "/tests/resources/" + url;
        File temp = cache.get(url);
        if (temp == null) {
            int result;
            InputStream in = Support_GetLocal.class.getResourceAsStream(url);
            temp = File.createTempFile("hyts_local", ".tmp", null);
            temp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(temp);
            byte[] buf = new byte[4096];
            while ((result = in.read(buf)) != -1) {
                out.write(buf, 0, result);
            }
            in.close();
            out.close();
            cache.put(url, temp);
        }
        return temp;
    }

    public static File getExternalLocalFile(String url) throws IOException, MalformedURLException {
        File temp = cache.get(url);
        if (temp == null) {
            int result;
            InputStream in = new URL(url).openStream();
            temp = File.createTempFile("hyts_local", ".tmp", null);
            temp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(temp);
            byte[] buf = new byte[4096];
            while ((result = in.read(buf)) != -1) {
                out.write(buf, 0, result);
            }
            in.close();
            out.close();
            cache.put(url, temp);
        }
        return temp;
    }

    static ByteArrayInputStream getStream(String url) throws IOException, MalformedURLException {
        int result;
        InputStream in = new URL(url).openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        byte[] buf = new byte[256];
        while ((result = in.read(buf)) != -1) {
            out.write(buf, 0, result);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static File createTempFile(String suffix) throws IOException {
        return File.createTempFile("hyts_", suffix, null);
    }

    public static JarURLConnection getJarURLConnection() throws IOException {
        JarURLConnection con1 = null;
        File file = Support_GetLocal.getLocalFile("hyts_att.jar");
        URL fUrl1 = new URL("jar:file:" + file.getPath() + "!/");
        con1 = (JarURLConnection)fUrl1.openConnection();
        return con1;
    }
}

