/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.util.Vector;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Support_Format
extends TestCase {
    protected String text;

    public Support_Format(String p1) {
        super(p1);
    }

    protected void t_FormatWithField(int count, Format format, Object object, String text, Format.Field field, int begin, int end) {
        StringBuffer buffer = new StringBuffer();
        FieldPosition pos = new FieldPosition(field);
        format.format(object, buffer, pos);
        if (text == null) {
            Support_Format.assertEquals((String)("Test " + count + ": incorrect formatted text"), (String)this.text, (String)buffer.toString());
        } else {
            Support_Format.assertEquals((String)("Test " + count + ": incorrect formatted text"), (String)text, (String)buffer.toString());
        }
        Support_Format.assertEquals((String)("Test " + count + ": incorrect begin index for field " + field), (int)begin, (int)pos.getBeginIndex());
        Support_Format.assertEquals((String)("Test " + count + ": incorrect end index for field" + field), (int)end, (int)pos.getEndIndex());
    }

    protected void t_Format(int count, Object object, Format format, Vector<FieldContainer> expectedResults) {
        Vector<FieldContainer> results = Support_Format.findFields(format.formatToCharacterIterator(object));
        Support_Format.assertTrue((String)("Test " + count + ": Format returned incorrect CharacterIterator for " + format.format(object)), (boolean)Support_Format.compare(results, expectedResults));
    }

    protected static boolean compare(Vector<FieldContainer> vector1, Vector<FieldContainer> vector2) {
        return vector1.size() == vector2.size() && vector1.containsAll(vector2);
    }

    protected static Vector<FieldContainer> findFields(AttributedCharacterIterator iterator) {
        Vector<FieldContainer> result = new Vector<FieldContainer>();
        while (iterator.getIndex() != iterator.getEndIndex()) {
            int start = iterator.getRunStart();
            int end = iterator.getRunLimit();
            for (AttributedCharacterIterator.Attribute attribute : iterator.getAttributes().keySet()) {
                Object value = iterator.getAttribute(attribute);
                result.add(new FieldContainer(start, end, attribute, value));
            }
            iterator.setIndex(end);
        }
        return result;
    }

    protected static class FieldContainer {
        int start;
        int end;
        AttributedCharacterIterator.Attribute attribute;
        Object value;

        public FieldContainer(int start, int end, AttributedCharacterIterator.Attribute attribute) {
            this(start, end, attribute, attribute);
        }

        public FieldContainer(int start, int end, AttributedCharacterIterator.Attribute attribute, int value) {
            this(start, end, attribute, new Integer(value));
        }

        public FieldContainer(int start, int end, AttributedCharacterIterator.Attribute attribute, Object value) {
            this.start = start;
            this.end = end;
            this.attribute = attribute;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FieldContainer)) {
                return false;
            }
            FieldContainer fc = (FieldContainer)obj;
            return this.start == fc.start && this.end == fc.end && this.attribute == fc.attribute && this.value.equals(fc.value);
        }
    }
}

