/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Support_Exec
extends TestCase {
    private static final boolean againstDalvik = System.getProperty("java.vendor").contains("Android");

    public static ProcessBuilder javaProcessBuilder() throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command().add(againstDalvik ? "dalvikvm" : "java");
        String testVMArgs = System.getProperty("hy.test.vmargs");
        if (testVMArgs != null) {
            builder.command().addAll(Arrays.asList(testVMArgs.split("\\s+")));
        }
        return builder;
    }

    public static String createPath(String ... elements) {
        StringBuilder result = new StringBuilder();
        for (String element : elements) {
            result.append(File.pathSeparator);
            result.append(element);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execAndGetOutput(ProcessBuilder builder) throws IOException {
        Process process = builder.start();
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            Exception failure;
            Future<String> errFuture = executorService.submit(Support_Exec.streamToStringCallable(process.getErrorStream()));
            Future<String> outFuture = executorService.submit(Support_Exec.streamToStringCallable(process.getInputStream()));
            String out = "";
            try {
                out = outFuture.get(10L, TimeUnit.SECONDS);
                String err = errFuture.get(10L, TimeUnit.SECONDS);
                failure = err.length() > 0 ? new AssertionFailedError("Unexpected err stream data:\n" + err) : null;
            }
            catch (Exception e) {
                failure = e;
            }
            if (failure != null) {
                AssertionFailedError error = new AssertionFailedError("Failed to execute " + builder.command() + "; output was:\n" + out);
                error.initCause((Throwable)failure);
                throw error;
            }
            String string = out;
            return string;
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execAndCheckOutput(ProcessBuilder builder, String expectedOut, String expectedErr) throws Exception {
        Process process = builder.start();
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            Future<String> errFuture = executorService.submit(Support_Exec.streamToStringCallable(process.getErrorStream()));
            Future<String> outFuture = executorService.submit(Support_Exec.streamToStringCallable(process.getInputStream()));
            Support_Exec.assertEquals((String)expectedOut, (String)outFuture.get(10L, TimeUnit.SECONDS));
            Support_Exec.assertEquals((String)expectedErr, (String)errFuture.get(10L, TimeUnit.SECONDS));
        }
        finally {
            executorService.shutdown();
            process.waitFor();
        }
    }

    private static Callable<String> streamToStringCallable(final InputStream in) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                int c;
                StringWriter writer = new StringWriter();
                InputStreamReader reader = new InputStreamReader(in);
                while ((c = ((Reader)reader).read()) != -1) {
                    writer.write(c);
                }
                return writer.toString();
            }
        };
    }
}

