/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import tests.support.Support_Format;
import tests.support.Support_Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Support_DecimalFormat
extends Support_Format {
    public Support_DecimalFormat(String p1) {
        super(p1);
    }

    public void runTest() {
        this.t_formatToCharacterIterator();
        this.t_format_with_FieldPosition();
    }

    public static void main(String[] args) {
        new Support_DecimalFormat("").runTest();
    }

    public void t_format_with_FieldPosition() {
        DecimalFormat format = (DecimalFormat)NumberFormat.getCurrencyInstance(Locale.US);
        Double number = new Double(1.000000076E7);
        String text = "$10,000,000.76";
        this.t_FormatWithField(0, format, number, text, NumberFormat.Field.CURRENCY, 0, 1);
        this.t_FormatWithField(1, format, number, text, NumberFormat.Field.INTEGER, 1, 11);
        this.t_FormatWithField(2, format, number, text, NumberFormat.Field.GROUPING_SEPARATOR, 3, 4);
        this.t_FormatWithField(3, format, number, text, NumberFormat.Field.DECIMAL_SEPARATOR, 11, 12);
        this.t_FormatWithField(4, format, number, text, NumberFormat.Field.FRACTION, 12, 14);
        this.t_FormatWithField(5, format, number, text, NumberFormat.Field.SIGN, 0, 0);
        this.t_FormatWithField(6, format, number, text, NumberFormat.Field.EXPONENT, 0, 0);
        this.t_FormatWithField(7, format, number, text, NumberFormat.Field.EXPONENT_SIGN, 0, 0);
        this.t_FormatWithField(8, format, number, text, NumberFormat.Field.EXPONENT_SYMBOL, 0, 0);
        this.t_FormatWithField(9, format, number, text, NumberFormat.Field.PERCENT, 0, 0);
        this.t_FormatWithField(10, format, number, text, NumberFormat.Field.PERMILLE, 0, 0);
        format = new DecimalFormat("000000000.0#E0");
        text = "100000007.6E-1";
        this.t_FormatWithField(11, format, number, text, NumberFormat.Field.INTEGER, 0, 9);
        this.t_FormatWithField(12, format, number, text, NumberFormat.Field.DECIMAL_SEPARATOR, 9, 10);
        this.t_FormatWithField(13, format, number, text, NumberFormat.Field.FRACTION, 10, 11);
        this.t_FormatWithField(14, format, number, text, NumberFormat.Field.EXPONENT_SYMBOL, 11, 12);
        this.t_FormatWithField(15, format, number, text, NumberFormat.Field.EXPONENT_SIGN, 12, 13);
        this.t_FormatWithField(16, format, number, text, NumberFormat.Field.EXPONENT, 13, 14);
        this.t_FormatWithField(17, format, number, text, NumberFormat.Field.GROUPING_SEPARATOR, 0, 0);
        this.t_FormatWithField(18, format, number, text, NumberFormat.Field.SIGN, 0, 0);
        this.t_FormatWithField(19, format, number, text, NumberFormat.Field.CURRENCY, 0, 0);
        this.t_FormatWithField(20, format, number, text, NumberFormat.Field.PERCENT, 0, 0);
        this.t_FormatWithField(21, format, number, text, NumberFormat.Field.PERMILLE, 0, 0);
        number = new Double(350.76);
        format = (DecimalFormat)NumberFormat.getCurrencyInstance(new Locale("de", "CH"));
        text = "SFr. 350.76";
        this.t_FormatWithField(24, format, number, text, NumberFormat.Field.CURRENCY, 0, 4);
        this.t_FormatWithField(22, format, number, text, NumberFormat.Field.INTEGER, 5, 8);
        this.t_FormatWithField(23, format, number, text, NumberFormat.Field.DECIMAL_SEPARATOR, 8, 9);
        this.t_FormatWithField(23, format, number, text, NumberFormat.Field.FRACTION, 9, 11);
        this.t_FormatWithField(25, format, number, text, NumberFormat.Field.GROUPING_SEPARATOR, 0, 0);
        this.t_FormatWithField(27, format, number, text, NumberFormat.Field.SIGN, 0, 0);
        this.t_FormatWithField(28, format, number, text, NumberFormat.Field.EXPONENT, 0, 0);
        this.t_FormatWithField(29, format, number, text, NumberFormat.Field.EXPONENT_SIGN, 0, 0);
        this.t_FormatWithField(30, format, number, text, NumberFormat.Field.EXPONENT_SYMBOL, 0, 0);
        this.t_FormatWithField(31, format, number, text, NumberFormat.Field.PERCENT, 0, 0);
        this.t_FormatWithField(32, format, number, text, NumberFormat.Field.PERMILLE, 0, 0);
    }

    public void t_formatToCharacterIterator() {
        Double number = new Double(350.76);
        Long longNumber = new Long(100300400L);
        Long zeroNumber = new Long(0L);
        Double negativeNumber = new Double(-350.76);
        Locale us = Locale.US;
        Locale tr = new Locale("de", "CH");
        if (Support_Locale.areLocalesAvailable(us)) {
            this.t_Format(1, number, NumberFormat.getNumberInstance(us), Support_DecimalFormat.getNumberVectorUS());
            this.t_Format(2, number, NumberFormat.getIntegerInstance(us), Support_DecimalFormat.getIntegerVectorUS());
            this.t_Format(3, number, NumberFormat.getPercentInstance(us), Support_DecimalFormat.getPercentVectorUS());
            this.t_Format(4, number, NumberFormat.getCurrencyInstance(us), Support_DecimalFormat.getPositiveCurrencyVectorUS());
            this.t_Format(5, negativeNumber, NumberFormat.getCurrencyInstance(us), Support_DecimalFormat.getNegativeCurrencyVectorUS());
            this.t_Format(6, longNumber, NumberFormat.getNumberInstance(us), Support_DecimalFormat.getNumberVector2US());
            this.t_Format(7, zeroNumber, NumberFormat.getNumberInstance(us), Support_DecimalFormat.getZeroVector());
        }
        DecimalFormat format = new DecimalFormat("###0.##\u2030");
        this.t_Format(8, number, format, Support_DecimalFormat.getPermilleVector());
        format = new DecimalFormat("00.0#E0");
        this.t_Format(9, number, format, Support_DecimalFormat.getPositiveExponentVector());
        format = new DecimalFormat("0000.0#E0");
        this.t_Format(10, number, format, Support_DecimalFormat.getNegativeExponentVector());
        if (Support_Locale.areLocalesAvailable(tr)) {
            this.t_Format(11, number, NumberFormat.getCurrencyInstance(tr), Support_DecimalFormat.getPositiveCurrencyVectorCH());
            this.t_Format(12, negativeNumber, NumberFormat.getCurrencyInstance(tr), Support_DecimalFormat.getNegativeCurrencyVectorCH());
        }
    }

    private static Vector<Support_Format.FieldContainer> getNumberVectorUS() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 3, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(3, 4, NumberFormat.Field.DECIMAL_SEPARATOR));
        v.add(new Support_Format.FieldContainer(4, 6, NumberFormat.Field.FRACTION));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getIntegerVectorUS() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 3, NumberFormat.Field.INTEGER));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getPositiveCurrencyVectorCH() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 4, NumberFormat.Field.CURRENCY));
        v.add(new Support_Format.FieldContainer(5, 8, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(8, 9, NumberFormat.Field.DECIMAL_SEPARATOR));
        v.add(new Support_Format.FieldContainer(9, 11, NumberFormat.Field.FRACTION));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getNegativeCurrencyVectorCH() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 4, NumberFormat.Field.CURRENCY));
        v.add(new Support_Format.FieldContainer(4, 5, NumberFormat.Field.SIGN));
        v.add(new Support_Format.FieldContainer(5, 8, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(8, 9, NumberFormat.Field.DECIMAL_SEPARATOR));
        v.add(new Support_Format.FieldContainer(9, 11, NumberFormat.Field.FRACTION));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getPositiveCurrencyVectorUS() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 1, NumberFormat.Field.CURRENCY));
        v.add(new Support_Format.FieldContainer(1, 4, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(4, 5, NumberFormat.Field.DECIMAL_SEPARATOR));
        v.add(new Support_Format.FieldContainer(5, 7, NumberFormat.Field.FRACTION));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getNegativeCurrencyVectorUS() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(1, 2, NumberFormat.Field.CURRENCY));
        v.add(new Support_Format.FieldContainer(2, 5, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(5, 6, NumberFormat.Field.DECIMAL_SEPARATOR));
        v.add(new Support_Format.FieldContainer(6, 8, NumberFormat.Field.FRACTION));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getPercentVectorUS() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 2, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(2, 3, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(2, 3, NumberFormat.Field.GROUPING_SEPARATOR));
        v.add(new Support_Format.FieldContainer(3, 6, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(6, 7, NumberFormat.Field.PERCENT));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getPermilleVector() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 6, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(6, 7, NumberFormat.Field.PERMILLE));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getNegativeExponentVector() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 4, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(4, 5, NumberFormat.Field.DECIMAL_SEPARATOR));
        v.add(new Support_Format.FieldContainer(5, 6, NumberFormat.Field.FRACTION));
        v.add(new Support_Format.FieldContainer(6, 7, NumberFormat.Field.EXPONENT_SYMBOL));
        v.add(new Support_Format.FieldContainer(7, 8, NumberFormat.Field.EXPONENT_SIGN));
        v.add(new Support_Format.FieldContainer(8, 9, NumberFormat.Field.EXPONENT));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getPositiveExponentVector() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 2, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(2, 3, NumberFormat.Field.DECIMAL_SEPARATOR));
        v.add(new Support_Format.FieldContainer(3, 5, NumberFormat.Field.FRACTION));
        v.add(new Support_Format.FieldContainer(5, 6, NumberFormat.Field.EXPONENT_SYMBOL));
        v.add(new Support_Format.FieldContainer(6, 7, NumberFormat.Field.EXPONENT));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getNumberVector2US() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 3, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(3, 4, NumberFormat.Field.GROUPING_SEPARATOR));
        v.add(new Support_Format.FieldContainer(3, 4, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(4, 7, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(7, 8, NumberFormat.Field.GROUPING_SEPARATOR));
        v.add(new Support_Format.FieldContainer(7, 8, NumberFormat.Field.INTEGER));
        v.add(new Support_Format.FieldContainer(8, 11, NumberFormat.Field.INTEGER));
        return v;
    }

    private static Vector<Support_Format.FieldContainer> getZeroVector() {
        Vector<Support_Format.FieldContainer> v = new Vector<Support_Format.FieldContainer>();
        v.add(new Support_Format.FieldContainer(0, 1, NumberFormat.Field.INTEGER));
        return v;
    }
}

