/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Support_Configuration {
    public static String DomainAddress = "apache.org";
    public static String WebName = "jcltest.";
    public static final String HomeAddress;
    public static String TestResourcesDir;
    public static final String TestResources;
    public static String HomeAddressResponse;
    public static String HomeAddressSoftware;
    public static String ProxyServerTestHost;
    public static String SocksServerTestHost;
    public static int SocksServerTestPort;
    public static String UnresolvedIP;
    public static byte[] nonLocalAddressBytes;
    public static String InetTestAddress;
    public static String InetTestIP;
    public static byte[] InetTestAddr;
    public static String InetTestAddress2;
    public static String InetTestIP2;
    public static byte[] InetTestCaddr;
    public static final String HomeAddress6 = "jcltest6.apache.org";
    public static String IPv6GlobalAddressJcl4;
    public static String ProxyServerTestHostIPv6;
    public static String InetTestIP6;
    public static String InetTestIP6LO;
    public static String ResolvedNotExistingHost;
    public static String SpecialInetTestAddress;
    public static String testURL;
    public static String hTTPURLwExpiration;
    public static String hTTPURLwLastModified;
    public static String hTTPURLyahoo;
    public static String hTTPURLgoogle;
    public static String testContentEncoding;
    public static int SpecialInetTestAddressNumber;
    public static String InetAlias1;
    public static String InetAlias2;
    public static String FTPTestAddress;
    public static String URLConnectionLastModifiedString;
    public static long URLConnectionLastModified;
    public static long URLConnectionDate;
    public static boolean RunCommTests;
    public static String Port1;
    public static String Port2;
    static Hashtable<String, String> props;

    static void loadProperties() {
        InputStream in = null;
        Hashtable<String, String> props = new Hashtable<String, String>();
        String iniName = System.getProperty("test.ini.file", "JCLAuto.ini");
        if (System.getProperty("test.comm") != null) {
            RunCommTests = true;
        }
        try {
            in = new FileInputStream(iniName);
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            System.out.println("SupportConfiguration.loadProperties()");
            System.out.println(e);
            e.printStackTrace();
        }
        if (in == null) {
            try {
                Class<?> cl = Class.forName("com.ibm.support.Support_Configuration");
                in = cl.getResourceAsStream(iniName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            if (in != null) {
                Support_Configuration.load(in, props);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (props.size() == 0) {
            return;
        }
        String value = props.get("DomainAddress");
        if (value != null) {
            DomainAddress = value;
        }
        if ((value = props.get("WebName")) != null) {
            WebName = value;
        }
        if ((value = props.get("TestResourcesDir")) != null) {
            TestResourcesDir = value;
        }
        if ((value = props.get("HomeAddressResponse")) != null) {
            HomeAddressResponse = value;
        }
        if ((value = props.get("HomeAddressSoftware")) != null) {
            HomeAddressSoftware = value;
        }
        if ((value = props.get("ProxyServerTestHost")) != null) {
            ProxyServerTestHost = value;
        }
        if ((value = props.get("SocksServerTestHost")) != null) {
            SocksServerTestHost = value;
        }
        if ((value = props.get("SocksServerTestPort")) != null) {
            SocksServerTestPort = Integer.parseInt(value);
        }
        if ((value = props.get("UnresolvedIP")) != null) {
            UnresolvedIP = value;
        }
        if ((value = props.get("InetTestAddress")) != null) {
            InetTestAddress = value;
        }
        if ((value = props.get("InetTestIP")) != null) {
            InetTestIP = value;
            byte[] addr = new byte[4];
            int last = 0;
            try {
                for (int i = 0; i < 3; ++i) {
                    int dot = InetTestIP.indexOf(46, last);
                    addr[i] = (byte)Integer.parseInt(InetTestIP.substring(last, dot));
                    last = dot + 1;
                }
                addr[3] = (byte)Integer.parseInt(InetTestIP.substring(last));
                InetTestCaddr = addr;
            }
            catch (RuntimeException e) {
                System.out.println("Error parsing InetTestIP (" + InetTestIP + ")");
                System.out.println(e);
            }
        }
        if ((value = props.get("NonLocalAddressBytes")) != null) {
            String nonLocalAddressBytesString = value;
            byte[] addr = new byte[4];
            int last = 0;
            try {
                for (int i = 0; i < 3; ++i) {
                    int dot = nonLocalAddressBytesString.indexOf(46, last);
                    addr[i] = (byte)Integer.parseInt(nonLocalAddressBytesString.substring(last, dot));
                    last = dot + 1;
                }
                addr[3] = (byte)Integer.parseInt(nonLocalAddressBytesString.substring(last));
                nonLocalAddressBytes = addr;
            }
            catch (RuntimeException e) {
                System.out.println("Error parsing NonLocalAddressBytes (" + nonLocalAddressBytesString + ")");
                System.out.println(e);
            }
        }
        if ((value = props.get("InetTestAddress2")) != null) {
            InetTestAddress2 = value;
        }
        if ((value = props.get("InetTestIP2")) != null) {
            InetTestIP2 = value;
        }
        if ((value = props.get("SpecialInetTestAddress")) != null) {
            SpecialInetTestAddress = value;
        }
        if ((value = props.get("SpecialInetTestAddressNumber")) != null) {
            SpecialInetTestAddressNumber = Integer.parseInt(value);
        }
        if ((value = props.get("FTPTestAddress")) != null) {
            FTPTestAddress = value;
        }
        if ((value = props.get("URLConnectionLastModifiedString")) != null) {
            URLConnectionLastModifiedString = value;
        }
        if ((value = props.get("URLConnectionLastModified")) != null) {
            URLConnectionLastModified = Long.parseLong(value);
        }
        if ((value = props.get("URLConnectionDate")) != null) {
            URLConnectionDate = Long.parseLong(value);
        }
        if ((value = props.get("Port1")) != null) {
            Port1 = value;
        }
        if ((value = props.get("Port2")) != null) {
            Port2 = value;
        }
        if ((value = props.get("InetTestIP6")) != null) {
            InetTestIP6 = value;
        }
        if ((value = props.get("InetTestIP6LO")) != null) {
            InetTestIP6LO = value;
        }
        if ((value = props.get("ProxyServerTestHostIPv6")) != null) {
            ProxyServerTestHostIPv6 = value;
        }
        if ((value = props.get("ResolvedNotExistingHost")) != null) {
            ResolvedNotExistingHost = value;
        }
        if ((value = props.get("InetAlias1")) != null) {
            InetAlias1 = value;
        }
        if ((value = props.get("InetAlias2")) != null) {
            InetAlias2 = value;
        }
        if ((value = props.get("IPv6GlobalAddressJcl4")) != null) {
            IPv6GlobalAddressJcl4 = value;
        }
    }

    static void load(InputStream in, Hashtable<String, String> result) throws IOException {
        int nextChar;
        int NONE = 0;
        int SLASH = 1;
        int UNICODE = 2;
        int CONTINUE = 3;
        int DONE = 4;
        int IGNORE = 5;
        int mode = NONE;
        int unicode = 0;
        int count = 0;
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        StringBuffer buffer = key;
        boolean firstChar = true;
        block17: while ((nextChar = in.read()) != -1) {
            if (mode == UNICODE) {
                int digit = Character.digit((char)nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) continue;
                }
                mode = NONE;
                buffer.append((char)unicode);
                if (nextChar != 10) continue;
            }
            if (mode == SLASH) {
                mode = NONE;
                switch (nextChar) {
                    case 13: {
                        mode = CONTINUE;
                        continue block17;
                    }
                    case 10: {
                        mode = IGNORE;
                        continue block17;
                    }
                    case 98: {
                        nextChar = 8;
                        break;
                    }
                    case 102: {
                        nextChar = 12;
                        break;
                    }
                    case 110: {
                        nextChar = 10;
                        break;
                    }
                    case 114: {
                        nextChar = 13;
                        break;
                    }
                    case 116: {
                        nextChar = 9;
                        break;
                    }
                    case 117: {
                        mode = UNICODE;
                        count = 0;
                        unicode = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        while ((nextChar = in.read()) != -1 && nextChar != 13 && nextChar != 10) {
                        }
                        continue block17;
                    }
                    case 10: {
                        if (mode == CONTINUE) {
                            mode = IGNORE;
                            continue block17;
                        }
                    }
                    case 13: {
                        mode = NONE;
                        firstChar = true;
                        if (key.length() > 0 || buffer == value) {
                            result.put(key.toString(), value.toString());
                        }
                        key.setLength(0);
                        value.setLength(0);
                        buffer = key;
                        continue block17;
                    }
                    case 92: {
                        mode = SLASH;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (buffer != key) break;
                        buffer = value;
                        continue block17;
                    }
                }
                char c = (char)nextChar;
                if (c >= '\u001c' && c <= ' ' || c >= '\t' && c <= '\r') {
                    if (mode == CONTINUE) {
                        mode = IGNORE;
                    }
                    if (buffer.length() == 0 || mode == IGNORE) continue;
                    if (buffer == key) {
                        mode = DONE;
                        continue;
                    }
                }
                if (mode == IGNORE || mode == CONTINUE) {
                    mode = NONE;
                }
            }
            firstChar = false;
            if (mode == DONE) {
                buffer = value;
                mode = NONE;
            }
            buffer.append((char)nextChar);
        }
        if (key.length() > 0 || buffer == value) {
            result.put(key.toString(), value.toString());
        }
    }

    static {
        TestResourcesDir = "/testres231";
        HomeAddressResponse = "HTTP/1.1 200 OK";
        HomeAddressSoftware = "Jetty(6.0.x)";
        ProxyServerTestHost = "jcltest.apache.org";
        SocksServerTestHost = "jcltest.apache.org";
        SocksServerTestPort = 1080;
        UnresolvedIP = "192.168.99.99";
        nonLocalAddressBytes = new byte[]{1, 0, 0, 0};
        InetTestAddress = "localhost";
        InetTestIP = "127.0.0.1";
        InetTestAddr = new byte[]{127, 0, 0, 1};
        InetTestAddress2 = "localhost";
        InetTestIP2 = "127.0.0.1";
        InetTestCaddr = new byte[]{9, 26, -56, -111};
        IPv6GlobalAddressJcl4 = "FE80:0000:0000:0000:020D:60FF:FE0F:A776%4";
        ProxyServerTestHostIPv6 = HomeAddress6;
        InetTestIP6 = "fe80::20d:60ff:fe24:7410";
        InetTestIP6LO = "::1";
        ResolvedNotExistingHost = "9.26.194.72";
        SpecialInetTestAddress = "www.google.com";
        testURL = "harmony.apache.org";
        hTTPURLwExpiration = "http://phpwiki.sourceforge.net/phpwiki-1.2/";
        hTTPURLwLastModified = "http://www.php.net/manual/en/function.explode.php";
        hTTPURLyahoo = "http://news.yahoo.com/";
        hTTPURLgoogle = "http://www.google.com/ie";
        testContentEncoding = "http://www.amazon.com/";
        SpecialInetTestAddressNumber = 4;
        InetAlias1 = "alias1.apache.org";
        InetAlias2 = "alias2.apache.org";
        FTPTestAddress = "jcltest:jclpass@localhost";
        URLConnectionLastModifiedString = "Mon, 14 Jun 1999 21:06:22 GMT";
        URLConnectionLastModified = 929394382000L;
        URLConnectionDate = 929106872000L;
        RunCommTests = false;
        Port1 = "COM1";
        Port2 = "COM2";
        props = null;
        Support_Configuration.loadProperties();
        HomeAddress = WebName + DomainAddress;
        TestResources = HomeAddress + TestResourcesDir;
    }
}

