/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

public class Support_BitSet {
    private long[] bits;
    private static final int ELM_SIZE = 64;

    public Support_BitSet() {
        this(64);
    }

    public Support_BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        this.bits = new long[nbits / 64 + (nbits % 64 > 0 ? 1 : 0)];
    }

    public void clear(int pos) {
        if (pos >= 0) {
            if (pos < this.bits.length * 64) {
                int n = pos / 64;
                this.bits[n] = this.bits[n] & (1L << pos % 64 ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.growBits(pos);
            }
        } else {
            throw new IndexOutOfBoundsException("Negative index specified");
        }
    }

    public boolean get(int pos) {
        if (pos >= 0) {
            if (pos < this.bits.length * 64) {
                return (this.bits[pos / 64] & 1L << pos % 64) != 0L;
            }
            return false;
        }
        throw new IndexOutOfBoundsException("Negative index specified");
    }

    private void growBits(int pos) {
        long[] tempBits = new long[++pos / 64 + (pos % 64 > 0 ? 1 : 0)];
        System.arraycopy(this.bits, 0, tempBits, 0, this.bits.length);
        this.bits = tempBits;
    }

    public void set(int pos) {
        if (pos >= 0) {
            if (pos >= this.bits.length * 64) {
                this.growBits(pos);
            }
        } else {
            throw new IndexOutOfBoundsException("Negative index specified");
        }
        int n = pos / 64;
        this.bits[n] = this.bits[n] | 1L << pos % 64;
    }

    public int size() {
        return this.bits.length * 64;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.bits.length / 2);
        int bitCount = 0;
        sb.append('{');
        boolean comma = false;
        for (long element : this.bits) {
            if (element == 0L) {
                bitCount += 64;
                continue;
            }
            for (int j = 0; j < 64; ++j) {
                if ((element & 1L << j) != 0L) {
                    if (comma) {
                        sb.append(", ");
                    }
                    sb.append(bitCount);
                    comma = true;
                }
                ++bitCount;
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int length() {
        int i;
        int idx;
        for (idx = this.bits.length - 1; idx >= 0 && this.bits[idx] == 0L; --idx) {
        }
        if (idx == -1) {
            return 0;
        }
        long val = this.bits[idx];
        for (i = 63; (val & 1L << i) == 0L && i > 0; --i) {
        }
        return idx * 64 + i + 1;
    }
}

