/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.IOException;
import java.io.Writer;

public class Support_ASimpleWriter
extends Writer {
    public static final int DEFAULT_BUFFER_SIZE = 32;
    public char[] buf;
    public int pos;
    public int size;
    public boolean throwExceptionOnNextUse = false;

    public Support_ASimpleWriter() {
        this(32);
    }

    public Support_ASimpleWriter(boolean throwException) {
        this(32);
        this.throwExceptionOnNextUse = throwException;
    }

    public Support_ASimpleWriter(int bufferSize) {
        this.buf = new char[bufferSize];
        this.pos = 0;
        this.size = bufferSize;
    }

    public void close() throws IOException {
        if (this.throwExceptionOnNextUse) {
            throw new IOException("Exception thrown for testing purpose.");
        }
    }

    public void flush() throws IOException {
        if (this.throwExceptionOnNextUse) {
            throw new IOException("Exception thrown for testing purpose.");
        }
    }

    public void write(char[] src, int offset, int count) throws IOException {
        if (this.throwExceptionOnNextUse) {
            throw new IOException("Exception thrown for testing purpose.");
        }
        if (offset < 0 || count < 0 || offset + count > this.buf.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            System.arraycopy(src, offset, this.buf, this.pos, count);
            this.pos += count;
        }
        catch (IndexOutOfBoundsException e) {
            this.pos = this.size;
            throw new IOException("Internal Buffer Overflow");
        }
    }

    public byte[] toByteArray() {
        byte[] toReturn = new byte[this.pos];
        System.arraycopy(this.buf, 0, toReturn, 0, this.pos);
        return toReturn;
    }

    public String toString() {
        return new String(this.buf, 0, this.pos);
    }
}

