/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.IOException;
import java.io.OutputStream;

public class Support_ASimpleOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 32;
    public byte[] buf;
    public int pos;
    public int size;
    public boolean throwExceptionOnNextUse = false;

    public Support_ASimpleOutputStream() {
        this(32);
    }

    public Support_ASimpleOutputStream(boolean throwException) {
        this(32);
        this.throwExceptionOnNextUse = throwException;
    }

    public Support_ASimpleOutputStream(int bufferSize) {
        this.buf = new byte[bufferSize];
        this.pos = 0;
        this.size = bufferSize;
    }

    public void close() throws IOException {
        if (this.throwExceptionOnNextUse) {
            throw new IOException("Exception thrown for testing purpose.");
        }
    }

    public void flush() throws IOException {
        if (this.throwExceptionOnNextUse) {
            throw new IOException("Exception thrown for testing purpose.");
        }
    }

    public void write(int oneByte) throws IOException {
        if (this.throwExceptionOnNextUse) {
            throw new IOException("Exception thrown for testing purpose.");
        }
        if (this.pos < this.size) {
            this.buf[this.pos] = (byte)(oneByte & 0xFF);
            ++this.pos;
        } else {
            throw new IOException("Internal buffer overflow.");
        }
    }

    public byte[] toByteArray() {
        byte[] toReturn = new byte[this.pos];
        System.arraycopy(this.buf, 0, toReturn, 0, this.pos);
        return toReturn;
    }

    public String toString() {
        return new String(this.buf, 0, this.pos);
    }
}

