/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import junit.framework.TestCase;

public abstract class SignatureTest
extends TestCase {
    private final String algorithmName;
    private final String keyAlgorithmName;
    private static final String signData = "some data to sign an";
    KeyPairGenerator generator;
    KeyPair keyPair;

    public SignatureTest(String algorithmName, String keyAlgorithmName) {
        this.algorithmName = algorithmName;
        this.keyAlgorithmName = keyAlgorithmName;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.generator = this.getGenerator();
        this.keyPair = this.getKeyPair();
    }

    private KeyPair getKeyPair() {
        return this.generator.generateKeyPair();
    }

    private KeyPairGenerator getGenerator() {
        try {
            return KeyPairGenerator.getInstance(this.keyAlgorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            SignatureTest.fail((String)e.getMessage());
            return null;
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="getInstance", args={String.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="initSign", args={PrivateKey.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="update", args={byte[].class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="sign", args={}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="initVerify", args={PublicKey.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="verify", args={byte[].class}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testSignature() {
        Signature signature = null;
        try {
            signature = Signature.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            SignatureTest.fail((String)e.getMessage());
        }
        try {
            signature.initSign(this.keyPair.getPrivate());
        }
        catch (InvalidKeyException e) {
            SignatureTest.fail((String)e.getMessage());
        }
        try {
            signature.update(signData.getBytes());
        }
        catch (SignatureException e) {
            SignatureTest.fail((String)e.getMessage());
        }
        byte[] sign = null;
        try {
            sign = signature.sign();
        }
        catch (SignatureException e) {
            SignatureTest.fail((String)e.getMessage());
        }
        try {
            signature.initVerify(this.keyPair.getPublic());
        }
        catch (InvalidKeyException e) {
            SignatureTest.fail((String)e.getMessage());
        }
        try {
            signature.update(signData.getBytes());
        }
        catch (SignatureException e) {
            SignatureTest.fail((String)e.getMessage());
        }
        try {
            SignatureTest.assertTrue((boolean)signature.verify(sign));
        }
        catch (SignatureException e) {
            SignatureTest.fail((String)e.getMessage());
        }
    }
}

