/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import junit.framework.Assert;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureHelper
extends TestHelper<KeyPair> {
    private final String algorithmName;
    private final String plainData = "some data do sign and verify";

    public SignatureHelper(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public void test(KeyPair keyPair) {
        this.test(keyPair.getPrivate(), keyPair.getPublic());
    }

    public void test(PrivateKey encryptKey, PublicKey decryptKey) {
        Signature signature = null;
        try {
            signature = Signature.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            signature.initSign(encryptKey);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            signature.update("some data do sign and verify".getBytes());
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] signed = null;
        try {
            signed = signature.sign();
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            signature.initVerify(decryptKey);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            signature.update("some data do sign and verify".getBytes());
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            Assert.assertTrue((String)"signature could not be verified", (boolean)signature.verify(signed));
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

