/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import junit.framework.TestCase;

public abstract class MessageDigestTest
extends TestCase {
    private String digestAlgorithmName;
    private MessageDigest digest;
    private InputStream sourceData;
    private byte[] checkDigest;
    protected String source1;
    protected String source2;
    protected String source3;
    protected String expected1;
    protected String expected2;
    protected String expected3;

    protected MessageDigestTest(String digestAlgorithmName) {
        this.digestAlgorithmName = digestAlgorithmName;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.source3 = this.getLongMessage(1000000);
        this.digest = this.getMessageDigest();
        this.sourceData = this.getSourceData();
        this.checkDigest = this.getCheckDigest();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.source1 = null;
        this.source2 = null;
        this.source3 = null;
        this.expected1 = null;
        this.expected2 = null;
        this.expected3 = null;
        this.digest = null;
        this.sourceData = null;
        this.checkDigest = null;
        System.gc();
    }

    MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.digestAlgorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            MessageDigestTest.fail((String)("failed to get digest instance: " + e));
            return null;
        }
    }

    InputStream getSourceData() {
        InputStream sourceStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.digestAlgorithmName + ".data");
        MessageDigestTest.assertNotNull((String)("digest source data not found: " + this.digestAlgorithmName), (Object)sourceStream);
        return sourceStream;
    }

    byte[] getCheckDigest() {
        InputStream checkDigestStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.digestAlgorithmName + ".check");
        byte[] checkDigest = new byte[this.digest.getDigestLength()];
        int read = 0;
        int index = 0;
        try {
            while ((read = checkDigestStream.read()) != -1) {
                checkDigest[index++] = (byte)read;
            }
        }
        catch (IOException e) {
            MessageDigestTest.fail((String)("failed to read digest golden data: " + this.digestAlgorithmName));
        }
        return checkDigest;
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="update", args={byte[].class, int.class, int.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="digest", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testMessageDigest1() {
        byte[] buf = new byte[128];
        int read = 0;
        try {
            while ((read = this.sourceData.read(buf)) != -1) {
                this.digest.update(buf, 0, read);
            }
        }
        catch (IOException e) {
            MessageDigestTest.fail((String)"failed to read digest data");
        }
        byte[] computedDigest = this.digest.digest();
        MessageDigestTest.assertNotNull((String)"computed digest is is null", (Object)computedDigest);
        MessageDigestTest.assertEquals((String)"digest length mismatch", (int)this.checkDigest.length, (int)computedDigest.length);
        for (int i = 0; i < this.checkDigest.length; ++i) {
            MessageDigestTest.assertEquals((String)("byte " + i + " of computed and check digest differ"), (byte)this.checkDigest[i], (byte)computedDigest[i]);
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="update", args={byte.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="digest", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testMessageDigest2() {
        try {
            int val;
            while ((val = this.sourceData.read()) != -1) {
                this.digest.update((byte)val);
            }
        }
        catch (IOException e) {
            MessageDigestTest.fail((String)"failed to read digest data");
        }
        byte[] computedDigest = this.digest.digest();
        MessageDigestTest.assertNotNull((String)"computed digest is is null", (Object)computedDigest);
        MessageDigestTest.assertEquals((String)"digest length mismatch", (int)this.checkDigest.length, (int)computedDigest.length);
        for (int i = 0; i < this.checkDigest.length; ++i) {
            MessageDigestTest.assertEquals((String)("byte " + i + " of computed and check digest differ"), (byte)this.checkDigest[i], (byte)computedDigest[i]);
        }
    }

    String getLongMessage(int length) {
        StringBuilder sourceBuilder = new StringBuilder(length);
        for (int i = 0; i < length / 10; ++i) {
            sourceBuilder.append("aaaaaaaaaa");
        }
        return sourceBuilder.toString();
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="update", args={byte.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="digest", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testfips180_2_singleblock() {
        this.digest.update(this.source1.getBytes(), 0, this.source1.length());
        byte[] computedDigest = this.digest.digest();
        MessageDigestTest.assertNotNull((String)"computed digest is null", (Object)computedDigest);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < computedDigest.length; ++i) {
            String res = Integer.toHexString(computedDigest[i] & 0xFF);
            sb.append((res.length() == 1 ? "0" : "") + res);
        }
        MessageDigestTest.assertEquals((String)"computed and check digest differ", (String)this.expected1, (String)sb.toString());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="update", args={byte.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="digest", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testfips180_2_multiblock() {
        this.digest.update(this.source2.getBytes(), 0, this.source2.length());
        byte[] computedDigest = this.digest.digest();
        MessageDigestTest.assertNotNull((String)"computed digest is null", (Object)computedDigest);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < computedDigest.length; ++i) {
            String res = Integer.toHexString(computedDigest[i] & 0xFF);
            sb.append((res.length() == 1 ? "0" : "") + res);
        }
        MessageDigestTest.assertEquals((String)"computed and check digest differ", (String)this.expected2, (String)sb.toString());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="update", args={byte.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="digest", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testfips180_2_longMessage() {
        this.digest.update(this.source3.getBytes(), 0, this.source3.length());
        byte[] computedDigest = this.digest.digest();
        MessageDigestTest.assertNotNull((String)"computed digest is null", (Object)computedDigest);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < computedDigest.length; ++i) {
            String res = Integer.toHexString(computedDigest[i] & 0xFF);
            sb.append((res.length() == 1 ? "0" : "") + res);
        }
        MessageDigestTest.assertEquals((String)"computed and check digest differ", (String)this.expected3, (String)sb.toString());
    }
}

