/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import junit.framework.TestCase;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyPairGeneratorTest
extends TestCase {
    private final String algorithmName;
    private final TestHelper<KeyPair> helper;
    private KeyPairGenerator generator;

    protected KeyPairGeneratorTest(String algorithmName, TestHelper<KeyPair> helper) {
        this.algorithmName = algorithmName;
        this.helper = helper;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.generator = this.getKeyPairGenerator();
    }

    private KeyPairGenerator getKeyPairGenerator() {
        try {
            return KeyPairGenerator.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            KeyPairGeneratorTest.fail((String)("cannot get KeyPairGenerator: " + e));
            return null;
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="initialize", args={int.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="generateKeyPair", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testKeyPairGenerator() throws NoSuchAlgorithmException {
        this.generator.initialize(1024);
        KeyPair keyPair = this.generator.generateKeyPair();
        KeyPairGeneratorTest.assertNotNull((String)"no keypair generated", (Object)keyPair);
        KeyPairGeneratorTest.assertNotNull((String)"no public key generated", (Object)keyPair.getPublic());
        KeyPairGeneratorTest.assertNotNull((String)"no private key generated", (Object)keyPair.getPrivate());
        this.helper.test(keyPair);
    }
}

