/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import junit.framework.TestCase;
import tests.security.DefaultKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyFactoryTest<PublicKeySpec extends KeySpec, PrivateKeySpec extends KeySpec>
extends TestCase {
    private final String algorithmName;
    private final Class<PublicKeySpec> publicKeySpecClass;
    private final Class<PrivateKeySpec> privateKeySpecClass;
    private KeyFactory factory;

    public KeyFactoryTest(String algorithmName, Class<PublicKeySpec> publicKeySpecClass, Class<PrivateKeySpec> privateKeySpecClass) {
        this.algorithmName = algorithmName;
        this.publicKeySpecClass = publicKeySpecClass;
        this.privateKeySpecClass = privateKeySpecClass;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = this.getFactory();
    }

    private KeyFactory getFactory() {
        try {
            return KeyFactory.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            KeyFactoryTest.fail((String)e.getMessage());
            return null;
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.ADDITIONAL, method="getKeySpec", args={Key.class, Class.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="generatePrivate", args={KeySpec.class}), @TestTargetNew(level=TestLevel.ADDITIONAL, method="generatePublic", args={KeySpec.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="method", args={})})
    public void testKeyFactory() {
        KeySpec privateKeySpec = null;
        try {
            privateKeySpec = (KeySpec)this.factory.getKeySpec(DefaultKeys.getPrivateKey(this.algorithmName), this.privateKeySpecClass);
        }
        catch (InvalidKeySpecException e) {
            KeyFactoryTest.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            KeyFactoryTest.fail((String)e.getMessage());
        }
        PrivateKey privateKey = null;
        try {
            privateKey = this.factory.generatePrivate(privateKeySpec);
        }
        catch (InvalidKeySpecException e) {
            KeyFactoryTest.fail((String)e.getMessage());
        }
        KeySpec publicKeySpec = null;
        try {
            publicKeySpec = (KeySpec)this.factory.getKeySpec(DefaultKeys.getPublicKey(this.algorithmName), this.publicKeySpecClass);
        }
        catch (InvalidKeySpecException e) {
            KeyFactoryTest.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            KeyFactoryTest.fail((String)e.getMessage());
        }
        PublicKey publicKey = null;
        try {
            publicKey = this.factory.generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            KeyFactoryTest.fail((String)e.getMessage());
        }
        this.check(new KeyPair(publicKey, privateKey));
    }

    protected void check(KeyPair keyPair) {
    }
}

