/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import junit.framework.Assert;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyAgreementHelper
extends TestHelper<KeyPair> {
    private final String algorithmName;

    public KeyAgreementHelper(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public void test(KeyPair keyPair) {
        this.test(keyPair.getPrivate(), keyPair.getPublic());
    }

    void test(PrivateKey encryptKey, PublicKey decryptKey) {
        KeyAgreement keyAgreement = null;
        try {
            keyAgreement = KeyAgreement.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            keyAgreement.init(encryptKey);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            keyAgreement.doPhase(decryptKey, true);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalStateException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"generated secret is null", (Object)keyAgreement.generateSecret());
    }
}

