/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;

public class DefaultKeys {
    private static final byte[] RSA_private = new byte[]{48, -126, 2, 117, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 2, 95, 48, -126, 2, 91, 2, 1, 0, 2, -127, -127, 0, -103, -91, -106, 114, -82, -69, 89, 54, -88, 18, 23, 5, 76, 99, -98, -72, -123, -44, 45, 113, -41, 41, -71, 5, 15, -76, 87, -5, -45, -107, 92, 33, -20, -75, -21, 103, -94, 79, -63, -109, -17, -106, 65, 5, 61, -59, 62, 4, 77, -58, -49, 50, 124, 31, 102, -93, -59, 39, 121, -20, 46, 103, -6, 25, 91, -29, -79, 105, -38, 99, -68, -38, -45, -69, -83, -116, 56, 123, 74, -100, -44, 77, -46, 51, -73, 78, 4, -74, -33, 98, 85, 72, 92, -108, 2, -9, -124, -26, -101, 87, -1, 23, 42, -95, 116, -115, 7, -40, -50, -9, 11, 89, -5, 19, 110, -15, -61, -85, 62, 114, 27, 98, 9, -24, -40, 65, 105, -31, 2, 3, 1, 0, 1, 2, -127, -128, 87, -42, 28, 46, 47, -54, 22, -12, 114, 28, -11, 96, 40, 13, -125, 125, -123, -76, -120, -50, 93, -19, 18, 66, -36, 121, -125, 27, 10, 24, -122, -11, 53, -9, -62, 62, 26, -62, 113, -83, -6, -9, -16, -17, -24, 34, 76, -109, -11, 74, -60, -60, -35, -60, -83, -50, -50, 53, 5, 52, -118, 75, 18, -28, 105, -26, -38, 7, 26, 119, 92, -89, 33, 65, -119, -116, -107, 106, 93, -100, 60, -82, -61, -28, 100, 84, -38, -5, -70, -90, -27, -118, 127, -6, 26, 63, -101, -85, -38, 61, 59, 67, -16, 12, 6, 87, 67, 69, -18, -116, 39, 5, -81, -51, 90, 71, -71, -22, -39, -86, 102, -37, -29, -36, 84, 71, 96, 1, 2, 65, 0, -19, -23, -67, -43, 2, 109, 68, 14, 63, 116, 12, 69, 84, -120, -2, 92, -4, -14, 49, 123, -81, 21, 119, 122, -36, -58, -98, 126, -63, -54, -124, -57, 75, -60, 65, -31, -123, -28, 90, -89, 61, 84, -121, 13, 122, -59, 71, 92, -14, -83, 20, 77, 99, -80, -36, 52, -75, -38, 23, 13, 78, 43, -98, -127, 2, 65, 0, -91, 83, -37, -40, 40, 87, 101, 43, -6, -14, 33, -72, 96, -82, 67, 75, 81, -123, -53, -38, -119, 90, 125, 5, -38, -4, -81, 70, -122, -68, 63, -47, -22, -92, 86, -93, -26, -44, -94, 8, -109, 99, 33, 14, -59, 60, -105, 126, 113, 11, 121, -8, 96, 115, -47, -7, -44, 102, 41, 125, -36, 34, -37, 97, 2, 64, 93, 61, -17, -123, 77, 39, 47, -75, -7, -50, 108, -124, -69, -123, -39, 82, -18, 91, -87, 99, 21, 18, 111, -70, 58, 78, -87, -115, 122, 59, -7, -33, -11, -28, -36, 1, 28, 45, -116, 13, -31, 110, -128, 99, -101, 11, 56, 85, -56, 82, 103, 19, -111, -113, -98, 46, 22, 91, 124, 15, 93, -28, -96, -127, 2, 64, 32, 18, 17, 94, 112, 12, -20, 2, 73, 14, -71, 61, -45, -5, 89, -16, 125, 98, -17, -11, 119, -103, -121, 17, 32, -74, -51, -91, 103, -77, -110, -55, -68, -77, -98, 94, -13, 3, 34, 95, 121, 127, -52, 68, -38, 59, -13, -61, 66, 88, -112, -109, 126, -38, 88, -52, 22, -56, -82, -103, -52, -97, 50, 97, 2, 64, 2, 41, -37, 0, 15, 10, 23, 51, 126, -59, -20, 33, 71, 101, -36, -27, -62, 13, 66, 40, -31, 23, 26, 0, -67, -66, 28, 125, -54, -109, 103, -113, 40, -73, 96, -114, -16, 93, -51, -6, -35, 107, 114, -9, 72, -39, 60, 64, 124, -80, -41, 88, -62, 83, -83, 4, -10, 11, 53, 81, 69, -71, 79, 73};
    private static final byte[] RSA_public = new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -103, -91, -106, 114, -82, -69, 89, 54, -88, 18, 23, 5, 76, 99, -98, -72, -123, -44, 45, 113, -41, 41, -71, 5, 15, -76, 87, -5, -45, -107, 92, 33, -20, -75, -21, 103, -94, 79, -63, -109, -17, -106, 65, 5, 61, -59, 62, 4, 77, -58, -49, 50, 124, 31, 102, -93, -59, 39, 121, -20, 46, 103, -6, 25, 91, -29, -79, 105, -38, 99, -68, -38, -45, -69, -83, -116, 56, 123, 74, -100, -44, 77, -46, 51, -73, 78, 4, -74, -33, 98, 85, 72, 92, -108, 2, -9, -124, -26, -101, 87, -1, 23, 42, -95, 116, -115, 7, -40, -50, -9, 11, 89, -5, 19, 110, -15, -61, -85, 62, 114, 27, 98, 9, -24, -40, 65, 105, -31, 2, 3, 1, 0, 1};
    private static final byte[] DSA_private = new byte[]{48, -126, 1, 75, 2, 1, 0, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 4, 22, 2, 20, 14, -112, -73, -110, 1, -104, -51, -123, -121, 119, 47, -76, 49, -3, -34, -6, 8, 109, 12, -29};
    private static final byte[] DSA_public = new byte[]{48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -104, 51, -112, 20, 121, -57, -56, 87, -31, -126, 83, 91, 110, 1, 7, 30, -91, -104, -60, 87, 93, 35, -85, 114, -102, -77, 47, 57, -53, -59, -48, -105, -43, 98, -116, -39, -26, -30, 5, -58, 5, 113, 22, -29, -24, 4, -24, 70, 18, 12, -8, -4, -114, 21, 38, 50, -9, -116, 4, 59, 83, 104, -102, -93, -73, 77, 19, 64, 15, -66, 3, -121, -40, -15, -2, 75, -11, 68, 25, 41, -69, 13, 12, 82, -58, -124, 51, 98, 115, 93, 3, -1, 111, 10, 90, -13, -98, 82, -14, -62, -56, 0, 82, -57, 117, -92, -3, 113, 45, 123, 122, 49, 39, 110, -84, -74, 64, 20, 78, -76, -69, -79, 81, 99, 41, -127, 6, -7};
    private static final byte[] DH_private = new byte[]{48, -126, 1, -88, 2, 1, 0, 48, -126, 1, 27, 6, 9, 42, -122, 72, -122, -9, 13, 1, 3, 1, 48, -126, 1, 12, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 2, 2, 3, -2, 4, -127, -125, 2, -127, -128, 53, -2, 68, 10, -93, -96, -53, 82, -62, 50, -54, 56, 31, 24, -21, 39, 110, 119, 37, 64, 31, 100, 93, 75, 89, 65, -74, -53, -33, 115, -32, 1, 90, 121, 13, -115, 8, -26, 127, -122, 88, -49, 127, 75, 46, -37, 76, -33, 117, -75, 22, -60, -87, 73, -18, 0, 86, -96, 96, 8, -114, 13, -57, -55, 69, 12, 93, -73, 76, -60, 126, -85, 31, -22, -49, 8, 109, 5, -95, 127, 99, 111, -77, -111, -93, -31, -80, 54, 2, 63, 85, 113, 56, 55, -102, 25, -93, -81, -56, -43, 34, -35, 0, -127, 25, -74, 60, 95, -39, -33, -3, 88, -79, -26, -47, -46, 88, -17, 68, 110, 102, -110, 30, 48, 11, -112, -114, 41};
    private static final byte[] DH_public = new byte[]{48, -126, 1, -89, 48, -126, 1, 27, 6, 9, 42, -122, 72, -122, -9, 13, 1, 3, 1, 48, -126, 1, 12, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 2, 2, 3, -2, 3, -127, -123, 0, 2, -127, -127, 0, -44, -62, -62, -124, -21, -20, -74, -15, 41, 43, -85, -113, -63, 72, 76, 71, -50, 11, -105, 76, -4, 39, 16, 10, 95, 62, -26, -7, -101, 21, -33, -125, 1, -6, 105, 87, -20, 107, 104, -57, -106, 51, -104, -92, -80, -93, 24, 1, 102, 122, 74, -13, 60, -39, 42, 72, -3, 58, 49, -4, -105, 82, 54, 32, 14, 105, -74, 50, -117, 78, -38, -117, 4, -120, -8, 48, -87, 101, 104, 71, -69, -95, -10, -42, 24, 17, 72, -115, -113, 75, -63, -31, -92, 67, -125, 31, 107, 109, -18, -89, -93, 95, -46, -107, 9, -44, -22, -123, 12, -91, -55, -109, -50, -63, 29, 48, 115, -93, -31, 105, -88, 17, -104, 120, -13, -7, -113, 4};
    private static final HashMap<String, KeySpec> keys = new HashMap();

    public static PrivateKey getPrivateKey(String algorithmName) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory = KeyFactory.getInstance(algorithmName);
        return factory.generatePrivate(keys.get(algorithmName + "_private"));
    }

    public static PublicKey getPublicKey(String algorithmName) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory = KeyFactory.getInstance(algorithmName);
        return factory.generatePublic(keys.get(algorithmName + "_public"));
    }

    static {
        keys.put("DH_public", new X509EncodedKeySpec(DH_public));
        keys.put("DH_private", new PKCS8EncodedKeySpec(DH_private));
        keys.put("DSA_public", new X509EncodedKeySpec(DSA_public));
        keys.put("DSA_private", new PKCS8EncodedKeySpec(DSA_private));
        keys.put("RSA_public", new X509EncodedKeySpec(RSA_public));
        keys.put("RSA_private", new PKCS8EncodedKeySpec(RSA_private));
    }
}

