/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import junit.framework.Assert;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CipherHelper<T>
extends TestHelper<T> {
    private final String algorithmName;
    private final String plainData;
    private final int mode1;
    private final int mode2;

    public CipherHelper(String algorithmName, String plainData, int mode1, int mode2) {
        this.algorithmName = algorithmName;
        this.plainData = plainData;
        this.mode1 = mode1;
        this.mode2 = mode2;
    }

    public void test(Key encryptKey, Key decryptKey) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            cipher.init(this.mode1, encryptKey);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] encrypted = this.crypt(cipher, this.plainData.getBytes());
        try {
            cipher.init(this.mode2, decryptKey);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] decrypted = this.crypt(cipher, encrypted);
        String decryptedString = new String(decrypted);
        Assert.assertEquals((String)"transformed data does not match", (String)this.plainData, (String)decryptedString);
    }

    public byte[] crypt(Cipher cipher, byte[] input) {
        try {
            return cipher.doFinal(input);
        }
        catch (IllegalBlockSizeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (BadPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        return null;
    }
}

