/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import junit.framework.Assert;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmParameterSymmetricHelper
extends TestHelper<AlgorithmParameters> {
    private static final String plainData = "some data to encrypt and decrypt";
    private final String algorithmName;
    private final int keySize;
    private String blockmode;

    public AlgorithmParameterSymmetricHelper(String algorithmName, int keySize) {
        this.algorithmName = algorithmName;
        this.keySize = keySize;
    }

    public AlgorithmParameterSymmetricHelper(String algorithmName, String blockmode, int keySize) {
        this(algorithmName, keySize);
        this.blockmode = blockmode;
    }

    @Override
    public void test(AlgorithmParameters parameters) {
        KeyGenerator generator = null;
        try {
            generator = KeyGenerator.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        generator.init(this.keySize);
        SecretKey key = generator.generateKey();
        Cipher cipher = null;
        try {
            String transformation = this.algorithmName;
            if (this.blockmode != null) {
                transformation = transformation + "/" + this.blockmode;
            }
            cipher = Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            cipher.init(1, (Key)key, parameters);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] bs = null;
        try {
            bs = cipher.doFinal(plainData.getBytes());
        }
        catch (IllegalBlockSizeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (BadPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            cipher.init(2, (Key)key, parameters);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] decrypted = null;
        try {
            decrypted = cipher.doFinal(bs);
        }
        catch (IllegalBlockSizeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (BadPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)Arrays.equals(plainData.getBytes(), decrypted));
    }
}

