/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import junit.framework.Assert;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmParameterSignatureHelper<T extends AlgorithmParameterSpec>
extends TestHelper<AlgorithmParameters> {
    private final String algorithmName;
    private final String plainData = "some data do sign and verify";
    private final Class<T> parameterSpecClass;

    public AlgorithmParameterSignatureHelper(String algorithmName, Class<T> parameterSpecCla1ss) {
        this.algorithmName = algorithmName;
        this.parameterSpecClass = parameterSpecCla1ss;
    }

    @Override
    public void test(AlgorithmParameters parameters) {
        Signature signature = null;
        try {
            signature = Signature.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        AlgorithmParameterSpec parameterSpec = null;
        try {
            parameterSpec = (AlgorithmParameterSpec)parameters.getParameterSpec(this.parameterSpecClass);
        }
        catch (InvalidParameterSpecException e) {
            Assert.fail((String)e.getMessage());
        }
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            generator.initialize(parameterSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
            Assert.fail((String)e.getMessage());
        }
        KeyPair keyPair = generator.genKeyPair();
        try {
            signature.initSign(keyPair.getPrivate());
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            signature.update("some data do sign and verify".getBytes());
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] signed = null;
        try {
            signed = signature.sign();
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            signature.initVerify(keyPair.getPublic());
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            signature.update("some data do sign and verify".getBytes());
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            Assert.assertTrue((String)"signature could not be verified", (boolean)signature.verify(signed));
        }
        catch (SignatureException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

