/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import junit.framework.Assert;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmParameterKeyAgreementHelper
extends TestHelper<AlgorithmParameters> {
    private final String algorithmName;

    public AlgorithmParameterKeyAgreementHelper(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public void test(AlgorithmParameters parameters) {
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        KeyAgreement keyAgreement = null;
        try {
            keyAgreement = KeyAgreement.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            keyAgreement.init(keyPair.getPrivate());
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            keyAgreement.doPhase(keyPair.getPublic(), true);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalStateException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"generated secret is null", (Object)keyAgreement.generateSecret());
    }
}

