/*
 * Decompiled with CFR 0.152.
 */
package tests.security;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import junit.framework.Assert;
import tests.security.TestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmParameterAsymmetricHelper
extends TestHelper<AlgorithmParameters> {
    private static final String plainData = "some data to encrypt and decrypt";
    private final String algorithmName;

    public AlgorithmParameterAsymmetricHelper(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public void test(AlgorithmParameters parameters) {
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            cipher.init(1, (Key)keyPair.getPublic(), parameters);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] bs = null;
        try {
            bs = cipher.doFinal(plainData.getBytes());
        }
        catch (IllegalBlockSizeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (BadPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            cipher.init(2, (Key)keyPair.getPrivate(), parameters);
        }
        catch (InvalidKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            Assert.fail((String)e.getMessage());
        }
        byte[] decrypted = null;
        try {
            decrypted = cipher.doFinal(bs);
        }
        catch (IllegalBlockSizeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (BadPaddingException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)Arrays.equals(plainData.getBytes(), decrypted));
    }
}

