/*
 * Decompiled with CFR 0.152.
 */
package tests.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import tests.http.MockResponse;
import tests.http.RecordedRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockWebServer {
    static final String ASCII = "US-ASCII";
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingDeque<MockResponse>();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean singleResponse;
    private final AtomicInteger requestCount = new AtomicInteger();
    private int bodyLimit = Integer.MAX_VALUE;
    private ServerSocket serverSocket;
    private SSLSocketFactory sslSocketFactory;
    private ExecutorService executor;
    private boolean tunnelProxy;
    private int port = -1;

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Cannot retrieve port before calling play()");
        }
        return this.port;
    }

    public Proxy toProxyAddress() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", this.getPort()));
    }

    public URL getUrl(String path) throws MalformedURLException, UnknownHostException {
        String host = InetAddress.getLocalHost().getHostName();
        return this.sslSocketFactory != null ? new URL("https://" + host + ":" + this.getPort() + path) : new URL("http://" + host + ":" + this.getPort() + path);
    }

    public void setBodyLimit(int maxBodyLength) {
        this.bodyLimit = maxBodyLength;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void enqueue(MockResponse response) {
        this.responseQueue.add(response);
    }

    public void setSingleResponse(boolean singleResponse) {
        this.singleResponse = singleResponse;
    }

    public void play() throws IOException {
        this.executor = Executors.newCachedThreadPool();
        this.serverSocket = new ServerSocket(0);
        this.serverSocket.setReuseAddress(true);
        this.port = this.serverSocket.getLocalPort();
        this.executor.submit(MockWebServer.namedCallable("MockWebServer-accept-" + this.port, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ArrayList<Throwable> failures = new ArrayList<Throwable>();
                try {
                    this.acceptConnections();
                }
                catch (Throwable e) {
                    failures.add(e);
                }
                try {
                    MockWebServer.this.serverSocket.close();
                }
                catch (Throwable e) {
                    failures.add(e);
                }
                Iterator s = MockWebServer.this.openClientSockets.iterator();
                while (s.hasNext()) {
                    try {
                        ((Socket)s.next()).close();
                        s.remove();
                    }
                    catch (Throwable e) {
                        failures.add(e);
                    }
                }
                try {
                    MockWebServer.this.executor.shutdown();
                }
                catch (Throwable e) {
                    failures.add(e);
                }
                if (!failures.isEmpty()) {
                    Throwable thrown = (Throwable)failures.get(0);
                    if (thrown instanceof Exception) {
                        throw (Exception)thrown;
                    }
                    throw (Error)thrown;
                }
                return null;
            }

            public void acceptConnections() throws Exception {
                int count = 0;
                while (count <= 0 || !MockWebServer.this.responseQueue.isEmpty()) {
                    Socket socket = MockWebServer.this.serverSocket.accept();
                    if (((MockResponse)MockWebServer.this.responseQueue.peek()).getDisconnectAtStart()) {
                        MockWebServer.this.responseQueue.take();
                        socket.close();
                        continue;
                    }
                    MockWebServer.this.openClientSockets.add(socket);
                    MockWebServer.this.serveConnection(socket);
                    ++count;
                }
                return;
            }
        }));
    }

    public void shutdown() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    private void serveConnection(final Socket raw) {
        String name = "MockWebServer-" + raw.getRemoteSocketAddress();
        this.executor.submit(MockWebServer.namedCallable(name, new Callable<Void>(){
            int sequenceNumber = 0;

            @Override
            public Void call() throws Exception {
                Socket socket;
                if (MockWebServer.this.sslSocketFactory != null) {
                    if (MockWebServer.this.tunnelProxy && !this.processOneRequest(raw.getInputStream(), raw.getOutputStream())) {
                        throw new IllegalStateException("Tunnel without any CONNECT!");
                    }
                    socket = MockWebServer.this.sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
                    ((SSLSocket)socket).setUseClientMode(false);
                } else {
                    socket = raw;
                }
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
                if (!this.processOneRequest(in, out)) {
                    throw new IllegalStateException("Connection without any request!");
                }
                while (this.processOneRequest(in, out)) {
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                raw.close();
                MockWebServer.this.openClientSockets.remove(raw);
                return null;
            }

            private boolean processOneRequest(InputStream in, OutputStream out) throws IOException, InterruptedException {
                RecordedRequest request = MockWebServer.this.readRequest(in, this.sequenceNumber);
                if (request == null) {
                    return false;
                }
                MockResponse response = MockWebServer.this.dispatch(request);
                MockWebServer.this.writeResponse(out, response);
                if (response.getDisconnectAtEnd()) {
                    in.close();
                    out.close();
                }
                ++this.sequenceNumber;
                return true;
            }
        }));
    }

    private RecordedRequest readRequest(InputStream in, int sequenceNumber) throws IOException {
        String header;
        String request = this.readAsciiUntilCrlf(in);
        if (request.isEmpty()) {
            return null;
        }
        ArrayList<String> headers = new ArrayList<String>();
        int contentLength = -1;
        boolean chunked = false;
        while (!(header = this.readAsciiUntilCrlf(in)).isEmpty()) {
            headers.add(header);
            String lowercaseHeader = header.toLowerCase();
            if (contentLength == -1 && lowercaseHeader.startsWith("content-length:")) {
                contentLength = Integer.parseInt(header.substring(15).trim());
            }
            if (!lowercaseHeader.startsWith("transfer-encoding:") || !lowercaseHeader.substring(18).trim().equals("chunked")) continue;
            chunked = true;
        }
        boolean hasBody = false;
        TruncatingOutputStream requestBody = new TruncatingOutputStream();
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        if (contentLength != -1) {
            hasBody = true;
            this.transfer(contentLength, in, requestBody);
        } else if (chunked) {
            hasBody = true;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(this.readAsciiUntilCrlf(in).trim(), 16)) == 0) {
                    this.readEmptyLine(in);
                    break;
                }
                chunkSizes.add(chunkSize);
                this.transfer(chunkSize, in, requestBody);
                this.readEmptyLine(in);
            }
        }
        if (request.startsWith("GET ") || request.startsWith("CONNECT ")) {
            if (hasBody) {
                throw new IllegalArgumentException("GET requests should not have a body!");
            }
        } else if (request.startsWith("POST ")) {
            if (!hasBody) {
                throw new IllegalArgumentException("POST requests must have a body!");
            }
        } else {
            throw new UnsupportedOperationException("Unexpected method: " + request);
        }
        return new RecordedRequest(request, headers, chunkSizes, requestBody.numBytesReceived, requestBody.toByteArray(), sequenceNumber);
    }

    private MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        if (this.responseQueue.isEmpty()) {
            throw new IllegalStateException("Unexpected request: " + request);
        }
        if (this.singleResponse) {
            return (MockResponse)this.responseQueue.peek();
        }
        this.requestCount.incrementAndGet();
        this.requestQueue.add(request);
        return this.responseQueue.take();
    }

    private void writeResponse(OutputStream out, MockResponse response) throws IOException {
        out.write((response.getStatus() + "\r\n").getBytes(ASCII));
        for (String header : response.getHeaders()) {
            out.write((header + "\r\n").getBytes(ASCII));
        }
        out.write("\r\n".getBytes(ASCII));
        out.write(response.getBody());
        out.flush();
    }

    private void transfer(int length, InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        while (length > 0) {
            int count = in.read(buffer, 0, Math.min(buffer.length, length));
            if (count == -1) {
                return;
            }
            out.write(buffer, 0, count);
            length -= count;
        }
    }

    private String readAsciiUntilCrlf(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int c;
            if ((c = in.read()) == 10 && builder.length() > 0 && builder.charAt(builder.length() - 1) == '\r') {
                builder.deleteCharAt(builder.length() - 1);
                return builder.toString();
            }
            if (c == -1) {
                return builder.toString();
            }
            builder.append((char)c);
        }
    }

    private void readEmptyLine(InputStream in) throws IOException {
        String line = this.readAsciiUntilCrlf(in);
        if (!line.isEmpty()) {
            throw new IllegalStateException("Expected empty but was: " + line);
        }
    }

    private static <T> Callable<T> namedCallable(final String name, final Callable<T> callable) {
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                String originalName = Thread.currentThread().getName();
                Thread.currentThread().setName(name);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    Thread.currentThread().setName(originalName);
                }
            }
        };
    }

    private class TruncatingOutputStream
    extends ByteArrayOutputStream {
        private int numBytesReceived = 0;

        private TruncatingOutputStream() {
        }

        public void write(byte[] buffer, int offset, int len) {
            this.numBytesReceived += len;
            super.write(buffer, offset, Math.min(len, MockWebServer.this.bodyLimit - this.count));
        }

        public void write(int oneByte) {
            ++this.numBytesReceived;
            if (this.count < MockWebServer.this.bodyLimit) {
                super.write(oneByte);
            }
        }
    }
}

