/*
 * Decompiled with CFR 0.152.
 */
package tests.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResponse {
    private static final String EMPTY_BODY_HEADER = "Content-Length: 0";
    private static final String CHUNKED_BODY_HEADER = "Transfer-encoding: chunked";
    private static final byte[] EMPTY_BODY = new byte[0];
    private String status = "HTTP/1.1 200 OK";
    private List<String> headers = new ArrayList<String>();
    private byte[] body = EMPTY_BODY;
    private boolean disconnectAtStart;
    private boolean disconnectAtEnd;

    public MockResponse() {
        this.headers.add(EMPTY_BODY_HEADER);
    }

    public String getStatus() {
        return this.status;
    }

    public MockResponse setResponseCode(int code) {
        this.status = "HTTP/1.1 " + code + " OK";
        return this;
    }

    public MockResponse setStatus(String status) {
        this.status = status;
        return this;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public MockResponse clearHeaders() {
        this.headers.clear();
        return this;
    }

    public MockResponse addHeader(String header) {
        this.headers.add(header);
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public MockResponse setBody(byte[] body) {
        if (this.body == EMPTY_BODY) {
            this.headers.remove(EMPTY_BODY_HEADER);
        }
        this.headers.add("Content-Length: " + body.length);
        this.body = body;
        return this;
    }

    public MockResponse setBody(String body) {
        try {
            return this.setBody(body.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    public MockResponse setChunkedBody(byte[] body, int maxChunkSize) throws IOException {
        int chunkSize;
        this.headers.remove(EMPTY_BODY_HEADER);
        this.headers.add(CHUNKED_BODY_HEADER);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        for (int pos = 0; pos < body.length; pos += chunkSize) {
            chunkSize = Math.min(body.length - pos, maxChunkSize);
            bytesOut.write(Integer.toHexString(chunkSize).getBytes("US-ASCII"));
            bytesOut.write("\r\n".getBytes("US-ASCII"));
            bytesOut.write(body, pos, chunkSize);
            bytesOut.write("\r\n".getBytes("US-ASCII"));
        }
        bytesOut.write("0\r\n\r\n".getBytes("US-ASCII"));
        this.body = bytesOut.toByteArray();
        return this;
    }

    public MockResponse setChunkedBody(String body, int maxChunkSize) throws IOException {
        return this.setChunkedBody(body.getBytes("US-ASCII"), maxChunkSize);
    }

    public MockResponse setDisconnectAtStart(boolean disconnectAtStart) {
        this.disconnectAtStart = disconnectAtStart;
        return this;
    }

    public boolean getDisconnectAtStart() {
        return this.disconnectAtStart;
    }

    public MockResponse setDisconnectAtEnd(boolean disconnectAtEnd) {
        this.disconnectAtEnd = disconnectAtEnd;
        return this;
    }

    public boolean getDisconnectAtEnd() {
        return this.disconnectAtEnd;
    }

    public String toString() {
        return this.status;
    }
}

