/*
 * Decompiled with CFR 0.152.
 */
package tests.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultResponseCache
extends ResponseCache {
    private final Map<URI, Entry> entries = new HashMap<URI, Entry>();
    private int abortCount;
    private int successCount;
    private int hitCount;
    private int missCount;

    @Override
    public synchronized CacheResponse get(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) throws IOException {
        Entry entry = this.entries.get(uri);
        if (entry != null) {
            ++this.hitCount;
            return entry.asResponse();
        }
        ++this.missCount;
        return null;
    }

    @Override
    public CacheRequest put(URI uri, URLConnection urlConnection) throws IOException {
        return new Entry(uri, urlConnection).asRequest();
    }

    public synchronized Map<URI, Entry> getContents() {
        return new HashMap<URI, Entry>(this.entries);
    }

    public synchronized int getAbortCount() {
        return this.abortCount;
    }

    public synchronized int getSuccessCount() {
        return this.successCount;
    }

    public synchronized int getHitCount() {
        return this.hitCount;
    }

    public synchronized int getMissCount() {
        return this.missCount;
    }

    private static Map<String, List<String>> deepCopy(Map<String, List<String>> input) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(input);
        for (Map.Entry entry : result.entrySet()) {
            entry.setValue(new ArrayList((Collection)entry.getValue()));
        }
        return result;
    }

    public final class Entry {
        private final ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(){
            private boolean closed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                DefaultResponseCache defaultResponseCache = DefaultResponseCache.this;
                synchronized (defaultResponseCache) {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    DefaultResponseCache.this.entries.put(Entry.this.uri, Entry.this);
                    DefaultResponseCache.this.successCount++;
                    this.closed = true;
                }
            }
        };
        private final Map<String, List<String>> headers;
        private final URI uri;

        private Entry(URI uri, URLConnection conn) {
            this.uri = uri;
            this.headers = DefaultResponseCache.deepCopy(conn.getHeaderFields());
        }

        public CacheRequest asRequest() {
            return new CacheRequest(){
                private boolean aborted;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void abort() {
                    DefaultResponseCache defaultResponseCache = DefaultResponseCache.this;
                    synchronized (defaultResponseCache) {
                        if (this.aborted) {
                            return;
                        }
                        DefaultResponseCache.this.abortCount++;
                        this.aborted = true;
                    }
                }

                public OutputStream getBody() throws IOException {
                    return Entry.this.bytesOut;
                }
            };
        }

        public CacheResponse asResponse() {
            return new CacheResponse(){

                @Override
                public InputStream getBody() throws IOException {
                    return new ByteArrayInputStream(Entry.this.getBytes());
                }

                @Override
                public Map<String, List<String>> getHeaders() throws IOException {
                    return DefaultResponseCache.deepCopy(Entry.this.headers);
                }
            };
        }

        public byte[] getBytes() {
            return this.bytesOut.toByteArray();
        }
    }
}

