/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class TimeUnitTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(TimeUnitTest.class);
    }

    public void testConvert() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)(t * 60L * 60L * 24L), (long)TimeUnit.SECONDS.convert(t, TimeUnit.DAYS));
            TimeUnitTest.assertEquals((long)(t * 60L * 60L), (long)TimeUnit.SECONDS.convert(t, TimeUnit.HOURS));
            TimeUnitTest.assertEquals((long)(t * 60L), (long)TimeUnit.SECONDS.convert(t, TimeUnit.MINUTES));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.convert(t, TimeUnit.SECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.convert(1000L * t, TimeUnit.MILLISECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.convert(1000000L * t, TimeUnit.MICROSECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.convert(1000000000L * t, TimeUnit.NANOSECONDS));
            TimeUnitTest.assertEquals((long)(1000L * t * 60L * 60L * 24L), (long)TimeUnit.MILLISECONDS.convert(t, TimeUnit.DAYS));
            TimeUnitTest.assertEquals((long)(1000L * t * 60L * 60L), (long)TimeUnit.MILLISECONDS.convert(t, TimeUnit.HOURS));
            TimeUnitTest.assertEquals((long)(1000L * t * 60L), (long)TimeUnit.MILLISECONDS.convert(t, TimeUnit.MINUTES));
            TimeUnitTest.assertEquals((long)(1000L * t), (long)TimeUnit.MILLISECONDS.convert(t, TimeUnit.SECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.convert(t, TimeUnit.MILLISECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.convert(1000L * t, TimeUnit.MICROSECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.convert(1000000L * t, TimeUnit.NANOSECONDS));
            TimeUnitTest.assertEquals((long)(1000000L * t * 60L * 60L * 24L), (long)TimeUnit.MICROSECONDS.convert(t, TimeUnit.DAYS));
            TimeUnitTest.assertEquals((long)(1000000L * t * 60L * 60L), (long)TimeUnit.MICROSECONDS.convert(t, TimeUnit.HOURS));
            TimeUnitTest.assertEquals((long)(1000000L * t * 60L), (long)TimeUnit.MICROSECONDS.convert(t, TimeUnit.MINUTES));
            TimeUnitTest.assertEquals((long)(1000000L * t), (long)TimeUnit.MICROSECONDS.convert(t, TimeUnit.SECONDS));
            TimeUnitTest.assertEquals((long)(1000L * t), (long)TimeUnit.MICROSECONDS.convert(t, TimeUnit.MILLISECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.convert(t, TimeUnit.MICROSECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.convert(1000L * t, TimeUnit.NANOSECONDS));
            TimeUnitTest.assertEquals((long)(1000000000L * t * 60L * 60L * 24L), (long)TimeUnit.NANOSECONDS.convert(t, TimeUnit.DAYS));
            TimeUnitTest.assertEquals((long)(1000000000L * t * 60L * 60L), (long)TimeUnit.NANOSECONDS.convert(t, TimeUnit.HOURS));
            TimeUnitTest.assertEquals((long)(1000000000L * t * 60L), (long)TimeUnit.NANOSECONDS.convert(t, TimeUnit.MINUTES));
            TimeUnitTest.assertEquals((long)(1000000000L * t), (long)TimeUnit.NANOSECONDS.convert(t, TimeUnit.SECONDS));
            TimeUnitTest.assertEquals((long)(1000000L * t), (long)TimeUnit.NANOSECONDS.convert(t, TimeUnit.MILLISECONDS));
            TimeUnitTest.assertEquals((long)(1000L * t), (long)TimeUnit.NANOSECONDS.convert(t, TimeUnit.MICROSECONDS));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.convert(t, TimeUnit.NANOSECONDS));
        }
    }

    public void testToNanos() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)(t * 1000000000L * 60L * 60L * 24L), (long)TimeUnit.DAYS.toNanos(t));
            TimeUnitTest.assertEquals((long)(t * 1000000000L * 60L * 60L), (long)TimeUnit.HOURS.toNanos(t));
            TimeUnitTest.assertEquals((long)(t * 1000000000L * 60L), (long)TimeUnit.MINUTES.toNanos(t));
            TimeUnitTest.assertEquals((long)(1000000000L * t), (long)TimeUnit.SECONDS.toNanos(t));
            TimeUnitTest.assertEquals((long)(1000000L * t), (long)TimeUnit.MILLISECONDS.toNanos(t));
            TimeUnitTest.assertEquals((long)(1000L * t), (long)TimeUnit.MICROSECONDS.toNanos(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.toNanos(t));
        }
    }

    public void testToMicros() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)(t * 1000000L * 60L * 60L * 24L), (long)TimeUnit.DAYS.toMicros(t));
            TimeUnitTest.assertEquals((long)(t * 1000000L * 60L * 60L), (long)TimeUnit.HOURS.toMicros(t));
            TimeUnitTest.assertEquals((long)(t * 1000000L * 60L), (long)TimeUnit.MINUTES.toMicros(t));
            TimeUnitTest.assertEquals((long)(1000000L * t), (long)TimeUnit.SECONDS.toMicros(t));
            TimeUnitTest.assertEquals((long)(1000L * t), (long)TimeUnit.MILLISECONDS.toMicros(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.toMicros(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.toMicros(t * 1000L));
        }
    }

    public void testToMillis() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)(t * 1000L * 60L * 60L * 24L), (long)TimeUnit.DAYS.toMillis(t));
            TimeUnitTest.assertEquals((long)(t * 1000L * 60L * 60L), (long)TimeUnit.HOURS.toMillis(t));
            TimeUnitTest.assertEquals((long)(t * 1000L * 60L), (long)TimeUnit.MINUTES.toMillis(t));
            TimeUnitTest.assertEquals((long)(1000L * t), (long)TimeUnit.SECONDS.toMillis(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.toMillis(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.toMillis(t * 1000L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.toMillis(t * 1000000L));
        }
    }

    public void testToSeconds() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)(t * 60L * 60L * 24L), (long)TimeUnit.DAYS.toSeconds(t));
            TimeUnitTest.assertEquals((long)(t * 60L * 60L), (long)TimeUnit.HOURS.toSeconds(t));
            TimeUnitTest.assertEquals((long)(t * 60L), (long)TimeUnit.MINUTES.toSeconds(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.toSeconds(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.toSeconds(t * 1000L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.toSeconds(t * 1000000L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.toSeconds(t * 1000000000L));
        }
    }

    public void testToMinutes() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)(t * 60L * 24L), (long)TimeUnit.DAYS.toMinutes(t));
            TimeUnitTest.assertEquals((long)(t * 60L), (long)TimeUnit.HOURS.toMinutes(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MINUTES.toMinutes(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.toMinutes(t * 60L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.toMinutes(t * 1000L * 60L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.toMinutes(t * 1000000L * 60L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.toMinutes(t * 1000000000L * 60L));
        }
    }

    public void testToHours() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)(t * 24L), (long)TimeUnit.DAYS.toHours(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.HOURS.toHours(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MINUTES.toHours(t * 60L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.toHours(t * 60L * 60L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.toHours(t * 1000L * 60L * 60L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.toHours(t * 1000000L * 60L * 60L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.toHours(t * 1000000000L * 60L * 60L));
        }
    }

    public void testToDays() {
        for (long t = 0L; t < 88888L; ++t) {
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.DAYS.toDays(t));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.HOURS.toDays(t * 24L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MINUTES.toDays(t * 60L * 24L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.SECONDS.toDays(t * 60L * 60L * 24L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MILLISECONDS.toDays(t * 1000L * 60L * 60L * 24L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.MICROSECONDS.toDays(t * 1000000L * 60L * 60L * 24L));
            TimeUnitTest.assertEquals((long)t, (long)TimeUnit.NANOSECONDS.toDays(t * 1000000000L * 60L * 60L * 24L));
        }
    }

    public void testConvertSaturate() {
        TimeUnitTest.assertEquals((long)Long.MAX_VALUE, (long)TimeUnit.NANOSECONDS.convert(0x3FFFFFFFFFFFFFFFL, TimeUnit.SECONDS));
        TimeUnitTest.assertEquals((long)Long.MIN_VALUE, (long)TimeUnit.NANOSECONDS.convert(-2305843009213693951L, TimeUnit.SECONDS));
        TimeUnitTest.assertEquals((long)Long.MAX_VALUE, (long)TimeUnit.NANOSECONDS.convert(0x3FFFFFFFFFFFFFFFL, TimeUnit.MINUTES));
        TimeUnitTest.assertEquals((long)Long.MIN_VALUE, (long)TimeUnit.NANOSECONDS.convert(-2305843009213693951L, TimeUnit.MINUTES));
        TimeUnitTest.assertEquals((long)Long.MAX_VALUE, (long)TimeUnit.NANOSECONDS.convert(0x3FFFFFFFFFFFFFFFL, TimeUnit.HOURS));
        TimeUnitTest.assertEquals((long)Long.MIN_VALUE, (long)TimeUnit.NANOSECONDS.convert(-2305843009213693951L, TimeUnit.HOURS));
        TimeUnitTest.assertEquals((long)Long.MAX_VALUE, (long)TimeUnit.NANOSECONDS.convert(0x3FFFFFFFFFFFFFFFL, TimeUnit.DAYS));
        TimeUnitTest.assertEquals((long)Long.MIN_VALUE, (long)TimeUnit.NANOSECONDS.convert(-2305843009213693951L, TimeUnit.DAYS));
    }

    public void testToNanosSaturate() {
        TimeUnitTest.assertEquals((long)Long.MAX_VALUE, (long)TimeUnit.MILLISECONDS.toNanos(0x3FFFFFFFFFFFFFFFL));
        TimeUnitTest.assertEquals((long)Long.MIN_VALUE, (long)TimeUnit.MILLISECONDS.toNanos(-3074457345618258602L));
    }

    public void testToString() {
        String s = TimeUnit.SECONDS.toString();
        TimeUnitTest.assertTrue((s.indexOf("ECOND") >= 0 ? 1 : 0) != 0);
    }

    public void testTimedWait_IllegalMonitorException() throws Exception {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Object o = new Object();
                TimeUnit tu = TimeUnit.MILLISECONDS;
                try {
                    tu.timedWait(o, JSR166TestCase.LONG_DELAY_MS);
                    TimeUnitTest.this.threadShouldThrow();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedWait() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void realRun() throws InterruptedException {
                Object o = new Object();
                TimeUnit tu = TimeUnit.MILLISECONDS;
                Object object = o;
                synchronized (object) {
                    tu.timedWait(o, JSR166TestCase.MEDIUM_DELAY_MS);
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedJoin() throws InterruptedException {
        final Thread s = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                Thread.sleep(JSR166TestCase.MEDIUM_DELAY_MS);
            }
        });
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                TimeUnit tu = TimeUnit.MILLISECONDS;
                tu.timedJoin(s, JSR166TestCase.MEDIUM_DELAY_MS);
            }
        });
        s.start();
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        s.interrupt();
        s.join();
    }

    public void testTimedSleep() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                TimeUnit tu = TimeUnit.MILLISECONDS;
                tu.sleep(JSR166TestCase.MEDIUM_DELAY_MS);
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testSerialization() throws Exception {
        TimeUnit q = TimeUnit.MILLISECONDS;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject((Object)q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        TimeUnit r = (TimeUnit)((Object)in.readObject());
        TimeUnitTest.assertSame((Object)((Object)q), (Object)((Object)r));
    }
}

