/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ThreadPoolExecutorTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ThreadPoolExecutorTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecute() throws InterruptedException {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p1.execute(new JSR166TestCase.ShortRunnable());
            Thread.sleep(SMALL_DELAY_MS);
        }
        finally {
            this.joinPool(p1);
        }
    }

    public void testGetActiveCount() throws InterruptedException {
        ThreadPoolExecutor p2 = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)0, (int)p2.getActiveCount());
        p2.execute(new JSR166TestCase.MediumRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ThreadPoolExecutorTest.assertEquals((int)1, (int)p2.getActiveCount());
        this.joinPool(p2);
    }

    public void testPrestartCoreThread() {
        ThreadPoolExecutor p2 = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)0, (int)p2.getPoolSize());
        ThreadPoolExecutorTest.assertTrue((boolean)p2.prestartCoreThread());
        ThreadPoolExecutorTest.assertEquals((int)1, (int)p2.getPoolSize());
        ThreadPoolExecutorTest.assertTrue((boolean)p2.prestartCoreThread());
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p2.getPoolSize());
        ThreadPoolExecutorTest.assertFalse((boolean)p2.prestartCoreThread());
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p2.getPoolSize());
        this.joinPool(p2);
    }

    public void testPrestartAllCoreThreads() {
        ThreadPoolExecutor p2 = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)0, (int)p2.getPoolSize());
        p2.prestartAllCoreThreads();
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p2.getPoolSize());
        p2.prestartAllCoreThreads();
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p2.getPoolSize());
        this.joinPool(p2);
    }

    public void testGetCompletedTaskCount() throws InterruptedException {
        ThreadPoolExecutor p2 = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((long)0L, (long)p2.getCompletedTaskCount());
        p2.execute(new JSR166TestCase.ShortRunnable());
        Thread.sleep(SMALL_DELAY_MS);
        ThreadPoolExecutorTest.assertEquals((long)1L, (long)p2.getCompletedTaskCount());
        try {
            p2.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p2);
    }

    public void testGetCorePoolSize() {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)1, (int)p1.getCorePoolSize());
        this.joinPool(p1);
    }

    public void testGetKeepAliveTime() {
        ThreadPoolExecutor p2 = new ThreadPoolExecutor(2, 2, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((long)1L, (long)p2.getKeepAliveTime(TimeUnit.SECONDS));
        this.joinPool(p2);
    }

    public void testGetThreadFactory() {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), tf, new JSR166TestCase.NoOpREHandler());
        ThreadPoolExecutorTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    public void testSetThreadFactory() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        p.setThreadFactory(tf);
        ThreadPoolExecutorTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetThreadFactoryNull() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setThreadFactory(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testGetRejectedExecutionHandler() {
        JSR166TestCase.NoOpREHandler h = new JSR166TestCase.NoOpREHandler();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), h);
        ThreadPoolExecutorTest.assertSame((Object)h, (Object)p.getRejectedExecutionHandler());
        this.joinPool(p);
    }

    public void testSetRejectedExecutionHandler() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        JSR166TestCase.NoOpREHandler h = new JSR166TestCase.NoOpREHandler();
        p.setRejectedExecutionHandler(h);
        ThreadPoolExecutorTest.assertSame((Object)h, (Object)p.getRejectedExecutionHandler());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRejectedExecutionHandlerNull() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setRejectedExecutionHandler(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testGetLargestPoolSize() throws InterruptedException {
        ThreadPoolExecutor p2 = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)0, (int)p2.getLargestPoolSize());
        p2.execute(new JSR166TestCase.MediumRunnable());
        p2.execute(new JSR166TestCase.MediumRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p2.getLargestPoolSize());
        this.joinPool(p2);
    }

    public void testGetMaximumPoolSize() {
        ThreadPoolExecutor p2 = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p2.getMaximumPoolSize());
        this.joinPool(p2);
    }

    public void testGetPoolSize() {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)0, (int)p1.getPoolSize());
        p1.execute(new JSR166TestCase.MediumRunnable());
        ThreadPoolExecutorTest.assertEquals((int)1, (int)p1.getPoolSize());
        this.joinPool(p1);
    }

    public void testGetTaskCount() throws InterruptedException {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((long)0L, (long)p1.getTaskCount());
        p1.execute(new JSR166TestCase.MediumRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ThreadPoolExecutorTest.assertEquals((long)1L, (long)p1.getTaskCount());
        this.joinPool(p1);
    }

    public void testIsShutdown() {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertFalse((boolean)p1.isShutdown());
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p1.isShutdown());
        this.joinPool(p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminated() throws InterruptedException {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertFalse((boolean)p1.isTerminated());
        try {
            p1.execute(new JSR166TestCase.MediumRunnable());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ThreadPoolExecutorTest.assertTrue((boolean)p1.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminating() throws InterruptedException {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertFalse((boolean)p1.isTerminating());
        try {
            p1.execute(new JSR166TestCase.SmallRunnable());
            ThreadPoolExecutorTest.assertFalse((boolean)p1.isTerminating());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ThreadPoolExecutorTest.assertTrue((boolean)p1.isTerminated());
        ThreadPoolExecutorTest.assertFalse((boolean)p1.isTerminating());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetQueue() throws InterruptedException {
        ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(10);
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, q);
        FutureTask[] tasks = new FutureTask[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = new FutureTask<Boolean>(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), Boolean.TRUE);
            p1.execute(tasks[i]);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            BlockingQueue<Runnable> wq = p1.getQueue();
            ThreadPoolExecutorTest.assertSame(q, wq);
            ThreadPoolExecutorTest.assertFalse((boolean)wq.contains(tasks[0]));
            ThreadPoolExecutorTest.assertTrue((boolean)wq.contains(tasks[4]));
            for (int i = 1; i < 5; ++i) {
                tasks[i].cancel(true);
            }
            p1.shutdownNow();
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemove() throws InterruptedException {
        ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(10);
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, q);
        FutureTask[] tasks = new FutureTask[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = new FutureTask<Boolean>(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), Boolean.TRUE);
            p1.execute(tasks[i]);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            ThreadPoolExecutorTest.assertFalse((boolean)p1.remove(tasks[0]));
            ThreadPoolExecutorTest.assertTrue((boolean)q.contains(tasks[4]));
            ThreadPoolExecutorTest.assertTrue((boolean)q.contains(tasks[3]));
            ThreadPoolExecutorTest.assertTrue((boolean)p1.remove(tasks[4]));
            ThreadPoolExecutorTest.assertFalse((boolean)p1.remove(tasks[4]));
            ThreadPoolExecutorTest.assertFalse((boolean)q.contains(tasks[4]));
            ThreadPoolExecutorTest.assertTrue((boolean)q.contains(tasks[3]));
            ThreadPoolExecutorTest.assertTrue((boolean)p1.remove(tasks[3]));
            ThreadPoolExecutorTest.assertFalse((boolean)q.contains(tasks[3]));
        }
        finally {
            this.joinPool(p1);
        }
    }

    public void testPurge() {
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        FutureTask[] tasks = new FutureTask[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = new FutureTask<Boolean>(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), Boolean.TRUE);
            p1.execute(tasks[i]);
        }
        tasks[4].cancel(true);
        tasks[3].cancel(true);
        p1.purge();
        long count = p1.getTaskCount();
        ThreadPoolExecutorTest.assertTrue((count >= 2L && count < 5L ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutDownNow() {
        List<Runnable> l;
        ThreadPoolExecutor p1 = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            for (int i = 0; i < 5; ++i) {
                p1.execute(new JSR166TestCase.MediumPossiblyInterruptedRunnable());
            }
        }
        finally {
            try {
                l = p1.shutdownNow();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p1.isShutdown());
        ThreadPoolExecutorTest.assertTrue((l.size() <= 4 ? 1 : 0) != 0);
    }

    public void testConstructor1() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor7() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor8() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor9() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor10() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException2() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null, new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException3() {
        try {
            ThreadFactory f = null;
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), f);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor11() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor12() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor13() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor14() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor15() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException4() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null, new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException5() {
        try {
            RejectedExecutionHandler r = null;
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), r);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor16() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor17() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor18() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor19() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor20() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException6() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null, new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException7() {
        try {
            RejectedExecutionHandler r = null;
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), r);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException8() {
        try {
            ThreadFactory f = null;
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), f, new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        try {
            int i;
            for (i = 0; i < 2; ++i) {
                p.execute(new JSR166TestCase.MediumRunnable());
            }
            for (i = 0; i < 2; ++i) {
                try {
                    p.execute(new JSR166TestCase.MediumRunnable());
                    this.shouldThrow();
                    continue;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute2() {
        ThreadPoolExecutor.CallerRunsPolicy h = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            int i;
            JSR166TestCase.TrackedNoOpRunnable[] tasks = new JSR166TestCase.TrackedNoOpRunnable[5];
            for (int i2 = 0; i2 < 5; ++i2) {
                tasks[i2] = new JSR166TestCase.TrackedNoOpRunnable();
            }
            JSR166TestCase.TrackedLongRunnable mr = new JSR166TestCase.TrackedLongRunnable();
            p.execute(mr);
            for (i = 0; i < 5; ++i) {
                p.execute(tasks[i]);
            }
            for (i = 1; i < 5; ++i) {
                ThreadPoolExecutorTest.assertTrue((boolean)tasks[i].done);
            }
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute3() {
        ThreadPoolExecutor.DiscardPolicy h = new ThreadPoolExecutor.DiscardPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            int i;
            JSR166TestCase.TrackedNoOpRunnable[] tasks = new JSR166TestCase.TrackedNoOpRunnable[5];
            for (i = 0; i < 5; ++i) {
                tasks[i] = new JSR166TestCase.TrackedNoOpRunnable();
            }
            p.execute(new JSR166TestCase.TrackedLongRunnable());
            for (i = 0; i < 5; ++i) {
                p.execute(tasks[i]);
            }
            for (i = 0; i < 5; ++i) {
                ThreadPoolExecutorTest.assertFalse((boolean)tasks[i].done);
            }
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute4() {
        ThreadPoolExecutor.DiscardOldestPolicy h = new ThreadPoolExecutor.DiscardOldestPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.execute(new JSR166TestCase.TrackedLongRunnable());
            JSR166TestCase.TrackedLongRunnable r2 = new JSR166TestCase.TrackedLongRunnable();
            p.execute(r2);
            ThreadPoolExecutorTest.assertTrue((boolean)p.getQueue().contains(r2));
            JSR166TestCase.TrackedNoOpRunnable r3 = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r3);
            ThreadPoolExecutorTest.assertFalse((boolean)p.getQueue().contains(r2));
            ThreadPoolExecutorTest.assertTrue((boolean)p.getQueue().contains(r3));
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testRejectedExecutionExceptionOnShutdown() {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        try {
            tpe.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            tpe.execute(new JSR166TestCase.NoOpRunnable());
            this.shouldThrow();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallerRunsOnShutdown() {
        ThreadPoolExecutor.CallerRunsPolicy h = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscardOnShutdown() {
        ThreadPoolExecutor.DiscardPolicy h = new ThreadPoolExecutor.DiscardPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscardOldestOnShutdown() {
        ThreadPoolExecutor.DiscardOldestPolicy h = new ThreadPoolExecutor.DiscardOldestPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testExecuteNull() {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.execute(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorePoolSizeIllegalArgumentException() {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setCorePoolSize(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaximumPoolSizeIllegalArgumentException() {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setMaximumPoolSize(1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaximumPoolSizeIllegalArgumentException2() {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setMaximumPoolSize(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKeepAliveTimeIllegalArgumentException() {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setKeepAliveTime(-1L, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    public void testTerminated() {
        ExtendedTPE tpe = new ExtendedTPE();
        try {
            tpe.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ThreadPoolExecutorTest.assertTrue((boolean)tpe.terminatedCalled);
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBeforeAfter() throws InterruptedException {
        ExtendedTPE tpe = new ExtendedTPE();
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            tpe.execute(r);
            Thread.sleep(SHORT_DELAY_MS);
            ThreadPoolExecutorTest.assertTrue((boolean)r.done);
            ThreadPoolExecutorTest.assertTrue((boolean)tpe.beforeCalled);
            ThreadPoolExecutorTest.assertTrue((boolean)tpe.afterCalled);
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                this.joinPool(tpe);
                return;
            }
        }
        finally {
            this.joinPool(tpe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitCallable() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<String> future = e.submit(new JSR166TestCase.StringTask());
            String result = future.get();
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
            future.get();
            ThreadPoolExecutorTest.assertTrue((boolean)future.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable2() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<String> future = e.submit(new JSR166TestCase.NoOpRunnable(), "a test string");
            String result = future.get();
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws InterruptedException {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            List r = e.invokeAll(new ArrayList());
            ThreadPoolExecutorTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
            l.add(new JSR166TestCase.NPETask());
            List futures = e.invokeAll(l);
            ThreadPoolExecutorTest.assertEquals((int)1, (int)futures.size());
            try {
                futures.get(0).get();
                this.shouldThrow();
            }
            catch (ExecutionException success) {
                ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            ThreadPoolExecutorTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ThreadPoolExecutorTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws InterruptedException {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
        ThreadPoolExecutorTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ThreadPoolExecutorTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll6() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
            l.add(new JSR166TestCase.StringTask());
            l.add(Executors.callable(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), "a test string"));
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertEquals((int)3, (int)futures.size());
            Iterator it = futures.iterator();
            Future f1 = it.next();
            Future f2 = it.next();
            Future f3 = it.next();
            ThreadPoolExecutorTest.assertTrue((boolean)f1.isDone());
            ThreadPoolExecutorTest.assertTrue((boolean)f2.isDone());
            ThreadPoolExecutorTest.assertTrue((boolean)f3.isDone());
            ThreadPoolExecutorTest.assertFalse((boolean)f1.isCancelled());
            ThreadPoolExecutorTest.assertTrue((boolean)f2.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailingThreadFactory() throws InterruptedException {
        ThreadPoolExecutor e = new ThreadPoolExecutor(100, 100, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new FailingThreadFactory());
        try {
            ArrayList l = new ArrayList();
            for (int k = 0; k < 100; ++k) {
                e.execute(new JSR166TestCase.NoOpRunnable());
            }
            Thread.sleep(LONG_DELAY_MS);
        }
        finally {
            this.joinPool(e);
        }
    }

    public void testAllowsCoreThreadTimeOut() {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(2, 2, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertFalse((boolean)tpe.allowsCoreThreadTimeOut());
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowCoreThreadTimeOut_true() throws InterruptedException {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(2, 10, 10L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        tpe.allowCoreThreadTimeOut(true);
        tpe.execute(new JSR166TestCase.NoOpRunnable());
        try {
            Thread.sleep(MEDIUM_DELAY_MS);
            ThreadPoolExecutorTest.assertEquals((int)0, (int)tpe.getPoolSize());
        }
        finally {
            this.joinPool(tpe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowCoreThreadTimeOut_false() throws InterruptedException {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(2, 10, 10L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        tpe.allowCoreThreadTimeOut(false);
        tpe.execute(new JSR166TestCase.NoOpRunnable());
        try {
            Thread.sleep(MEDIUM_DELAY_MS);
            ThreadPoolExecutorTest.assertTrue((tpe.getPoolSize() >= 1 ? 1 : 0) != 0);
        }
        finally {
            this.joinPool(tpe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRejectedRecycledTask() throws InterruptedException {
        int nTasks = 1000;
        final AtomicInteger nRun = new AtomicInteger(0);
        Runnable recycledTask = new Runnable(){

            public void run() {
                nRun.getAndIncrement();
            }
        };
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 30, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
        try {
            block5: for (int i = 0; i < 1000; ++i) {
                while (true) {
                    try {
                        p.execute(recycledTask);
                        continue block5;
                    }
                    catch (RejectedExecutionException ignore) {
                        continue;
                    }
                    break;
                }
            }
            Thread.sleep(5000L);
            ThreadPoolExecutorTest.assertEquals((int)nRun.get(), (int)1000);
        }
        finally {
            p.shutdown();
        }
    }

    public void testRejected() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(2);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.SECONDS, queue);
        executor.submit(new Sleeper());
        executor.submit(new Sleeper());
        executor.submit(new Sleeper());
        executor.submit(new Sleeper());
        try {
            executor.submit(new Sleeper());
            ThreadPoolExecutorTest.fail();
        }
        catch (RejectedExecutionException expected) {
            System.out.println(expected.getMessage());
            ThreadPoolExecutorTest.assertNotNull((Object)expected.getMessage());
        }
        executor.shutdown();
    }

    static class Sleeper
    implements Runnable {
        Sleeper() {
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static class FailingThreadFactory
    implements ThreadFactory {
        int calls = 0;

        FailingThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            if (++this.calls > 1) {
                return null;
            }
            return new Thread(r);
        }
    }

    static class ExtendedTPE
    extends ThreadPoolExecutor {
        volatile boolean beforeCalled = false;
        volatile boolean afterCalled = false;
        volatile boolean terminatedCalled = false;

        public ExtendedTPE() {
            super(1, 1, JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        }

        protected void beforeExecute(Thread t, Runnable r) {
            this.beforeCalled = true;
        }

        protected void afterExecute(Runnable r, Throwable t) {
            this.afterCalled = true;
        }

        protected void terminated() {
            this.terminatedCalled = true;
        }
    }
}

