/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ThreadPoolExecutorSubclassTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ThreadPoolExecutorSubclassTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecute() throws InterruptedException {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p1.execute(new JSR166TestCase.ShortRunnable());
            Thread.sleep(SMALL_DELAY_MS);
        }
        finally {
            this.joinPool(p1);
        }
    }

    public void testGetActiveCount() throws InterruptedException {
        CustomTPE p2 = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((int)0, (int)p2.getActiveCount());
        p2.execute(new JSR166TestCase.MediumRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ThreadPoolExecutorSubclassTest.assertEquals((int)1, (int)p2.getActiveCount());
        this.joinPool(p2);
    }

    public void testPrestartCoreThread() {
        CustomTPE p2 = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((int)0, (int)p2.getPoolSize());
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p2.prestartCoreThread());
        ThreadPoolExecutorSubclassTest.assertEquals((int)1, (int)p2.getPoolSize());
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p2.prestartCoreThread());
        ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)p2.getPoolSize());
        ThreadPoolExecutorSubclassTest.assertFalse((boolean)p2.prestartCoreThread());
        ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)p2.getPoolSize());
        this.joinPool(p2);
    }

    public void testPrestartAllCoreThreads() {
        CustomTPE p2 = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((int)0, (int)p2.getPoolSize());
        p2.prestartAllCoreThreads();
        ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)p2.getPoolSize());
        p2.prestartAllCoreThreads();
        ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)p2.getPoolSize());
        this.joinPool(p2);
    }

    public void testGetCompletedTaskCount() throws InterruptedException {
        CustomTPE p2 = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((long)0L, (long)p2.getCompletedTaskCount());
        p2.execute(new JSR166TestCase.ShortRunnable());
        Thread.sleep(SMALL_DELAY_MS);
        ThreadPoolExecutorSubclassTest.assertEquals((long)1L, (long)p2.getCompletedTaskCount());
        try {
            p2.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p2);
    }

    public void testGetCorePoolSize() {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((int)1, (int)p1.getCorePoolSize());
        this.joinPool(p1);
    }

    public void testGetKeepAliveTime() {
        CustomTPE p2 = new CustomTPE(2, 2, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((long)1L, (long)p2.getKeepAliveTime(TimeUnit.SECONDS));
        this.joinPool(p2);
    }

    public void testGetThreadFactory() {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        CustomTPE p = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), tf, new JSR166TestCase.NoOpREHandler());
        ThreadPoolExecutorSubclassTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    public void testSetThreadFactory() {
        CustomTPE p = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        p.setThreadFactory(tf);
        ThreadPoolExecutorSubclassTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetThreadFactoryNull() {
        CustomTPE p = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setThreadFactory(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testGetRejectedExecutionHandler() {
        JSR166TestCase.NoOpREHandler h = new JSR166TestCase.NoOpREHandler();
        CustomTPE p = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), h);
        ThreadPoolExecutorSubclassTest.assertSame((Object)h, (Object)p.getRejectedExecutionHandler());
        this.joinPool(p);
    }

    public void testSetRejectedExecutionHandler() {
        CustomTPE p = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        JSR166TestCase.NoOpREHandler h = new JSR166TestCase.NoOpREHandler();
        p.setRejectedExecutionHandler(h);
        ThreadPoolExecutorSubclassTest.assertSame((Object)h, (Object)p.getRejectedExecutionHandler());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRejectedExecutionHandlerNull() {
        CustomTPE p = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setRejectedExecutionHandler(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testGetLargestPoolSize() throws InterruptedException {
        CustomTPE p2 = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((int)0, (int)p2.getLargestPoolSize());
        p2.execute(new JSR166TestCase.MediumRunnable());
        p2.execute(new JSR166TestCase.MediumRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)p2.getLargestPoolSize());
        this.joinPool(p2);
    }

    public void testGetMaximumPoolSize() {
        CustomTPE p2 = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)p2.getMaximumPoolSize());
        this.joinPool(p2);
    }

    public void testGetPoolSize() {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((int)0, (int)p1.getPoolSize());
        p1.execute(new JSR166TestCase.MediumRunnable());
        ThreadPoolExecutorSubclassTest.assertEquals((int)1, (int)p1.getPoolSize());
        this.joinPool(p1);
    }

    public void testGetTaskCount() throws InterruptedException {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertEquals((long)0L, (long)p1.getTaskCount());
        p1.execute(new JSR166TestCase.MediumRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ThreadPoolExecutorSubclassTest.assertEquals((long)1L, (long)p1.getTaskCount());
        this.joinPool(p1);
    }

    public void testIsShutdown() {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertFalse((boolean)p1.isShutdown());
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
        this.joinPool(p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminated() throws InterruptedException {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertFalse((boolean)p1.isTerminated());
        try {
            p1.execute(new JSR166TestCase.MediumRunnable());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminating() throws InterruptedException {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertFalse((boolean)p1.isTerminating());
        try {
            p1.execute(new JSR166TestCase.SmallRunnable());
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)p1.isTerminating());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.isTerminated());
        ThreadPoolExecutorSubclassTest.assertFalse((boolean)p1.isTerminating());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetQueue() throws InterruptedException {
        ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(10);
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, q);
        FutureTask[] tasks = new FutureTask[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = new FutureTask<Boolean>(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), Boolean.TRUE);
            p1.execute(tasks[i]);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            BlockingQueue<Runnable> wq = p1.getQueue();
            ThreadPoolExecutorSubclassTest.assertSame(q, wq);
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)wq.contains(tasks[0]));
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)wq.contains(tasks[4]));
            for (int i = 1; i < 5; ++i) {
                tasks[i].cancel(true);
            }
            p1.shutdownNow();
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemove() throws InterruptedException {
        ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(10);
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, q);
        FutureTask[] tasks = new FutureTask[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = new FutureTask<Boolean>(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), Boolean.TRUE);
            p1.execute(tasks[i]);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)p1.remove(tasks[0]));
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)q.contains(tasks[4]));
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)q.contains(tasks[3]));
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.remove(tasks[4]));
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)p1.remove(tasks[4]));
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)q.contains(tasks[4]));
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)q.contains(tasks[3]));
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.remove(tasks[3]));
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)q.contains(tasks[3]));
        }
        finally {
            this.joinPool(p1);
        }
    }

    public void testPurge() {
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        FutureTask[] tasks = new FutureTask[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = new FutureTask<Boolean>(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), Boolean.TRUE);
            p1.execute(tasks[i]);
        }
        tasks[4].cancel(true);
        tasks[3].cancel(true);
        p1.purge();
        long count = p1.getTaskCount();
        ThreadPoolExecutorSubclassTest.assertTrue((count >= 2L && count < 5L ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutDownNow() {
        List<Runnable> l;
        CustomTPE p1 = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            for (int i = 0; i < 5; ++i) {
                p1.execute(new JSR166TestCase.MediumPossiblyInterruptedRunnable());
            }
        }
        finally {
            try {
                l = p1.shutdownNow();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
        ThreadPoolExecutorSubclassTest.assertTrue((l.size() <= 4 ? 1 : 0) != 0);
    }

    public void testConstructor1() {
        try {
            new CustomTPE(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            new CustomTPE(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            new CustomTPE(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            new CustomTPE(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            new CustomTPE(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException() {
        try {
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        try {
            new CustomTPE(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor7() {
        try {
            new CustomTPE(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor8() {
        try {
            new CustomTPE(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor9() {
        try {
            new CustomTPE(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor10() {
        try {
            new CustomTPE(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException2() {
        try {
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null, new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException3() {
        try {
            ThreadFactory f = null;
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), f);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor11() {
        try {
            new CustomTPE(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor12() {
        try {
            new CustomTPE(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor13() {
        try {
            new CustomTPE(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor14() {
        try {
            new CustomTPE(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor15() {
        try {
            new CustomTPE(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException4() {
        try {
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null, new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException5() {
        try {
            RejectedExecutionHandler r = null;
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), r);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor16() {
        try {
            new CustomTPE(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor17() {
        try {
            new CustomTPE(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor18() {
        try {
            new CustomTPE(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor19() {
        try {
            new CustomTPE(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor20() {
        try {
            new CustomTPE(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException6() {
        try {
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null, new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException7() {
        try {
            RejectedExecutionHandler r = null;
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), r);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException8() {
        try {
            ThreadFactory f = null;
            new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), f, new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSaturatedExecute() {
        CustomTPE p = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        try {
            for (int i = 0; i < 5; ++i) {
                p.execute(new JSR166TestCase.MediumRunnable());
            }
            this.shouldThrow();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute2() {
        ThreadPoolExecutor.CallerRunsPolicy h = new ThreadPoolExecutor.CallerRunsPolicy();
        CustomTPE p = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            int i;
            JSR166TestCase.TrackedNoOpRunnable[] tasks = new JSR166TestCase.TrackedNoOpRunnable[5];
            for (int i2 = 0; i2 < 5; ++i2) {
                tasks[i2] = new JSR166TestCase.TrackedNoOpRunnable();
            }
            JSR166TestCase.TrackedLongRunnable mr = new JSR166TestCase.TrackedLongRunnable();
            p.execute(mr);
            for (i = 0; i < 5; ++i) {
                p.execute(tasks[i]);
            }
            for (i = 1; i < 5; ++i) {
                ThreadPoolExecutorSubclassTest.assertTrue((boolean)tasks[i].done);
            }
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute3() {
        ThreadPoolExecutor.DiscardPolicy h = new ThreadPoolExecutor.DiscardPolicy();
        CustomTPE p = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            int i;
            JSR166TestCase.TrackedNoOpRunnable[] tasks = new JSR166TestCase.TrackedNoOpRunnable[5];
            for (i = 0; i < 5; ++i) {
                tasks[i] = new JSR166TestCase.TrackedNoOpRunnable();
            }
            p.execute(new JSR166TestCase.TrackedLongRunnable());
            for (i = 0; i < 5; ++i) {
                p.execute(tasks[i]);
            }
            for (i = 0; i < 5; ++i) {
                ThreadPoolExecutorSubclassTest.assertFalse((boolean)tasks[i].done);
            }
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute4() {
        ThreadPoolExecutor.DiscardOldestPolicy h = new ThreadPoolExecutor.DiscardOldestPolicy();
        CustomTPE p = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.execute(new JSR166TestCase.TrackedLongRunnable());
            JSR166TestCase.TrackedLongRunnable r2 = new JSR166TestCase.TrackedLongRunnable();
            p.execute(r2);
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)p.getQueue().contains(r2));
            JSR166TestCase.TrackedNoOpRunnable r3 = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r3);
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)p.getQueue().contains(r2));
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)p.getQueue().contains(r3));
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testRejectedExecutionExceptionOnShutdown() {
        CustomTPE tpe = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        try {
            tpe.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            tpe.execute(new JSR166TestCase.NoOpRunnable());
            this.shouldThrow();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallerRunsOnShutdown() {
        ThreadPoolExecutor.CallerRunsPolicy h = new ThreadPoolExecutor.CallerRunsPolicy();
        CustomTPE p = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscardOnShutdown() {
        ThreadPoolExecutor.DiscardPolicy h = new ThreadPoolExecutor.DiscardPolicy();
        CustomTPE p = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscardOldestOnShutdown() {
        ThreadPoolExecutor.DiscardOldestPolicy h = new ThreadPoolExecutor.DiscardOldestPolicy();
        CustomTPE p = new CustomTPE(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testExecuteNull() {
        CustomTPE tpe = null;
        try {
            tpe = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            tpe.execute(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorePoolSizeIllegalArgumentException() {
        CustomTPE tpe = new CustomTPE(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setCorePoolSize(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaximumPoolSizeIllegalArgumentException() {
        CustomTPE tpe = new CustomTPE(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setMaximumPoolSize(1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaximumPoolSizeIllegalArgumentException2() {
        CustomTPE tpe = new CustomTPE(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setMaximumPoolSize(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKeepAliveTimeIllegalArgumentException() {
        CustomTPE tpe = new CustomTPE(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            tpe.setKeepAliveTime(-1L, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(tpe);
    }

    public void testTerminated() {
        CustomTPE tpe = new CustomTPE();
        try {
            tpe.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ThreadPoolExecutorSubclassTest.assertTrue((boolean)tpe.terminatedCalled);
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBeforeAfter() throws InterruptedException {
        CustomTPE tpe = new CustomTPE();
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            tpe.execute(r);
            Thread.sleep(SHORT_DELAY_MS);
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)r.done);
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)tpe.beforeCalled);
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)tpe.afterCalled);
            try {
                tpe.shutdown();
            }
            catch (SecurityException ok) {
                this.joinPool(tpe);
                return;
            }
        }
        finally {
            this.joinPool(tpe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitCallable() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<String> future = e.submit(new JSR166TestCase.StringTask());
            String result = future.get();
            ThreadPoolExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
            future.get();
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)future.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable2() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<String> future = e.submit(new JSR166TestCase.NoOpRunnable(), "a test string");
            String result = future.get();
            ThreadPoolExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            ThreadPoolExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            List r = e.invokeAll(new ArrayList());
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l);
        ThreadPoolExecutorSubclassTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ThreadPoolExecutorSubclassTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
        ThreadPoolExecutorSubclassTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorSubclassTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ThreadPoolExecutorSubclassTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll6() throws Exception {
        CustomTPE e = new CustomTPE(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
            l.add(new JSR166TestCase.StringTask());
            l.add(Executors.callable(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), "a test string"));
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorSubclassTest.assertEquals((int)3, (int)futures.size());
            Iterator it = futures.iterator();
            Future f1 = it.next();
            Future f2 = it.next();
            Future f3 = it.next();
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)f1.isDone());
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)f2.isDone());
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)f3.isDone());
            ThreadPoolExecutorSubclassTest.assertFalse((boolean)f1.isCancelled());
            ThreadPoolExecutorSubclassTest.assertTrue((boolean)f2.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailingThreadFactory() throws InterruptedException {
        CustomTPE e = new CustomTPE(100, 100, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new FailingThreadFactory());
        try {
            for (int k = 0; k < 100; ++k) {
                e.execute(new JSR166TestCase.NoOpRunnable());
            }
            Thread.sleep(LONG_DELAY_MS);
        }
        finally {
            this.joinPool(e);
        }
    }

    public void testAllowsCoreThreadTimeOut() {
        CustomTPE tpe = new CustomTPE(2, 2, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorSubclassTest.assertFalse((boolean)tpe.allowsCoreThreadTimeOut());
        this.joinPool(tpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowCoreThreadTimeOut_true() throws InterruptedException {
        CustomTPE tpe = new CustomTPE(2, 10, 10L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        tpe.allowCoreThreadTimeOut(true);
        tpe.execute(new JSR166TestCase.NoOpRunnable());
        try {
            Thread.sleep(MEDIUM_DELAY_MS);
            ThreadPoolExecutorSubclassTest.assertEquals((int)0, (int)tpe.getPoolSize());
        }
        finally {
            this.joinPool(tpe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowCoreThreadTimeOut_false() throws InterruptedException {
        CustomTPE tpe = new CustomTPE(2, 10, 10L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        tpe.allowCoreThreadTimeOut(false);
        tpe.execute(new JSR166TestCase.NoOpRunnable());
        try {
            Thread.sleep(MEDIUM_DELAY_MS);
            ThreadPoolExecutorSubclassTest.assertTrue((tpe.getPoolSize() >= 1 ? 1 : 0) != 0);
        }
        finally {
            this.joinPool(tpe);
        }
    }

    static class FailingThreadFactory
    implements ThreadFactory {
        int calls = 0;

        FailingThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            if (++this.calls > 1) {
                return null;
            }
            return new Thread(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CustomTPE
    extends ThreadPoolExecutor {
        volatile boolean beforeCalled = false;
        volatile boolean afterCalled = false;
        volatile boolean terminatedCalled = false;

        protected <V> RunnableFuture<V> newTaskFor(Callable<V> c) {
            return new CustomTask<V>(c);
        }

        protected <V> RunnableFuture<V> newTaskFor(Runnable r, V v) {
            return new CustomTask<V>(r, v);
        }

        CustomTPE(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        CustomTPE(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        CustomTPE(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        }

        CustomTPE(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        public CustomTPE() {
            super(1, 1, JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            this.beforeCalled = true;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.afterCalled = true;
        }

        @Override
        protected void terminated() {
            this.terminatedCalled = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CustomTask<V>
    implements RunnableFuture<V> {
        final Callable<V> callable;
        final ReentrantLock lock = new ReentrantLock();
        final Condition cond = this.lock.newCondition();
        boolean done;
        boolean cancelled;
        V result;
        Thread thread;
        Exception exception;

        CustomTask(Callable<V> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.callable = c;
        }

        CustomTask(final Runnable r, final V res) {
            if (r == null) {
                throw new NullPointerException();
            }
            this.callable = new Callable<V>(){

                @Override
                public V call() throws Exception {
                    r.run();
                    return res;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            this.lock.lock();
            try {
                boolean bl = this.done;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            this.lock.lock();
            try {
                boolean bl = this.cancelled;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterrupt) {
            this.lock.lock();
            try {
                if (!this.done) {
                    this.cancelled = true;
                    this.done = true;
                    if (mayInterrupt && this.thread != null) {
                        this.thread.interrupt();
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean runme;
            this.lock.lock();
            try {
                boolean bl = runme = !this.done;
                if (!runme) {
                    this.thread = Thread.currentThread();
                }
            }
            finally {
                this.lock.unlock();
            }
            if (!runme) {
                return;
            }
            Object v = null;
            Exception e = null;
            try {
                v = this.callable.call();
            }
            catch (Exception ex) {
                e = ex;
            }
            this.lock.lock();
            try {
                this.result = v;
                this.exception = e;
                this.done = true;
                this.thread = null;
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.lock.lock();
            try {
                while (!this.done) {
                    this.cond.await();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                V v = this.result;
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long nanos = unit.toNanos(timeout);
            this.lock.lock();
            try {
                while (!this.done) {
                    if (nanos < 0L) {
                        throw new TimeoutException();
                    }
                    nanos = this.cond.awaitNanos(nanos);
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                V v = this.result;
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

