/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ScheduledExecutorTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ScheduledExecutorTest.class);
    }

    public void testExecute() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        p1.execute(runnable);
        ScheduledExecutorTest.assertFalse((boolean)runnable.done);
        Thread.sleep(SHORT_DELAY_MS);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorTest.assertTrue((boolean)runnable.done);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p1);
    }

    public void testSchedule1() throws Exception {
        JSR166TestCase.TrackedCallable callable = new JSR166TestCase.TrackedCallable();
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledFuture f = p1.schedule(callable, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorTest.assertFalse((boolean)callable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorTest.assertTrue((boolean)callable.done);
        ScheduledExecutorTest.assertEquals((Object)Boolean.TRUE, f.get());
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p1);
    }

    public void testSchedule3() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        p1.schedule(runnable, SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorTest.assertFalse((boolean)runnable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorTest.assertTrue((boolean)runnable.done);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p1);
    }

    public void testSchedule4() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledFuture<?> h = p1.scheduleAtFixedRate(runnable, SHORT_DELAY_MS, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorTest.assertFalse((boolean)runnable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorTest.assertTrue((boolean)runnable.done);
        h.cancel(true);
        this.joinPool(p1);
    }

    public void testSchedule5() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledFuture<?> h = p1.scheduleWithFixedDelay(runnable, SHORT_DELAY_MS, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorTest.assertFalse((boolean)runnable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorTest.assertTrue((boolean)runnable.done);
        h.cancel(true);
        this.joinPool(p1);
    }

    public void testFixedRateSequence() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        RunnableCounter counter = new RunnableCounter();
        ScheduledFuture<?> h = p1.scheduleAtFixedRate(counter, 0L, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(SMALL_DELAY_MS);
        h.cancel(true);
        int c = counter.count.get();
        ScheduledExecutorTest.assertTrue(((long)c >= SMALL_DELAY_MS / SHORT_DELAY_MS ? 1 : 0) != 0);
        ScheduledExecutorTest.assertTrue(((long)c <= SMALL_DELAY_MS + SHORT_DELAY_MS ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    public void testFixedDelaySequence() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        RunnableCounter counter = new RunnableCounter();
        ScheduledFuture<?> h = p1.scheduleWithFixedDelay(counter, 0L, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(SMALL_DELAY_MS);
        h.cancel(true);
        int c = counter.count.get();
        ScheduledExecutorTest.assertTrue(((long)c >= SMALL_DELAY_MS / SHORT_DELAY_MS ? 1 : 0) != 0);
        ScheduledExecutorTest.assertTrue(((long)c <= SMALL_DELAY_MS + SHORT_DELAY_MS ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    public void testExecuteNull() throws InterruptedException {
        ScheduledThreadPoolExecutor se = null;
        try {
            se = new ScheduledThreadPoolExecutor(1);
            se.execute(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleNull() throws InterruptedException {
        ScheduledThreadPoolExecutor se = new ScheduledThreadPoolExecutor(1);
        try {
            Callable callable = null;
            ScheduledFuture f = se.schedule(callable, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule1_RejectedExecutionException() throws InterruptedException {
        ScheduledThreadPoolExecutor se = new ScheduledThreadPoolExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule2_RejectedExecutionException() throws InterruptedException {
        ScheduledThreadPoolExecutor se = new ScheduledThreadPoolExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpCallable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule3_RejectedExecutionException() throws InterruptedException {
        ScheduledThreadPoolExecutor se = new ScheduledThreadPoolExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpCallable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleAtFixedRate1_RejectedExecutionException() throws InterruptedException {
        ScheduledThreadPoolExecutor se = new ScheduledThreadPoolExecutor(1);
        try {
            se.shutdown();
            se.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleWithFixedDelay1_RejectedExecutionException() throws InterruptedException {
        ScheduledThreadPoolExecutor se = new ScheduledThreadPoolExecutor(1);
        try {
            se.shutdown();
            se.scheduleWithFixedDelay(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testGetActiveCount() throws InterruptedException {
        ScheduledThreadPoolExecutor p2 = new ScheduledThreadPoolExecutor(2);
        ScheduledExecutorTest.assertEquals((int)0, (int)p2.getActiveCount());
        p2.execute(new JSR166TestCase.SmallRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorTest.assertEquals((int)1, (int)p2.getActiveCount());
        this.joinPool(p2);
    }

    public void testGetCompletedTaskCount() throws InterruptedException {
        ScheduledThreadPoolExecutor p2 = new ScheduledThreadPoolExecutor(2);
        ScheduledExecutorTest.assertEquals((long)0L, (long)p2.getCompletedTaskCount());
        p2.execute(new JSR166TestCase.SmallRunnable());
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorTest.assertEquals((long)1L, (long)p2.getCompletedTaskCount());
        this.joinPool(p2);
    }

    public void testGetCorePoolSize() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledExecutorTest.assertEquals((int)1, (int)p1.getCorePoolSize());
        this.joinPool(p1);
    }

    public void testGetLargestPoolSize() throws InterruptedException {
        ScheduledThreadPoolExecutor p2 = new ScheduledThreadPoolExecutor(2);
        ScheduledExecutorTest.assertEquals((int)0, (int)p2.getLargestPoolSize());
        p2.execute(new JSR166TestCase.SmallRunnable());
        p2.execute(new JSR166TestCase.SmallRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorTest.assertEquals((int)2, (int)p2.getLargestPoolSize());
        this.joinPool(p2);
    }

    public void testGetPoolSize() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledExecutorTest.assertEquals((int)0, (int)p1.getPoolSize());
        p1.execute(new JSR166TestCase.SmallRunnable());
        ScheduledExecutorTest.assertEquals((int)1, (int)p1.getPoolSize());
        this.joinPool(p1);
    }

    public void testGetTaskCount() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledExecutorTest.assertEquals((long)0L, (long)p1.getTaskCount());
        for (int i = 0; i < 5; ++i) {
            p1.execute(new JSR166TestCase.SmallRunnable());
        }
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorTest.assertEquals((long)5L, (long)p1.getTaskCount());
        this.joinPool(p1);
    }

    public void testGetThreadFactory() throws InterruptedException {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        ScheduledThreadPoolExecutor p = new ScheduledThreadPoolExecutor(1, tf);
        ScheduledExecutorTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    public void testSetThreadFactory() throws InterruptedException {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        ScheduledThreadPoolExecutor p = new ScheduledThreadPoolExecutor(1);
        p.setThreadFactory(tf);
        ScheduledExecutorTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetThreadFactoryNull() throws InterruptedException {
        ScheduledThreadPoolExecutor p = new ScheduledThreadPoolExecutor(1);
        try {
            p.setThreadFactory(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsShutdown() {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        try {
            ScheduledExecutorTest.assertFalse((boolean)p1.isShutdown());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorTest.assertTrue((boolean)p1.isShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminated() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        try {
            p1.execute(new JSR166TestCase.SmallRunnable());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorTest.assertTrue((boolean)p1.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminating() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledExecutorTest.assertFalse((boolean)p1.isTerminating());
        try {
            p1.execute(new JSR166TestCase.SmallRunnable());
            ScheduledExecutorTest.assertFalse((boolean)p1.isTerminating());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorTest.assertTrue((boolean)p1.isTerminated());
        ScheduledExecutorTest.assertFalse((boolean)p1.isTerminating());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetQueue() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), 1L, TimeUnit.MILLISECONDS);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            BlockingQueue<Runnable> q = p1.getQueue();
            ScheduledExecutorTest.assertTrue((boolean)q.contains(tasks[4]));
            ScheduledExecutorTest.assertFalse((boolean)q.contains(tasks[0]));
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemove() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), 1L, TimeUnit.MILLISECONDS);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            BlockingQueue<Runnable> q = p1.getQueue();
            ScheduledExecutorTest.assertFalse((boolean)p1.remove((Runnable)((Object)tasks[0])));
            ScheduledExecutorTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[4])));
            ScheduledExecutorTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[3])));
            ScheduledExecutorTest.assertTrue((boolean)p1.remove((Runnable)((Object)tasks[4])));
            ScheduledExecutorTest.assertFalse((boolean)p1.remove((Runnable)((Object)tasks[4])));
            ScheduledExecutorTest.assertFalse((boolean)q.contains((Runnable)((Object)tasks[4])));
            ScheduledExecutorTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[3])));
            ScheduledExecutorTest.assertTrue((boolean)p1.remove((Runnable)((Object)tasks[3])));
            ScheduledExecutorTest.assertFalse((boolean)q.contains((Runnable)((Object)tasks[3])));
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurge() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            int max = 5;
            if (tasks[4].cancel(true)) {
                --max;
            }
            if (tasks[3].cancel(true)) {
                --max;
            }
            int k = 0;
            while ((long)k < SMALL_DELAY_MS) {
                p1.purge();
                long count = p1.getTaskCount();
                if (count >= 0L && count <= (long)max) break;
                Thread.sleep(1L);
                ++k;
            }
            ScheduledExecutorTest.assertTrue(((long)k < SMALL_DELAY_MS ? 1 : 0) != 0);
        }
        finally {
            this.joinPool(p1);
        }
    }

    public void testShutDownNow() throws InterruptedException {
        List<Runnable> l;
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        for (int i = 0; i < 5; ++i) {
            p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            l = p1.shutdownNow();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorTest.assertTrue((boolean)p1.isShutdown());
        ScheduledExecutorTest.assertTrue((l.size() > 0 && l.size() <= 5 ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    public void testShutDown1() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        ScheduledExecutorTest.assertTrue((boolean)p1.getExecuteExistingDelayedTasksAfterShutdownPolicy());
        ScheduledExecutorTest.assertFalse((boolean)p1.getContinueExistingPeriodicTasksAfterShutdownPolicy());
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.NoOpRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        BlockingQueue<Runnable> q = p1.getQueue();
        for (ScheduledFuture scheduledFuture : q) {
            ScheduledExecutorTest.assertFalse((boolean)scheduledFuture.isCancelled());
        }
        ScheduledExecutorTest.assertTrue((boolean)p1.isShutdown());
        Thread.sleep(SMALL_DELAY_MS);
        for (int i = 0; i < 5; ++i) {
            ScheduledExecutorTest.assertTrue((boolean)tasks[i].isDone());
            ScheduledExecutorTest.assertFalse((boolean)tasks[i].isCancelled());
        }
    }

    public void testShutDown2() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        p1.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.NoOpRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorTest.assertTrue((boolean)p1.isShutdown());
        BlockingQueue<Runnable> q = p1.getQueue();
        ScheduledExecutorTest.assertTrue((boolean)q.isEmpty());
        Thread.sleep(SMALL_DELAY_MS);
        ScheduledExecutorTest.assertTrue((boolean)p1.isTerminated());
    }

    public void testShutDown3() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        p1.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        ScheduledFuture<?> task = p1.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), 5L, 5L, TimeUnit.MILLISECONDS);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorTest.assertTrue((boolean)p1.isShutdown());
        BlockingQueue<Runnable> q = p1.getQueue();
        ScheduledExecutorTest.assertTrue((boolean)q.isEmpty());
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorTest.assertTrue((boolean)p1.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutDown4() throws InterruptedException {
        ScheduledThreadPoolExecutor p1 = new ScheduledThreadPoolExecutor(1);
        try {
            p1.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
            ScheduledFuture<?> task = p1.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), 1L, 1L, TimeUnit.MILLISECONDS);
            ScheduledExecutorTest.assertFalse((boolean)task.isCancelled());
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                this.joinPool(p1);
                return;
            }
            ScheduledExecutorTest.assertFalse((boolean)task.isCancelled());
            ScheduledExecutorTest.assertFalse((boolean)p1.isTerminated());
            ScheduledExecutorTest.assertTrue((boolean)p1.isShutdown());
            Thread.sleep(SHORT_DELAY_MS);
            ScheduledExecutorTest.assertFalse((boolean)task.isCancelled());
            ScheduledExecutorTest.assertTrue((boolean)task.cancel(true));
            ScheduledExecutorTest.assertTrue((boolean)task.isDone());
            Thread.sleep(SHORT_DELAY_MS);
            ScheduledExecutorTest.assertTrue((boolean)p1.isTerminated());
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitCallable() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            Future<String> future = e.submit(new JSR166TestCase.StringTask());
            String result = future.get();
            ScheduledExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
            future.get();
            ScheduledExecutorTest.assertTrue((boolean)future.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable2() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            Future<String> future = e.submit(new JSR166TestCase.NoOpRunnable(), "a test string");
            String result = future.get();
            ScheduledExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            ScheduledExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            List r = e.invokeAll(new ArrayList());
            ScheduledExecutorTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l);
        ScheduledExecutorTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            ScheduledExecutorTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ScheduledExecutorTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ScheduledExecutorTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll6() throws Exception {
        ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(2);
        try {
            ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
            l.add(new JSR166TestCase.StringTask());
            l.add(Executors.callable(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), "a test string"));
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorTest.assertEquals((int)3, (int)futures.size());
            Iterator it = futures.iterator();
            Future f1 = it.next();
            Future f2 = it.next();
            Future f3 = it.next();
            ScheduledExecutorTest.assertTrue((boolean)f1.isDone());
            ScheduledExecutorTest.assertTrue((boolean)f2.isDone());
            ScheduledExecutorTest.assertTrue((boolean)f3.isDone());
            ScheduledExecutorTest.assertFalse((boolean)f1.isCancelled());
            ScheduledExecutorTest.assertTrue((boolean)f2.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    static class RunnableCounter
    implements Runnable {
        AtomicInteger count = new AtomicInteger(0);

        RunnableCounter() {
        }

        public void run() {
            this.count.getAndIncrement();
        }
    }
}

