/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ScheduledExecutorSubclassTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ScheduledExecutorSubclassTest.class);
    }

    public void testExecute() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        CustomExecutor p1 = new CustomExecutor(1);
        p1.execute(runnable);
        ScheduledExecutorSubclassTest.assertFalse((boolean)runnable.done);
        Thread.sleep(SHORT_DELAY_MS);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorSubclassTest.assertTrue((boolean)runnable.done);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p1);
    }

    public void testSchedule1() throws Exception {
        JSR166TestCase.TrackedCallable callable = new JSR166TestCase.TrackedCallable();
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledFuture f = p1.schedule(callable, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorSubclassTest.assertFalse((boolean)callable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorSubclassTest.assertTrue((boolean)callable.done);
        ScheduledExecutorSubclassTest.assertEquals((Object)Boolean.TRUE, f.get());
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p1);
    }

    public void testSchedule3() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        CustomExecutor p1 = new CustomExecutor(1);
        p1.schedule(runnable, SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorSubclassTest.assertFalse((boolean)runnable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorSubclassTest.assertTrue((boolean)runnable.done);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        this.joinPool(p1);
    }

    public void testSchedule4() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledFuture<?> h = p1.scheduleAtFixedRate(runnable, SHORT_DELAY_MS, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorSubclassTest.assertFalse((boolean)runnable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorSubclassTest.assertTrue((boolean)runnable.done);
        h.cancel(true);
        this.joinPool(p1);
    }

    public void testSchedule5() throws InterruptedException {
        JSR166TestCase.TrackedShortRunnable runnable = new JSR166TestCase.TrackedShortRunnable();
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledFuture<?> h = p1.scheduleWithFixedDelay(runnable, SHORT_DELAY_MS, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorSubclassTest.assertFalse((boolean)runnable.done);
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorSubclassTest.assertTrue((boolean)runnable.done);
        h.cancel(true);
        this.joinPool(p1);
    }

    public void testFixedRateSequence() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        RunnableCounter counter = new RunnableCounter();
        ScheduledFuture<?> h = p1.scheduleAtFixedRate(counter, 0L, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(SMALL_DELAY_MS);
        h.cancel(true);
        int c = counter.count.get();
        ScheduledExecutorSubclassTest.assertTrue(((long)c >= SMALL_DELAY_MS / SHORT_DELAY_MS ? 1 : 0) != 0);
        ScheduledExecutorSubclassTest.assertTrue(((long)c <= SMALL_DELAY_MS + SHORT_DELAY_MS ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    public void testFixedDelaySequence() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        RunnableCounter counter = new RunnableCounter();
        ScheduledFuture<?> h = p1.scheduleWithFixedDelay(counter, 0L, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(SMALL_DELAY_MS);
        h.cancel(true);
        int c = counter.count.get();
        ScheduledExecutorSubclassTest.assertTrue(((long)c >= SMALL_DELAY_MS / SHORT_DELAY_MS ? 1 : 0) != 0);
        ScheduledExecutorSubclassTest.assertTrue(((long)c <= SMALL_DELAY_MS + SHORT_DELAY_MS ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    public void testExecuteNull() throws InterruptedException {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.execute(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleNull() throws InterruptedException {
        CustomExecutor se = new CustomExecutor(1);
        try {
            Callable callable = null;
            ScheduledFuture f = se.schedule(callable, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule1_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule2_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpCallable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule3_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpCallable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleAtFixedRate1_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleWithFixedDelay1_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.scheduleWithFixedDelay(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testGetActiveCount() throws InterruptedException {
        CustomExecutor p2 = new CustomExecutor(2);
        ScheduledExecutorSubclassTest.assertEquals((int)0, (int)p2.getActiveCount());
        p2.execute(new JSR166TestCase.SmallRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)p2.getActiveCount());
        this.joinPool(p2);
    }

    public void testGetCompletedTaskCount() throws InterruptedException {
        CustomExecutor p2 = new CustomExecutor(2);
        ScheduledExecutorSubclassTest.assertEquals((long)0L, (long)p2.getCompletedTaskCount());
        p2.execute(new JSR166TestCase.SmallRunnable());
        Thread.sleep(MEDIUM_DELAY_MS);
        ScheduledExecutorSubclassTest.assertEquals((long)1L, (long)p2.getCompletedTaskCount());
        this.joinPool(p2);
    }

    public void testGetCorePoolSize() {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)p1.getCorePoolSize());
        this.joinPool(p1);
    }

    public void testGetLargestPoolSize() throws InterruptedException {
        CustomExecutor p2 = new CustomExecutor(2);
        ScheduledExecutorSubclassTest.assertEquals((int)0, (int)p2.getLargestPoolSize());
        p2.execute(new JSR166TestCase.SmallRunnable());
        p2.execute(new JSR166TestCase.SmallRunnable());
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorSubclassTest.assertEquals((int)2, (int)p2.getLargestPoolSize());
        this.joinPool(p2);
    }

    public void testGetPoolSize() {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertEquals((int)0, (int)p1.getPoolSize());
        p1.execute(new JSR166TestCase.SmallRunnable());
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)p1.getPoolSize());
        this.joinPool(p1);
    }

    public void testGetTaskCount() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertEquals((long)0L, (long)p1.getTaskCount());
        for (int i = 0; i < 5; ++i) {
            p1.execute(new JSR166TestCase.SmallRunnable());
        }
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorSubclassTest.assertEquals((long)5L, (long)p1.getTaskCount());
        this.joinPool(p1);
    }

    public void testGetThreadFactory() {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        CustomExecutor p = new CustomExecutor(1, tf);
        ScheduledExecutorSubclassTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    public void testSetThreadFactory() {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        CustomExecutor p = new CustomExecutor(1);
        p.setThreadFactory(tf);
        ScheduledExecutorSubclassTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetThreadFactoryNull() {
        CustomExecutor p = new CustomExecutor(1);
        try {
            p.setThreadFactory(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsShutdown() {
        CustomExecutor p1 = new CustomExecutor(1);
        try {
            ScheduledExecutorSubclassTest.assertFalse((boolean)p1.isShutdown());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminated() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        try {
            p1.execute(new JSR166TestCase.SmallRunnable());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminating() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertFalse((boolean)p1.isTerminating());
        try {
            p1.execute(new JSR166TestCase.SmallRunnable());
            ScheduledExecutorSubclassTest.assertFalse((boolean)p1.isTerminating());
        }
        finally {
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isTerminated());
        ScheduledExecutorSubclassTest.assertFalse((boolean)p1.isTerminating());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetQueue() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), 1L, TimeUnit.MILLISECONDS);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            BlockingQueue<Runnable> q = p1.getQueue();
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains(tasks[4]));
            ScheduledExecutorSubclassTest.assertFalse((boolean)q.contains(tasks[0]));
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemove() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), 1L, TimeUnit.MILLISECONDS);
        }
        try {
            Thread.sleep(SHORT_DELAY_MS);
            BlockingQueue<Runnable> q = p1.getQueue();
            ScheduledExecutorSubclassTest.assertFalse((boolean)p1.remove((Runnable)((Object)tasks[0])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[3])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)p1.remove((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertFalse((boolean)p1.remove((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertFalse((boolean)q.contains((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[3])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)p1.remove((Runnable)((Object)tasks[3])));
            ScheduledExecutorSubclassTest.assertFalse((boolean)q.contains((Runnable)((Object)tasks[3])));
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurge() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            int max = 5;
            if (tasks[4].cancel(true)) {
                --max;
            }
            if (tasks[3].cancel(true)) {
                --max;
            }
            int k = 0;
            while ((long)k < SMALL_DELAY_MS) {
                p1.purge();
                long count = p1.getTaskCount();
                if (count >= 0L && count <= (long)max) break;
                Thread.sleep(1L);
                ++k;
            }
            ScheduledExecutorSubclassTest.assertTrue(((long)k < SMALL_DELAY_MS ? 1 : 0) != 0);
        }
        finally {
            this.joinPool(p1);
        }
    }

    public void testShutDownNow() {
        List<Runnable> l;
        CustomExecutor p1 = new CustomExecutor(1);
        for (int i = 0; i < 5; ++i) {
            p1.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            l = p1.shutdownNow();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
        ScheduledExecutorSubclassTest.assertTrue((l.size() > 0 && l.size() <= 5 ? 1 : 0) != 0);
        this.joinPool(p1);
    }

    public void testShutDown1() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.getExecuteExistingDelayedTasksAfterShutdownPolicy());
        ScheduledExecutorSubclassTest.assertFalse((boolean)p1.getContinueExistingPeriodicTasksAfterShutdownPolicy());
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.NoOpRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        BlockingQueue<Runnable> q = p1.getQueue();
        for (ScheduledFuture scheduledFuture : q) {
            ScheduledExecutorSubclassTest.assertFalse((boolean)scheduledFuture.isCancelled());
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
        Thread.sleep(SMALL_DELAY_MS);
        for (int i = 0; i < 5; ++i) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)tasks[i].isDone());
            ScheduledExecutorSubclassTest.assertFalse((boolean)tasks[i].isCancelled());
        }
    }

    public void testShutDown2() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        p1.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < 5; ++i) {
            tasks[i] = p1.schedule(new JSR166TestCase.NoOpRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
        BlockingQueue<Runnable> q = p1.getQueue();
        ScheduledExecutorSubclassTest.assertTrue((boolean)q.isEmpty());
        Thread.sleep(SMALL_DELAY_MS);
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isTerminated());
    }

    public void testShutDown3() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        p1.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        ScheduledFuture<?> task = p1.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), 5L, 5L, TimeUnit.MILLISECONDS);
        try {
            p1.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
        BlockingQueue<Runnable> q = p1.getQueue();
        ScheduledExecutorSubclassTest.assertTrue((boolean)q.isEmpty());
        Thread.sleep(SHORT_DELAY_MS);
        ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutDown4() throws InterruptedException {
        CustomExecutor p1 = new CustomExecutor(1);
        try {
            p1.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
            ScheduledFuture<?> task = p1.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), 1L, 1L, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
            try {
                p1.shutdown();
            }
            catch (SecurityException ok) {
                this.joinPool(p1);
                return;
            }
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
            ScheduledExecutorSubclassTest.assertFalse((boolean)p1.isTerminated());
            ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isShutdown());
            Thread.sleep(SHORT_DELAY_MS);
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.cancel(true));
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.isDone());
            Thread.sleep(SHORT_DELAY_MS);
            ScheduledExecutorSubclassTest.assertTrue((boolean)p1.isTerminated());
        }
        finally {
            this.joinPool(p1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitCallable() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            Future<String> future = e.submit(new JSR166TestCase.StringTask());
            String result = future.get();
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
            future.get();
            ScheduledExecutorSubclassTest.assertTrue((boolean)future.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            Future<String> future = e.submit(new JSR166TestCase.NoOpRunnable(), "a test string");
            String result = future.get();
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            List r = e.invokeAll(new ArrayList());
            ScheduledExecutorSubclassTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l);
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            ScheduledExecutorSubclassTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ScheduledExecutorSubclassTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ScheduledExecutorSubclassTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll6() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
            l.add(new JSR166TestCase.StringTask());
            l.add(Executors.callable(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), "a test string"));
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertEquals((int)3, (int)futures.size());
            Iterator it = futures.iterator();
            Future f1 = it.next();
            Future f2 = it.next();
            Future f3 = it.next();
            ScheduledExecutorSubclassTest.assertTrue((boolean)f1.isDone());
            ScheduledExecutorSubclassTest.assertTrue((boolean)f2.isDone());
            ScheduledExecutorSubclassTest.assertTrue((boolean)f3.isDone());
            ScheduledExecutorSubclassTest.assertFalse((boolean)f1.isCancelled());
            ScheduledExecutorSubclassTest.assertTrue((boolean)f2.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    static class RunnableCounter
    implements Runnable {
        AtomicInteger count = new AtomicInteger(0);

        RunnableCounter() {
        }

        public void run() {
            this.count.getAndIncrement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CustomExecutor
    extends ScheduledThreadPoolExecutor {
        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable r, RunnableScheduledFuture<V> task) {
            return new CustomTask<V>(task);
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> c, RunnableScheduledFuture<V> task) {
            return new CustomTask<V>(task);
        }

        CustomExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        CustomExecutor(int corePoolSize, RejectedExecutionHandler handler) {
            super(corePoolSize, handler);
        }

        CustomExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        CustomExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CustomTask<V>
    implements RunnableScheduledFuture<V> {
        RunnableScheduledFuture<V> task;
        volatile boolean ran;

        CustomTask(RunnableScheduledFuture<V> t) {
            this.task = t;
        }

        @Override
        public boolean isPeriodic() {
            return this.task.isPeriodic();
        }

        @Override
        public void run() {
            this.ran = true;
            this.task.run();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.task.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed t) {
            return this.task.compareTo(((CustomTask)t).task);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            Object v = this.task.get();
            Assert.assertTrue((boolean)this.ran);
            return v;
        }

        @Override
        public V get(long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object v = this.task.get(time, unit);
            Assert.assertTrue((boolean)this.ran);
            return v;
        }
    }
}

