/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ReentrantReadWriteLockTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ReentrantReadWriteLockTest.class);
    }

    public void testConstructor() {
        ReentrantReadWriteLock rl = new ReentrantReadWriteLock();
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isFair());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)rl.getReadLockCount());
        ReentrantReadWriteLock r2 = new ReentrantReadWriteLock(true);
        ReentrantReadWriteLockTest.assertTrue((boolean)r2.isFair());
        ReentrantReadWriteLockTest.assertFalse((boolean)r2.isWriteLocked());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)r2.getReadLockCount());
        ReentrantReadWriteLock r3 = new ReentrantReadWriteLock(false);
        ReentrantReadWriteLockTest.assertFalse((boolean)r3.isFair());
        ReentrantReadWriteLockTest.assertFalse((boolean)r3.isWriteLocked());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)r3.getReadLockCount());
    }

    public void testLock() {
        ReentrantReadWriteLock rl = new ReentrantReadWriteLock();
        rl.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertTrue((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertTrue((boolean)rl.writeLock().isHeldByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)rl.getReadLockCount());
        rl.writeLock().unlock();
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.writeLock().isHeldByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)rl.getReadLockCount());
        rl.readLock().lock();
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)rl.getReadLockCount());
        rl.readLock().unlock();
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)rl.getReadLockCount());
    }

    public void testFairLock() {
        ReentrantReadWriteLock rl = new ReentrantReadWriteLock(true);
        rl.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertTrue((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertTrue((boolean)rl.writeLock().isHeldByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)rl.getReadLockCount());
        rl.writeLock().unlock();
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.writeLock().isHeldByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)rl.getReadLockCount());
        rl.readLock().lock();
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)rl.getReadLockCount());
        rl.readLock().unlock();
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLocked());
        ReentrantReadWriteLockTest.assertFalse((boolean)rl.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)rl.getReadLockCount());
    }

    public void testGetWriteHoldCount() {
        int i;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        for (i = 1; i <= 20; ++i) {
            lock.writeLock().lock();
            ReentrantReadWriteLockTest.assertEquals((int)i, (int)lock.getWriteHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.writeLock().unlock();
            ReentrantReadWriteLockTest.assertEquals((int)(i - 1), (int)lock.getWriteHoldCount());
        }
    }

    public void testGetHoldCount() {
        int i;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        for (i = 1; i <= 20; ++i) {
            lock.writeLock().lock();
            ReentrantReadWriteLockTest.assertEquals((int)i, (int)lock.writeLock().getHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.writeLock().unlock();
            ReentrantReadWriteLockTest.assertEquals((int)(i - 1), (int)lock.writeLock().getHoldCount());
        }
    }

    public void testGetReadHoldCount() {
        int i;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        for (i = 1; i <= 20; ++i) {
            lock.readLock().lock();
            ReentrantReadWriteLockTest.assertEquals((int)i, (int)lock.getReadHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.readLock().unlock();
            ReentrantReadWriteLockTest.assertEquals((int)(i - 1), (int)lock.getReadHoldCount());
        }
    }

    public void testUnlock_IllegalMonitorStateException() {
        ReentrantReadWriteLock rl = new ReentrantReadWriteLock();
        try {
            rl.writeLock().unlock();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testWriteLockInterruptibly_Interrupted() throws Exception {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lockInterruptibly();
                lock.writeLock().unlock();
                lock.writeLock().lockInterruptibly();
                lock.writeLock().unlock();
            }
        });
        lock.writeLock().lock();
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().unlock();
        t.join();
    }

    public void testWriteTryLock_Interrupted() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().tryLock(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        lock.writeLock().unlock();
        t.join();
    }

    public void testReadLockInterruptibly_Interrupted() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.readLock().lockInterruptibly();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().unlock();
        t.join();
    }

    public void testReadTryLock_Interrupted() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.readLock().tryLock(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testWriteTryLockWhenLocked() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.writeLock().tryLock());
            }
        });
        t.start();
        t.join();
        lock.writeLock().unlock();
    }

    public void testReadTryLockWhenLocked() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.readLock().tryLock());
            }
        });
        t.start();
        t.join();
        lock.writeLock().unlock();
    }

    public void testMultipleReadLocks() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantReadWriteLockTest.this.threadAssertTrue(lock.readLock().tryLock());
                lock.readLock().unlock();
            }
        });
        t.start();
        t.join();
        lock.readLock().unlock();
    }

    public void testWriteAfterMultipleReadLocks() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.readLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testReadAfterWriteLock() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testReadHoldingWriteLock() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.readLock().tryLock());
        lock.readLock().unlock();
        lock.writeLock().unlock();
    }

    public void testReadHoldingWriteLock2() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        t1.start();
        t2.start();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.readLock().lock();
        lock.readLock().unlock();
        lock.writeLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testReadHoldingWriteLock3() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        t1.start();
        t2.start();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.readLock().lock();
        lock.readLock().unlock();
        lock.writeLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testWriteHoldingWriteLock4() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        t1.start();
        t2.start();
        lock.writeLock().lock();
        lock.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        lock.writeLock().unlock();
        lock.writeLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testReadHoldingWriteLockFair() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.readLock().tryLock());
        lock.readLock().unlock();
        lock.writeLock().unlock();
    }

    public void testReadHoldingWriteLockFair2() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.writeLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        t1.start();
        t2.start();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.readLock().lock();
        lock.readLock().unlock();
        lock.writeLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testReadHoldingWriteLockFair3() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.writeLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        t1.start();
        t2.start();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.readLock().lock();
        lock.readLock().unlock();
        lock.writeLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testWriteHoldingWriteLockFair4() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.writeLock().lock();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertTrue((lock.getWriteHoldCount() == 1 ? 1 : 0) != 0);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((lock.getWriteHoldCount() == 2 ? 1 : 0) != 0);
        lock.writeLock().unlock();
        lock.writeLock().lock();
        lock.writeLock().unlock();
        lock.writeLock().unlock();
        t1.join(MEDIUM_DELAY_MS);
        t2.join(MEDIUM_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((!t1.isAlive() ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((!t2.isAlive() ? 1 : 0) != 0);
    }

    public void testTryLockWhenReadLocked() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantReadWriteLockTest.this.threadAssertTrue(lock.readLock().tryLock());
                lock.readLock().unlock();
            }
        });
        t.start();
        t.join();
        lock.readLock().unlock();
    }

    public void testWriteTryLockWhenReadLocked() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.writeLock().tryLock());
            }
        });
        t.start();
        t.join();
        lock.readLock().unlock();
    }

    public void testTryLockWhenReadLockedFair() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.readLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantReadWriteLockTest.this.threadAssertTrue(lock.readLock().tryLock());
                lock.readLock().unlock();
            }
        });
        t.start();
        t.join();
        lock.readLock().unlock();
    }

    public void testWriteTryLockWhenReadLockedFair() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.readLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.writeLock().tryLock());
            }
        });
        t.start();
        t.join();
        lock.readLock().unlock();
    }

    public void testWriteTryLock_Timeout() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.writeLock().tryLock(1L, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        t.join();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.writeLock().isHeldByCurrentThread());
        lock.writeLock().unlock();
    }

    public void testReadTryLock_Timeout() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.readLock().tryLock(1L, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        t.join();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.writeLock().isHeldByCurrentThread());
        lock.writeLock().unlock();
    }

    public void testWriteLockInterruptibly() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lockInterruptibly();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lockInterruptibly();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        t.join();
        lock.writeLock().unlock();
    }

    public void testReadLockInterruptibly() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lockInterruptibly();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.readLock().lockInterruptibly();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        lock.writeLock().unlock();
    }

    public void testAwait_IllegalMonitor() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            c.await();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testSignal_IllegalMonitor() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            c.signal();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testAwaitNanos_Timeout() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        lock.writeLock().lock();
        long t = c.awaitNanos(100L);
        ReentrantReadWriteLockTest.assertTrue((t <= 0L ? 1 : 0) != 0);
        lock.writeLock().unlock();
    }

    public void testAwait_Timeout() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertFalse((boolean)c.await(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        lock.writeLock().unlock();
    }

    public void testAwaitUntil_Timeout() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        lock.writeLock().lock();
        Date d = new Date();
        ReentrantReadWriteLockTest.assertFalse((boolean)c.awaitUntil(new Date(d.getTime() + 10L)));
        lock.writeLock().unlock();
    }

    public void testAwait() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                c.await();
                lock.writeLock().unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        c.signal();
        lock.writeLock().unlock();
        t.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t.isAlive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwaitUninterruptibly() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        UninterruptableThread thread = new UninterruptableThread(lock.writeLock(), c);
        thread.start();
        while (!thread.lockStarted) {
            Thread.sleep(100L);
        }
        lock.writeLock().lock();
        try {
            thread.interrupt();
            thread.canAwake = true;
            c.signal();
        }
        finally {
            lock.writeLock().unlock();
        }
        thread.join();
        ReentrantReadWriteLockTest.assertTrue((boolean)thread.interrupted);
        ReentrantReadWriteLockTest.assertFalse((boolean)thread.isAlive());
    }

    public void testAwait_Interrupt() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                c.await();
                lock.writeLock().unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testAwaitNanos_Interrupt() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                c.awaitNanos(TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.LONG_DELAY_MS));
                lock.writeLock().unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testAwaitUntil_Interrupt() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                Date d = new Date();
                c.awaitUntil(new Date(d.getTime() + 10000L));
                lock.writeLock().unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testSignalAll() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                c.await();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                c.await();
                lock.writeLock().unlock();
            }
        });
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        c.signalAll();
        lock.writeLock().unlock();
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t1.isAlive());
        ReentrantReadWriteLockTest.assertFalse((boolean)t2.isAlive());
    }

    public void testSerialization() throws Exception {
        ReentrantReadWriteLock l = new ReentrantReadWriteLock();
        l.readLock().lock();
        l.readLock().unlock();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ReentrantReadWriteLock r = (ReentrantReadWriteLock)in.readObject();
        r.readLock().lock();
        r.readLock().unlock();
    }

    public void testhasQueuedThreads() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        lock.writeLock().lock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        lock.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        t1.join();
        t2.join();
    }

    public void testHasQueuedThreadNPE() {
        ReentrantReadWriteLock sync = new ReentrantReadWriteLock();
        try {
            sync.hasQueuedThread(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasQueuedThread() throws InterruptedException {
        ReentrantReadWriteLock sync = new ReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(sync));
        Thread t2 = new Thread(new InterruptibleLockRunnable(sync));
        ReentrantReadWriteLockTest.assertFalse((boolean)sync.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertFalse((boolean)sync.hasQueuedThread(t2));
        sync.writeLock().lock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)sync.hasQueuedThread(t1));
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)sync.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)sync.hasQueuedThread(t2));
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)sync.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)sync.hasQueuedThread(t2));
        sync.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)sync.hasQueuedThread(t1));
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)sync.hasQueuedThread(t2));
        t1.join();
        t2.join();
    }

    public void testGetQueueLength() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.writeLock().lock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        t1.join();
        t2.join();
    }

    public void testGetQueuedThreads() throws InterruptedException {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        lock.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.join();
        t2.join();
    }

    public void testHasWaitersNPE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try {
            lock.hasWaiters(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthNPE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try {
            lock.getWaitQueueLength(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsNPE() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        try {
            lock.getWaitingThreads(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasWaitersIAE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock();
        try {
            lock2.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testHasWaitersIMSE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            lock.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIAE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock();
        try {
            lock2.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIMSE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            lock.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIAE() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        PublicReentrantReadWriteLock lock2 = new PublicReentrantReadWriteLock();
        try {
            lock2.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIMSE() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            lock.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testHasWaiters() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.hasWaiters(c));
                ReentrantReadWriteLockTest.this.threadAssertEquals(0L, lock.getWaitQueueLength(c));
                c.await();
                lock.writeLock().unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getWaitQueueLength(c));
        c.signal();
        lock.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
        lock.writeLock().unlock();
        t.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testGetWaitQueueLength() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.hasWaiters(c));
                ReentrantReadWriteLockTest.this.threadAssertEquals(0L, lock.getWaitQueueLength(c));
                c.await();
                lock.writeLock().unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getWaitQueueLength(c));
        c.signal();
        lock.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
        lock.writeLock().unlock();
        t.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testGetWaitingThreads() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.threadAssertTrue(lock.getWaitingThreads(c).isEmpty());
                c.await();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.threadAssertFalse(lock.getWaitingThreads(c).isEmpty());
                c.await();
                lock.writeLock().unlock();
            }
        });
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
        lock.writeLock().unlock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t2));
        c.signalAll();
        lock.writeLock().unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
        lock.writeLock().unlock();
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        ReentrantReadWriteLockTest.assertFalse((boolean)t1.isAlive());
        ReentrantReadWriteLockTest.assertFalse((boolean)t2.isAlive());
    }

    public void testToString() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        String us = lock.toString();
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Write locks = 0") >= 0 ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Read locks = 0") >= 0 ? 1 : 0) != 0);
        lock.writeLock().lock();
        String ws = lock.toString();
        ReentrantReadWriteLockTest.assertTrue((ws.indexOf("Write locks = 1") >= 0 ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((ws.indexOf("Read locks = 0") >= 0 ? 1 : 0) != 0);
        lock.writeLock().unlock();
        lock.readLock().lock();
        lock.readLock().lock();
        String rs = lock.toString();
        ReentrantReadWriteLockTest.assertTrue((rs.indexOf("Write locks = 0") >= 0 ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((rs.indexOf("Read locks = 2") >= 0 ? 1 : 0) != 0);
    }

    public void testReadLockToString() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        String us = lock.readLock().toString();
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Read locks = 0") >= 0 ? 1 : 0) != 0);
        lock.readLock().lock();
        lock.readLock().lock();
        String rs = lock.readLock().toString();
        ReentrantReadWriteLockTest.assertTrue((rs.indexOf("Read locks = 2") >= 0 ? 1 : 0) != 0);
    }

    public void testWriteLockToString() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        String us = lock.writeLock().toString();
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Unlocked") >= 0 ? 1 : 0) != 0);
        lock.writeLock().lock();
        String ls = lock.writeLock().toString();
        ReentrantReadWriteLockTest.assertTrue((ls.indexOf("Locked") >= 0 ? 1 : 0) != 0);
    }

    class UninterruptableThread
    extends Thread {
        private Lock lock;
        private Condition c;
        public volatile boolean canAwake = false;
        public volatile boolean interrupted = false;
        public volatile boolean lockStarted = false;

        public UninterruptableThread(Lock lock, Condition c) {
            this.lock = lock;
            this.c = c;
        }

        public synchronized void run() {
            this.lock.lock();
            this.lockStarted = true;
            while (!this.canAwake) {
                this.c.awaitUninterruptibly();
            }
            this.interrupted = this.isInterrupted();
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PublicReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        PublicReentrantReadWriteLock() {
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        @Override
        public Collection<Thread> getWaitingThreads(Condition c) {
            return super.getWaitingThreads(c);
        }
    }

    class InterruptedLockRunnable
    extends JSR166TestCase.CheckedInterruptedRunnable {
        final ReentrantReadWriteLock lock;

        InterruptedLockRunnable(ReentrantReadWriteLock l) {
            this.lock = l;
        }

        public void realRun() throws InterruptedException {
            this.lock.writeLock().lockInterruptibly();
        }
    }

    class InterruptibleLockRunnable
    extends JSR166TestCase.CheckedRunnable {
        final ReentrantReadWriteLock lock;

        InterruptibleLockRunnable(ReentrantReadWriteLock l) {
            this.lock = l;
        }

        public void realRun() throws InterruptedException {
            this.lock.writeLock().lockInterruptibly();
        }
    }
}

