/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ReentrantLockTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ReentrantLockTest.class);
    }

    public void testConstructor() {
        ReentrantLockTest.assertFalse((boolean)new ReentrantLock().isFair());
        ReentrantLockTest.assertFalse((boolean)new ReentrantLock(false).isFair());
        ReentrantLockTest.assertTrue((boolean)new ReentrantLock(true).isFair());
    }

    public void testLock() {
        ReentrantLock rl = new ReentrantLock();
        rl.lock();
        ReentrantLockTest.assertTrue((boolean)rl.isLocked());
        rl.unlock();
        ReentrantLockTest.assertFalse((boolean)rl.isLocked());
    }

    public void testFairLock() {
        ReentrantLock rl = new ReentrantLock(true);
        rl.lock();
        ReentrantLockTest.assertTrue((boolean)rl.isLocked());
        rl.unlock();
    }

    public void testUnlock_IllegalMonitorStateException() {
        ReentrantLock rl = new ReentrantLock();
        try {
            rl.unlock();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testTryLock() {
        ReentrantLock rl = new ReentrantLock();
        ReentrantLockTest.assertTrue((boolean)rl.tryLock());
        ReentrantLockTest.assertTrue((boolean)rl.isLocked());
        rl.unlock();
    }

    public void testhasQueuedThreads() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        lock.lock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        lock.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        t1.join();
        t2.join();
    }

    public void testGetQueueLength() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.lock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        t1.join();
        t2.join();
    }

    public void testGetQueueLength_fair() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock(true);
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.lock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        t1.join();
        t2.join();
    }

    public void testHasQueuedThreadNPE() {
        ReentrantLock sync = new ReentrantLock();
        try {
            sync.hasQueuedThread(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasQueuedThread() throws InterruptedException {
        ReentrantLock sync = new ReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(sync));
        Thread t2 = new Thread(new InterruptibleLockRunnable(sync));
        ReentrantLockTest.assertFalse((boolean)sync.hasQueuedThread(t1));
        ReentrantLockTest.assertFalse((boolean)sync.hasQueuedThread(t2));
        sync.lock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)sync.hasQueuedThread(t1));
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)sync.hasQueuedThread(t1));
        ReentrantLockTest.assertTrue((boolean)sync.hasQueuedThread(t2));
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)sync.hasQueuedThread(t1));
        ReentrantLockTest.assertTrue((boolean)sync.hasQueuedThread(t2));
        sync.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)sync.hasQueuedThread(t1));
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)sync.hasQueuedThread(t2));
        t1.join();
        t2.join();
    }

    public void testGetQueuedThreads() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        t1.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        lock.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.join();
        t2.join();
    }

    public void testInterruptedException2() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        lock.lock();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.tryLock(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTryLockWhenLocked() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        lock.lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                ReentrantLockTest.this.threadAssertFalse(lock.tryLock());
            }
        });
        t.start();
        t.join();
        lock.unlock();
    }

    public void testTryLock_Timeout() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        lock.lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                ReentrantLockTest.this.threadAssertFalse(lock.tryLock(1L, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        t.join();
        lock.unlock();
    }

    public void testGetHoldCount() {
        int i;
        ReentrantLock lock = new ReentrantLock();
        for (i = 1; i <= 20; ++i) {
            lock.lock();
            ReentrantLockTest.assertEquals((int)i, (int)lock.getHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.unlock();
            ReentrantLockTest.assertEquals((int)(i - 1), (int)lock.getHoldCount());
        }
    }

    public void testIsLocked() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        lock.unlock();
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                lock.unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        t.join();
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
    }

    public void testLockInterruptibly1() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        Thread t = new Thread(new InterruptedLockRunnable(lock));
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        Thread.sleep(SHORT_DELAY_MS);
        lock.unlock();
        t.join();
    }

    public void testLockInterruptibly2() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        lock.lockInterruptibly();
        Thread t = new Thread(new InterruptedLockRunnable(lock));
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        ReentrantLockTest.assertTrue((boolean)lock.isHeldByCurrentThread());
        t.join();
    }

    public void testAwait_IllegalMonitor() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            c.await();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testSignal_IllegalMonitor() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            c.signal();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testAwaitNanos_Timeout() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        lock.lock();
        long t = c.awaitNanos(100L);
        ReentrantLockTest.assertTrue((t <= 0L ? 1 : 0) != 0);
        lock.unlock();
    }

    public void testAwait_Timeout() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        lock.lock();
        ReentrantLockTest.assertFalse((boolean)c.await(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        lock.unlock();
    }

    public void testAwaitUntil_Timeout() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        lock.lock();
        Date d = new Date();
        ReentrantLockTest.assertFalse((boolean)c.awaitUntil(new Date(d.getTime() + 10L)));
        lock.unlock();
    }

    public void testAwait() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                c.await();
                lock.unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        c.signal();
        lock.unlock();
        t.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testHasWaitersNPE() {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.hasWaiters(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthNPE() {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.getWaitQueueLength(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsNPE() {
        PublicReentrantLock lock = new PublicReentrantLock();
        try {
            lock.getWaitingThreads(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasWaitersIAE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        ReentrantLock lock2 = new ReentrantLock();
        try {
            lock2.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testHasWaitersIMSE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            lock.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIAE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        ReentrantLock lock2 = new ReentrantLock();
        try {
            lock2.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIMSE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            lock.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIAE() {
        PublicReentrantLock lock = new PublicReentrantLock();
        Condition c = lock.newCondition();
        PublicReentrantLock lock2 = new PublicReentrantLock();
        try {
            lock2.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIMSE() {
        PublicReentrantLock lock = new PublicReentrantLock();
        Condition c = lock.newCondition();
        try {
            lock.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testHasWaiters() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.threadAssertFalse(lock.hasWaiters(c));
                ReentrantLockTest.this.threadAssertEquals(0L, lock.getWaitQueueLength(c));
                c.await();
                lock.unlock();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.hasWaiters(c));
        ReentrantLockTest.assertEquals((int)1, (int)lock.getWaitQueueLength(c));
        c.signal();
        lock.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        ReentrantLockTest.assertFalse((boolean)lock.hasWaiters(c));
        ReentrantLockTest.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
        lock.unlock();
        t.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testGetWaitQueueLength() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.threadAssertFalse(lock.hasWaiters(c));
                ReentrantLockTest.this.threadAssertEquals(0L, lock.getWaitQueueLength(c));
                c.await();
                lock.unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.threadAssertTrue(lock.hasWaiters(c));
                ReentrantLockTest.this.threadAssertEquals(1L, lock.getWaitQueueLength(c));
                c.await();
                lock.unlock();
            }
        });
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.hasWaiters(c));
        ReentrantLockTest.assertEquals((int)2, (int)lock.getWaitQueueLength(c));
        c.signalAll();
        lock.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        ReentrantLockTest.assertFalse((boolean)lock.hasWaiters(c));
        ReentrantLockTest.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
        lock.unlock();
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t1.isAlive());
        ReentrantLockTest.assertFalse((boolean)t2.isAlive());
    }

    public void testGetWaitingThreads() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.threadAssertTrue(lock.getWaitingThreads(c).isEmpty());
                c.await();
                lock.unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.threadAssertFalse(lock.getWaitingThreads(c).isEmpty());
                c.await();
                lock.unlock();
            }
        });
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
        lock.unlock();
        t1.start();
        Thread.sleep(SHORT_DELAY_MS);
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.hasWaiters(c));
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t1));
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t2));
        c.signalAll();
        lock.unlock();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        ReentrantLockTest.assertFalse((boolean)lock.hasWaiters(c));
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
        lock.unlock();
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t1.isAlive());
        ReentrantLockTest.assertFalse((boolean)t2.isAlive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwaitUninterruptibly() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        UninterruptibleThread thread = new UninterruptibleThread(lock, c);
        thread.start();
        while (!thread.lockStarted) {
            Thread.sleep(100L);
        }
        lock.lock();
        try {
            thread.interrupt();
            thread.canAwake = true;
            c.signal();
        }
        finally {
            lock.unlock();
        }
        thread.join();
        ReentrantLockTest.assertTrue((boolean)thread.interrupted);
        ReentrantLockTest.assertFalse((boolean)thread.isAlive());
    }

    public void testAwait_Interrupt() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                c.await();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testAwaitNanos_Interrupt() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                c.awaitNanos(TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.LONG_DELAY_MS));
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testAwaitUntil_Interrupt() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                Date d = new Date();
                c.awaitUntil(new Date(d.getTime() + 10000L));
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t.isAlive());
    }

    public void testSignalAll() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                c.await();
                lock.unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                c.await();
                lock.unlock();
            }
        });
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        c.signalAll();
        lock.unlock();
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t1.isAlive());
        ReentrantLockTest.assertFalse((boolean)t2.isAlive());
    }

    public void testAwaitLockCount() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.threadAssertEquals(1L, lock.getHoldCount());
                c.await();
                ReentrantLockTest.this.threadAssertEquals(1L, lock.getHoldCount());
                lock.unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                lock.lock();
                lock.lock();
                ReentrantLockTest.this.threadAssertEquals(2L, lock.getHoldCount());
                c.await();
                ReentrantLockTest.this.threadAssertEquals(2L, lock.getHoldCount());
                lock.unlock();
                lock.unlock();
            }
        });
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        lock.lock();
        c.signalAll();
        lock.unlock();
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        ReentrantLockTest.assertFalse((boolean)t1.isAlive());
        ReentrantLockTest.assertFalse((boolean)t2.isAlive());
    }

    public void testSerialization() throws Exception {
        ReentrantLock l = new ReentrantLock();
        l.lock();
        l.unlock();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ReentrantLock r = (ReentrantLock)in.readObject();
        r.lock();
        r.unlock();
    }

    public void testToString() {
        ReentrantLock lock = new ReentrantLock();
        String us = lock.toString();
        ReentrantLockTest.assertTrue((us.indexOf("Unlocked") >= 0 ? 1 : 0) != 0);
        lock.lock();
        String ls = lock.toString();
        ReentrantLockTest.assertTrue((ls.indexOf("Locked") >= 0 ? 1 : 0) != 0);
    }

    class UninterruptibleThread
    extends Thread {
        private ReentrantLock lock;
        private Condition c;
        public volatile boolean canAwake = false;
        public volatile boolean interrupted = false;
        public volatile boolean lockStarted = false;

        public UninterruptibleThread(ReentrantLock lock, Condition c) {
            this.lock = lock;
            this.c = c;
        }

        public synchronized void run() {
            this.lock.lock();
            this.lockStarted = true;
            while (!this.canAwake) {
                this.c.awaitUninterruptibly();
            }
            this.interrupted = this.isInterrupted();
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PublicReentrantLock
    extends ReentrantLock {
        PublicReentrantLock() {
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        @Override
        public Collection<Thread> getWaitingThreads(Condition c) {
            return super.getWaitingThreads(c);
        }
    }

    class InterruptedLockRunnable
    extends JSR166TestCase.CheckedInterruptedRunnable {
        final ReentrantLock lock;

        InterruptedLockRunnable(ReentrantLock l) {
            this.lock = l;
        }

        public void realRun() throws InterruptedException {
            this.lock.lockInterruptibly();
        }
    }

    class InterruptibleLockRunnable
    extends JSR166TestCase.CheckedRunnable {
        final ReentrantLock lock;

        InterruptibleLockRunnable(ReentrantLock l) {
            this.lock = l;
        }

        public void realRun() throws InterruptedException {
            this.lock.lockInterruptibly();
        }
    }
}

