/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class PriorityBlockingQueueTest
extends JSR166TestCase {
    private static final int NOCAP = Integer.MAX_VALUE;

    public static Test suite() {
        return new TestSuite(PriorityBlockingQueueTest.class);
    }

    private PriorityBlockingQueue populatedQueue(int n) {
        int i;
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(n);
        PriorityBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            PriorityBlockingQueueTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        for (i = n & 1; i < n; i += 2) {
            PriorityBlockingQueueTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        PriorityBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        PriorityBlockingQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        PriorityBlockingQueueTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        PriorityBlockingQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)new PriorityBlockingQueue(20).remainingCapacity());
    }

    public void testConstructor2() {
        try {
            PriorityBlockingQueue q = new PriorityBlockingQueue(0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            PriorityBlockingQueue q = new PriorityBlockingQueue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testConstructor7() {
        int i;
        MyReverseComparator cmp = new MyReverseComparator();
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(20, cmp);
        PriorityBlockingQueueTest.assertEquals((Object)cmp, q.comparator());
        Integer[] ints = new Integer[20];
        for (i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        q.addAll(Arrays.asList(ints));
        for (i = 19; i >= 0; --i) {
            PriorityBlockingQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testEmpty() {
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(2);
        PriorityBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        PriorityBlockingQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        q.add(one);
        PriorityBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        q.add(two);
        q.remove();
        q.remove();
        PriorityBlockingQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemainingCapacity() {
        int i;
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
            PriorityBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
            PriorityBlockingQueueTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        try {
            PriorityBlockingQueue<Object> q = new PriorityBlockingQueue<Object>(1);
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            PriorityBlockingQueue<Object> q = new PriorityBlockingQueue<Object>(1);
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(1);
        PriorityBlockingQueueTest.assertTrue((boolean)q.offer(zero));
        PriorityBlockingQueueTest.assertTrue((boolean)q.offer(one));
    }

    public void testOfferNonComparable() {
        try {
            PriorityBlockingQueue<Object> q = new PriorityBlockingQueue<Object>(1);
            q.offer(new Object());
            q.offer(new Object());
            q.offer(new Object());
            this.shouldThrow();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testAdd() {
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((int)i, (int)q.size());
            PriorityBlockingQueueTest.assertTrue((boolean)q.add(new Integer(i)));
        }
    }

    public void testAddAll1() {
        try {
            PriorityBlockingQueue q = new PriorityBlockingQueue(1);
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            PriorityBlockingQueue q = this.populatedQueue(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 19; i >= 0; --i) {
            ints[i] = new Integer(i);
        }
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(20);
        PriorityBlockingQueueTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        PriorityBlockingQueueTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testPutNull() {
        try {
            PriorityBlockingQueue<Object> q = new PriorityBlockingQueue<Object>(20);
            q.put(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut() {
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            Integer I2 = new Integer(i);
            q.put(I2);
            PriorityBlockingQueueTest.assertTrue((boolean)q.contains(I2));
        }
        PriorityBlockingQueueTest.assertEquals((int)20, (int)q.size());
    }

    public void testPutWithTake() throws InterruptedException {
        final PriorityBlockingQueue q = new PriorityBlockingQueue(2);
        int size = 4;
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                for (int i = 0; i < 4; ++i) {
                    q.put(new Integer(0));
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        PriorityBlockingQueueTest.assertEquals((int)q.size(), (int)4);
        q.take();
        t.interrupt();
        t.join();
    }

    public void testTimedOffer() throws InterruptedException {
        final PriorityBlockingQueue q = new PriorityBlockingQueue(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                q.put(new Integer(0));
                q.put(new Integer(0));
                Assert.assertTrue((boolean)q.offer(new Integer(0), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)q.offer(new Integer(0), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        Thread.sleep(SMALL_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTake() throws InterruptedException {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)i, q.take());
        }
    }

    public void testTakeFromEmpty() throws InterruptedException {
        final PriorityBlockingQueue q = new PriorityBlockingQueue(2);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                q.take();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testBlockingTake() throws InterruptedException {
        final PriorityBlockingQueue q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.take());
                }
                try {
                    q.take();
                    PriorityBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPoll() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)i, q.poll());
        }
        PriorityBlockingQueueTest.assertNull(q.poll());
    }

    public void testTimedPoll0() throws InterruptedException {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)i, q.poll(0L, TimeUnit.MILLISECONDS));
        }
        PriorityBlockingQueueTest.assertNull(q.poll(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPoll() throws InterruptedException {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)i, q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        PriorityBlockingQueueTest.assertNull(q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testInterruptedTimedPoll() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                PriorityBlockingQueue q = PriorityBlockingQueueTest.this.populatedQueue(20);
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                }
                try {
                    q.poll(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
                    PriorityBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedPollWithOffer() throws InterruptedException {
        final PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertSame((Object)JSR166TestCase.zero, q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    PriorityBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SMALL_DELAY_MS);
        PriorityBlockingQueueTest.assertTrue((boolean)q.offer(zero, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        t.interrupt();
        t.join();
    }

    public void testPeek() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)i, q.peek());
            PriorityBlockingQueueTest.assertEquals((Object)i, q.poll());
            PriorityBlockingQueueTest.assertTrue((q.peek() == null || !q.peek().equals(i) ? 1 : 0) != 0);
        }
        PriorityBlockingQueueTest.assertNull(q.peek());
    }

    public void testElement() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)i, q.element());
            PriorityBlockingQueueTest.assertEquals((Object)i, q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)i, q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            PriorityBlockingQueueTest.assertTrue((boolean)q.remove(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            PriorityBlockingQueueTest.assertTrue((boolean)q.remove(new Integer(i)));
            PriorityBlockingQueueTest.assertFalse((boolean)q.remove(new Integer(i + 1)));
        }
        PriorityBlockingQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            PriorityBlockingQueueTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        q.clear();
        PriorityBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        PriorityBlockingQueueTest.assertEquals((int)0, (int)q.size());
        q.add(one);
        PriorityBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        PriorityBlockingQueueTest.assertTrue((boolean)q.contains(one));
        q.clear();
        PriorityBlockingQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        PriorityBlockingQueue<Integer> p = new PriorityBlockingQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertTrue((boolean)q.containsAll(p));
            PriorityBlockingQueueTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        PriorityBlockingQueueTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        PriorityBlockingQueue p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                PriorityBlockingQueueTest.assertFalse((boolean)changed);
            } else {
                PriorityBlockingQueueTest.assertTrue((boolean)changed);
            }
            PriorityBlockingQueueTest.assertTrue((boolean)q.containsAll(p));
            PriorityBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            PriorityBlockingQueue q = this.populatedQueue(20);
            PriorityBlockingQueue p = this.populatedQueue(i);
            PriorityBlockingQueueTest.assertTrue((boolean)q.removeAll(p));
            PriorityBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I2 = (Integer)p.remove();
                PriorityBlockingQueueTest.assertFalse((boolean)q.contains(I2));
            }
        }
    }

    public void testToArray() throws InterruptedException {
        PriorityBlockingQueue q = this.populatedQueue(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)o[i], q.take());
        }
    }

    public void testToArray2() throws InterruptedException {
        PriorityBlockingQueue q = this.populatedQueue(20);
        Object[] ints = new Integer[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            PriorityBlockingQueueTest.assertEquals((Object)ints[i], q.take());
        }
    }

    public void testToArray_BadArg() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        try {
            T[] o = q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        try {
            String[] o = q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            PriorityBlockingQueueTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        PriorityBlockingQueueTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorRemove() {
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(3);
        q.add(new Integer(2));
        q.add(new Integer(1));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        PriorityBlockingQueueTest.assertEquals(it.next(), (Object)new Integer(2));
        PriorityBlockingQueueTest.assertEquals(it.next(), (Object)new Integer(3));
        PriorityBlockingQueueTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testPollInExecutor() {
        final PriorityBlockingQueue q = new PriorityBlockingQueue(2);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll());
                Assert.assertSame((Object)JSR166TestCase.one, q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)q.isEmpty());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                q.put(JSR166TestCase.one);
            }
        });
        this.joinPool(executor);
    }

    public void testSerialization() throws Exception {
        PriorityBlockingQueue q = this.populatedQueue(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        PriorityBlockingQueue r = (PriorityBlockingQueue)in.readObject();
        PriorityBlockingQueueTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            PriorityBlockingQueueTest.assertEquals(q.remove(), r.remove());
        }
    }

    public void testDrainToNull() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelf() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainTo() {
        int i;
        PriorityBlockingQueue q = this.populatedQueue(20);
        ArrayList l = new ArrayList();
        q.drainTo(l);
        PriorityBlockingQueueTest.assertEquals((int)q.size(), (int)0);
        PriorityBlockingQueueTest.assertEquals((int)l.size(), (int)20);
        for (i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        q.add(zero);
        q.add(one);
        PriorityBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        PriorityBlockingQueueTest.assertTrue((boolean)q.contains(zero));
        PriorityBlockingQueueTest.assertTrue((boolean)q.contains(one));
        l.clear();
        q.drainTo(l);
        PriorityBlockingQueueTest.assertEquals((int)q.size(), (int)0);
        PriorityBlockingQueueTest.assertEquals((int)l.size(), (int)2);
        for (i = 0; i < 2; ++i) {
            PriorityBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
    }

    public void testDrainToWithActivePut() throws InterruptedException {
        final PriorityBlockingQueue q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                q.put(new Integer(21));
            }
        });
        t.start();
        ArrayList l = new ArrayList();
        q.drainTo(l);
        PriorityBlockingQueueTest.assertTrue((l.size() >= 20 ? 1 : 0) != 0);
        for (int i = 0; i < 20; ++i) {
            PriorityBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        t.join();
        PriorityBlockingQueueTest.assertTrue((q.size() + l.size() >= 20 ? 1 : 0) != 0);
    }

    public void testDrainToNullN() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(null, 0);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelfN() {
        PriorityBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(q, 0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainToN() {
        PriorityBlockingQueue<Integer> q = new PriorityBlockingQueue<Integer>(40);
        for (int i = 0; i < 22; ++i) {
            for (int j = 0; j < 20; ++j) {
                PriorityBlockingQueueTest.assertTrue((boolean)q.offer(new Integer(j)));
            }
            ArrayList l = new ArrayList();
            q.drainTo(l, i);
            int k = i < 20 ? i : 20;
            PriorityBlockingQueueTest.assertEquals((int)l.size(), (int)k);
            PriorityBlockingQueueTest.assertEquals((int)q.size(), (int)(20 - k));
            for (int j = 0; j < k; ++j) {
                PriorityBlockingQueueTest.assertEquals(l.get(j), (Object)new Integer(j));
            }
            while (q.poll() != null) {
            }
        }
    }

    static class MyReverseComparator
    implements Comparator {
        MyReverseComparator() {
        }

        public int compare(Object x, Object y) {
            return ((Comparable)y).compareTo(x);
        }
    }
}

