/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.Date;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class LockSupportTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(LockSupportTest.class);
    }

    public void testPark() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                LockSupport.park();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        LockSupport.unpark(t);
        t.join();
    }

    public void testPark2() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SHORT_DELAY_MS);
                LockSupport.park();
            }
        });
        t.start();
        LockSupport.unpark(t);
        t.join();
    }

    public void testPark3() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                LockSupport.park();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPark4() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        lock.lock();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                lock.lock();
                LockSupport.park();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        lock.unlock();
        t.join();
    }

    public void testParkNanos() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                LockSupport.parkNanos(1000L);
            }
        });
        t.start();
        t.join();
    }

    public void testParkUntil() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                long d = new Date().getTime() + 100L;
                LockSupport.parkUntil(d);
            }
        });
        t.start();
        t.join();
    }
}

