/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class LinkedListTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(LinkedListTest.class);
    }

    private LinkedList populatedQueue(int n) {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            LinkedListTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        LinkedListTest.assertFalse((boolean)q.isEmpty());
        LinkedListTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        LinkedListTest.assertEquals((int)0, (int)new LinkedList().size());
    }

    public void testConstructor3() {
        try {
            LinkedList q = new LinkedList(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        LinkedList<Integer> q = new LinkedList<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmpty() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        LinkedListTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.remove();
        q.remove();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        LinkedList q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        try {
            LinkedList<Object> q = new LinkedList<Object>();
            q.offer(null);
        }
        catch (NullPointerException ie) {
            this.unexpectedException();
        }
    }

    public void testOffer() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.offer(new Integer(0)));
        LinkedListTest.assertTrue((boolean)q.offer(new Integer(1)));
    }

    public void testAdd() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)q.size());
            LinkedListTest.assertTrue((boolean)q.add(new Integer(i)));
        }
    }

    public void testAddAll1() {
        try {
            LinkedList q = new LinkedList();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        LinkedListTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testAddAll2_IndexOutOfBoundsException() {
        try {
            LinkedList<Object> l = new LinkedList<Object>();
            l.add(new Object());
            LinkedList<Object> m = new LinkedList<Object>();
            m.add(new Object());
            l.addAll(4, m);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAddAll4_BadIndex() {
        try {
            LinkedList<Object> l = new LinkedList<Object>();
            l.add(new Object());
            LinkedList<Object> m = new LinkedList<Object>();
            m.add(new Object());
            l.addAll(-1, m);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testPoll() {
        LinkedList q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)((Integer)q.poll()));
        }
        LinkedListTest.assertNull(q.poll());
    }

    public void testPeek() {
        LinkedList q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)((Integer)q.peek()));
            q.poll();
            LinkedListTest.assertTrue((q.peek() == null || i != (Integer)q.peek() ? 1 : 0) != 0);
        }
        LinkedListTest.assertNull(q.peek());
    }

    public void testElement() {
        LinkedList q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)((Integer)q.element()));
            q.poll();
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        LinkedList q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)((Integer)q.remove()));
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        LinkedList q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.remove(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.remove(new Integer(i)));
            LinkedListTest.assertFalse((boolean)q.remove(new Integer(i + 1)));
        }
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        LinkedList q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            LinkedListTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        LinkedList q = this.populatedQueue(20);
        q.clear();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
        LinkedListTest.assertEquals((int)0, (int)q.size());
        q.add(new Integer(1));
        LinkedListTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        LinkedList q = this.populatedQueue(20);
        LinkedList<Integer> p = new LinkedList<Integer>();
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertTrue((boolean)q.containsAll(p));
            LinkedListTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        LinkedListTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        LinkedList q = this.populatedQueue(20);
        LinkedList p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                LinkedListTest.assertFalse((boolean)changed);
            } else {
                LinkedListTest.assertTrue((boolean)changed);
            }
            LinkedListTest.assertTrue((boolean)q.containsAll(p));
            LinkedListTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            LinkedList q = this.populatedQueue(20);
            LinkedList p = this.populatedQueue(i);
            LinkedListTest.assertTrue((boolean)q.removeAll(p));
            LinkedListTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I2 = (Integer)p.remove();
                LinkedListTest.assertFalse((boolean)q.contains(I2));
            }
        }
    }

    public void testToArray() {
        LinkedList q = this.populatedQueue(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            LinkedListTest.assertEquals((Object)o[i], q.poll());
        }
    }

    public void testToArray2() {
        LinkedList q = this.populatedQueue(20);
        Object[] ints = new Integer[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            LinkedListTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testToArray_BadArg() {
        try {
            LinkedList<Object> l = new LinkedList<Object>();
            l.add(new Object());
            T[] o = l.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        try {
            LinkedList<Integer> l = new LinkedList<Integer>();
            l.add(new Integer(5));
            String[] o = l.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        LinkedList q = this.populatedQueue(20);
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            LinkedListTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LinkedListTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorOrdering() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(new Integer(1));
        q.add(new Integer(2));
        q.add(new Integer(3));
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            int i = (Integer)it.next();
            LinkedListTest.assertEquals((int)(++k), (int)i);
        }
        LinkedListTest.assertEquals((int)3, (int)k);
    }

    public void testIteratorRemove() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(new Integer(1));
        q.add(new Integer(2));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        LinkedListTest.assertEquals(it.next(), (Object)new Integer(2));
        LinkedListTest.assertEquals(it.next(), (Object)new Integer(3));
        LinkedListTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        LinkedList q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testAddFirst() {
        LinkedList q = this.populatedQueue(3);
        q.addFirst(four);
        LinkedListTest.assertEquals((Object)four, q.peek());
    }
}

