/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.FilePermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.AbstractExecutorServiceTest;
import tests.api.java.util.concurrent.AbstractQueueTest;
import tests.api.java.util.concurrent.AbstractQueuedLongSynchronizerTest;
import tests.api.java.util.concurrent.AbstractQueuedSynchronizerTest;
import tests.api.java.util.concurrent.ArrayBlockingQueueTest;
import tests.api.java.util.concurrent.ArrayDequeTest;
import tests.api.java.util.concurrent.AtomicBooleanTest;
import tests.api.java.util.concurrent.AtomicIntegerArrayTest;
import tests.api.java.util.concurrent.AtomicIntegerFieldUpdaterTest;
import tests.api.java.util.concurrent.AtomicIntegerTest;
import tests.api.java.util.concurrent.AtomicLongArrayTest;
import tests.api.java.util.concurrent.AtomicLongFieldUpdaterTest;
import tests.api.java.util.concurrent.AtomicLongTest;
import tests.api.java.util.concurrent.AtomicMarkableReferenceTest;
import tests.api.java.util.concurrent.AtomicReferenceArrayTest;
import tests.api.java.util.concurrent.AtomicReferenceFieldUpdaterTest;
import tests.api.java.util.concurrent.AtomicReferenceTest;
import tests.api.java.util.concurrent.AtomicStampedReferenceTest;
import tests.api.java.util.concurrent.ConcurrentHashMapTest;
import tests.api.java.util.concurrent.ConcurrentLinkedQueueTest;
import tests.api.java.util.concurrent.ConcurrentSkipListMapTest;
import tests.api.java.util.concurrent.ConcurrentSkipListSetTest;
import tests.api.java.util.concurrent.ConcurrentSkipListSubMapTest;
import tests.api.java.util.concurrent.ConcurrentSkipListSubSetTest;
import tests.api.java.util.concurrent.CopyOnWriteArrayListTest;
import tests.api.java.util.concurrent.CopyOnWriteArraySetTest;
import tests.api.java.util.concurrent.CountDownLatchTest;
import tests.api.java.util.concurrent.CyclicBarrierTest;
import tests.api.java.util.concurrent.DelayQueueTest;
import tests.api.java.util.concurrent.EntryTest;
import tests.api.java.util.concurrent.ExchangerTest;
import tests.api.java.util.concurrent.ExecutorCompletionServiceTest;
import tests.api.java.util.concurrent.ExecutorsTest;
import tests.api.java.util.concurrent.FutureTaskTest;
import tests.api.java.util.concurrent.LinkedBlockingDequeTest;
import tests.api.java.util.concurrent.LinkedBlockingQueueTest;
import tests.api.java.util.concurrent.LinkedListTest;
import tests.api.java.util.concurrent.LockSupportTest;
import tests.api.java.util.concurrent.PriorityBlockingQueueTest;
import tests.api.java.util.concurrent.PriorityQueueTest;
import tests.api.java.util.concurrent.ReentrantLockTest;
import tests.api.java.util.concurrent.ReentrantReadWriteLockTest;
import tests.api.java.util.concurrent.ScheduledExecutorSubclassTest;
import tests.api.java.util.concurrent.ScheduledExecutorTest;
import tests.api.java.util.concurrent.SemaphoreTest;
import tests.api.java.util.concurrent.SynchronousQueueTest;
import tests.api.java.util.concurrent.SystemTest;
import tests.api.java.util.concurrent.ThreadLocalTest;
import tests.api.java.util.concurrent.ThreadPoolExecutorSubclassTest;
import tests.api.java.util.concurrent.ThreadPoolExecutorTest;
import tests.api.java.util.concurrent.ThreadTest;
import tests.api.java.util.concurrent.TimeUnitTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR166TestCase
extends TestCase {
    private static final boolean useSecurityManager = Boolean.getBoolean("jsr166.useSecurityManager");
    public static long SHORT_DELAY_MS;
    public static long SMALL_DELAY_MS;
    public static long MEDIUM_DELAY_MS;
    public static long LONG_DELAY_MS;
    volatile boolean threadFailed;
    public static final int SIZE = 20;
    public static final Integer zero;
    public static final Integer one;
    public static final Integer two;
    public static final Integer three;
    public static final Integer four;
    public static final Integer five;
    public static final Integer six;
    public static final Integer seven;
    public static final Integer eight;
    public static final Integer nine;
    public static final Integer m1;
    public static final Integer m2;
    public static final Integer m3;
    public static final Integer m4;
    public static final Integer m5;
    public static final Integer m6;
    public static final Integer m10;
    public static final String TEST_STRING = "a test string";

    public static Test suite() {
        TestSuite suite = new TestSuite("JSR166 Unit Tests");
        suite.addTest((Test)new TestSuite(AbstractExecutorServiceTest.class));
        suite.addTest((Test)new TestSuite(AbstractQueueTest.class));
        suite.addTest((Test)new TestSuite(AbstractQueuedSynchronizerTest.class));
        suite.addTest((Test)new TestSuite(AbstractQueuedLongSynchronizerTest.class));
        suite.addTest((Test)new TestSuite(ArrayBlockingQueueTest.class));
        suite.addTest((Test)new TestSuite(ArrayDequeTest.class));
        suite.addTest((Test)new TestSuite(AtomicBooleanTest.class));
        suite.addTest((Test)new TestSuite(AtomicIntegerArrayTest.class));
        suite.addTest((Test)new TestSuite(AtomicIntegerFieldUpdaterTest.class));
        suite.addTest((Test)new TestSuite(AtomicIntegerTest.class));
        suite.addTest((Test)new TestSuite(AtomicLongArrayTest.class));
        suite.addTest((Test)new TestSuite(AtomicLongFieldUpdaterTest.class));
        suite.addTest((Test)new TestSuite(AtomicLongTest.class));
        suite.addTest((Test)new TestSuite(AtomicMarkableReferenceTest.class));
        suite.addTest((Test)new TestSuite(AtomicReferenceArrayTest.class));
        suite.addTest((Test)new TestSuite(AtomicReferenceFieldUpdaterTest.class));
        suite.addTest((Test)new TestSuite(AtomicReferenceTest.class));
        suite.addTest((Test)new TestSuite(AtomicStampedReferenceTest.class));
        suite.addTest((Test)new TestSuite(ConcurrentHashMapTest.class));
        suite.addTest((Test)new TestSuite(ConcurrentLinkedQueueTest.class));
        suite.addTest((Test)new TestSuite(ConcurrentSkipListMapTest.class));
        suite.addTest((Test)new TestSuite(ConcurrentSkipListSubMapTest.class));
        suite.addTest((Test)new TestSuite(ConcurrentSkipListSetTest.class));
        suite.addTest((Test)new TestSuite(ConcurrentSkipListSubSetTest.class));
        suite.addTest((Test)new TestSuite(CopyOnWriteArrayListTest.class));
        suite.addTest((Test)new TestSuite(CopyOnWriteArraySetTest.class));
        suite.addTest((Test)new TestSuite(CountDownLatchTest.class));
        suite.addTest((Test)new TestSuite(CyclicBarrierTest.class));
        suite.addTest((Test)new TestSuite(DelayQueueTest.class));
        suite.addTest((Test)new TestSuite(EntryTest.class));
        suite.addTest((Test)new TestSuite(ExchangerTest.class));
        suite.addTest((Test)new TestSuite(ExecutorsTest.class));
        suite.addTest((Test)new TestSuite(ExecutorCompletionServiceTest.class));
        suite.addTest((Test)new TestSuite(FutureTaskTest.class));
        suite.addTest((Test)new TestSuite(LinkedBlockingDequeTest.class));
        suite.addTest((Test)new TestSuite(LinkedBlockingQueueTest.class));
        suite.addTest((Test)new TestSuite(LinkedListTest.class));
        suite.addTest((Test)new TestSuite(LockSupportTest.class));
        suite.addTest((Test)new TestSuite(PriorityBlockingQueueTest.class));
        suite.addTest((Test)new TestSuite(PriorityQueueTest.class));
        suite.addTest((Test)new TestSuite(ReentrantLockTest.class));
        suite.addTest((Test)new TestSuite(ReentrantReadWriteLockTest.class));
        suite.addTest((Test)new TestSuite(ScheduledExecutorTest.class));
        suite.addTest((Test)new TestSuite(ScheduledExecutorSubclassTest.class));
        suite.addTest((Test)new TestSuite(SemaphoreTest.class));
        suite.addTest((Test)new TestSuite(SynchronousQueueTest.class));
        suite.addTest((Test)new TestSuite(SystemTest.class));
        suite.addTest((Test)new TestSuite(ThreadLocalTest.class));
        suite.addTest((Test)new TestSuite(ThreadPoolExecutorTest.class));
        suite.addTest((Test)new TestSuite(ThreadPoolExecutorSubclassTest.class));
        suite.addTest((Test)new TestSuite(ThreadTest.class));
        suite.addTest((Test)new TestSuite(TimeUnitTest.class));
        return suite;
    }

    protected long getShortDelay() {
        return 250L;
    }

    protected void setDelays() {
        SHORT_DELAY_MS = this.getShortDelay();
        SMALL_DELAY_MS = SHORT_DELAY_MS * 5L;
        MEDIUM_DELAY_MS = SHORT_DELAY_MS * 10L;
        LONG_DELAY_MS = SHORT_DELAY_MS * 50L;
    }

    public void setUp() {
        this.setDelays();
        this.threadFailed = false;
    }

    public void tearDown() {
        JSR166TestCase.assertFalse((boolean)this.threadFailed);
    }

    public void threadFail(String reason) {
        this.threadFailed = true;
        JSR166TestCase.fail((String)reason);
    }

    public void threadAssertTrue(boolean b) {
        if (!b) {
            this.threadFailed = true;
            JSR166TestCase.assertTrue((boolean)b);
        }
    }

    public void threadAssertFalse(boolean b) {
        if (b) {
            this.threadFailed = true;
            JSR166TestCase.assertFalse((boolean)b);
        }
    }

    public void threadAssertNull(Object x) {
        if (x != null) {
            this.threadFailed = true;
            JSR166TestCase.assertNull((Object)x);
        }
    }

    public void threadAssertEquals(long x, long y) {
        if (x != y) {
            this.threadFailed = true;
            JSR166TestCase.assertEquals((long)x, (long)y);
        }
    }

    public void threadAssertEquals(Object x, Object y) {
        if (!(x == y || x != null && x.equals(y))) {
            this.threadFailed = true;
            JSR166TestCase.assertEquals((Object)x, (Object)y);
        }
    }

    public void threadShouldThrow() {
        this.threadFailed = true;
        JSR166TestCase.fail((String)"should throw exception");
    }

    public void threadShouldThrow(String exceptionName) {
        this.threadFailed = true;
        JSR166TestCase.fail((String)("should throw " + exceptionName));
    }

    public void threadUnexpectedException() {
        this.threadFailed = true;
        JSR166TestCase.fail((String)"Unexpected exception");
    }

    public void threadUnexpectedException(Throwable ex) {
        this.threadFailed = true;
        ex.printStackTrace();
        JSR166TestCase.fail((String)("Unexpected exception: " + ex));
    }

    public void joinPool(ExecutorService exec) {
        try {
            exec.shutdown();
            JSR166TestCase.assertTrue((boolean)exec.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        catch (SecurityException ok) {
        }
        catch (InterruptedException ie) {
            JSR166TestCase.fail((String)"Unexpected InterruptedException");
        }
    }

    public void shouldThrow() {
        JSR166TestCase.fail((String)"Should throw exception");
    }

    public void shouldThrow(String exceptionName) {
        JSR166TestCase.fail((String)("Should throw " + exceptionName));
    }

    public void unexpectedException() {
        JSR166TestCase.fail((String)"Unexpected exception");
    }

    public void unexpectedException(Throwable ex) {
        ex.printStackTrace();
        JSR166TestCase.fail((String)("Unexpected exception: " + ex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithPermissions(Runnable r, Permission ... permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            r.run();
            Policy savedPolicy = Policy.getPolicy();
            try {
                Policy.setPolicy(JSR166TestCase.permissivePolicy());
                System.setSecurityManager(new SecurityManager());
                this.runWithPermissions(r, permissions);
            }
            finally {
                System.setSecurityManager(null);
                Policy.setPolicy(savedPolicy);
            }
        }
        Policy savedPolicy = Policy.getPolicy();
        AdjustablePolicy policy = new AdjustablePolicy(permissions);
        Policy.setPolicy(policy);
        try {
            r.run();
        }
        finally {
            policy.addPermission(new SecurityPermission("setPolicy"));
            Policy.setPolicy(savedPolicy);
        }
    }

    public void runWithoutPermissions(Runnable r) {
        this.runWithPermissions(r, new Permission[0]);
    }

    public static Policy permissivePolicy() {
        return new AdjustablePolicy(new RuntimePermission("modifyThread"), new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"), new SecurityPermission("getPolicy"), new SecurityPermission("setPolicy"), new RuntimePermission("setSecurityManager"), new RuntimePermission("accessDeclaredMembers"), new PropertyPermission("*", "read"), new FilePermission("<<ALL FILES>>", "read"));
    }

    void sleepTillInterrupted(long timeoutMillis) {
        try {
            Thread.sleep(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Thread newStartedThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.start();
        return t;
    }

    public Callable<String> latchAwaitingStringTask(final CountDownLatch latch) {
        return new CheckedCallable<String>(){

            @Override
            public String realCall() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return JSR166TestCase.TEST_STRING;
            }
        };
    }

    static {
        zero = new Integer(0);
        one = new Integer(1);
        two = new Integer(2);
        three = new Integer(3);
        four = new Integer(4);
        five = new Integer(5);
        six = new Integer(6);
        seven = new Integer(7);
        eight = new Integer(8);
        nine = new Integer(9);
        m1 = new Integer(-1);
        m2 = new Integer(-2);
        m3 = new Integer(-3);
        m4 = new Integer(-4);
        m5 = new Integer(-5);
        m6 = new Integer(-6);
        m10 = new Integer(-10);
    }

    public static class NoOpREHandler
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        }
    }

    public static class TrackedCallable
    implements Callable {
        public volatile boolean done = false;

        public Object call() {
            try {
                Thread.sleep(SMALL_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Boolean.TRUE;
        }
    }

    public static class TrackedNoOpRunnable
    implements Runnable {
        public volatile boolean done = false;

        public void run() {
            this.done = true;
        }
    }

    public static class TrackedLongRunnable
    implements Runnable {
        public volatile boolean done = false;

        public void run() {
            try {
                Thread.sleep(LONG_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class TrackedMediumRunnable
    implements Runnable {
        public volatile boolean done = false;

        public void run() {
            try {
                Thread.sleep(MEDIUM_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class TrackedShortRunnable
    implements Runnable {
        public volatile boolean done = false;

        public void run() {
            try {
                Thread.sleep(SMALL_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class SimpleThreadFactory
    implements ThreadFactory {
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    }

    public class LongPossiblyInterruptedRunnable
    extends CheckedRunnable {
        protected void realRun() {
            try {
                Thread.sleep(LONG_DELAY_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class MediumPossiblyInterruptedRunnable
    extends CheckedRunnable {
        protected void realRun() {
            try {
                Thread.sleep(MEDIUM_DELAY_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class MediumInterruptedRunnable
    extends CheckedInterruptedRunnable {
        protected void realRun() throws InterruptedException {
            Thread.sleep(MEDIUM_DELAY_MS);
        }
    }

    public class MediumRunnable
    extends CheckedRunnable {
        protected void realRun() throws Throwable {
            Thread.sleep(MEDIUM_DELAY_MS);
        }
    }

    public class SmallInterruptedRunnable
    extends CheckedInterruptedRunnable {
        protected void realRun() throws InterruptedException {
            Thread.sleep(SMALL_DELAY_MS);
        }
    }

    public class SmallCallable
    extends CheckedCallable {
        protected Object realCall() throws InterruptedException {
            Thread.sleep(SMALL_DELAY_MS);
            return Boolean.TRUE;
        }
    }

    public class SmallPossiblyInterruptedRunnable
    extends CheckedRunnable {
        protected void realRun() {
            try {
                Thread.sleep(SMALL_DELAY_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class SmallRunnable
    extends CheckedRunnable {
        protected void realRun() throws Throwable {
            Thread.sleep(SMALL_DELAY_MS);
        }
    }

    public class ShortInterruptedRunnable
    extends CheckedInterruptedRunnable {
        protected void realRun() throws InterruptedException {
            Thread.sleep(SHORT_DELAY_MS);
        }
    }

    public class ShortRunnable
    extends CheckedRunnable {
        protected void realRun() throws Throwable {
            Thread.sleep(SHORT_DELAY_MS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallableOne
    implements Callable<Integer> {
        @Override
        public Integer call() {
            return one;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NPETask
    implements Callable<String> {
        @Override
        public String call() {
            throw new NullPointerException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringTask
    implements Callable<String> {
        @Override
        public String call() {
            return JSR166TestCase.TEST_STRING;
        }
    }

    public static class NoOpCallable
    implements Callable {
        public Object call() {
            return Boolean.TRUE;
        }
    }

    public static class NoOpRunnable
    implements Runnable {
        public void run() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CheckedInterruptedCallable<T>
    implements Callable<T> {
        protected abstract T realCall() throws Throwable;

        @Override
        public final T call() {
            try {
                T result = this.realCall();
                JSR166TestCase.this.threadShouldThrow("InterruptedException");
                return result;
            }
            catch (InterruptedException success) {
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CheckedCallable<T>
    implements Callable<T> {
        protected abstract T realCall() throws Throwable;

        @Override
        public final T call() {
            try {
                return this.realCall();
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
                return null;
            }
        }
    }

    public abstract class CheckedInterruptedRunnable
    implements Runnable {
        protected abstract void realRun() throws Throwable;

        public final void run() {
            try {
                this.realRun();
                JSR166TestCase.this.threadShouldThrow("InterruptedException");
            }
            catch (InterruptedException success) {
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ThreadShouldThrow
    extends Thread {
        final Class<?> exceptionClass;

        protected abstract void realRun() throws Throwable;

        <T extends Throwable> ThreadShouldThrow(Class<T> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        @Override
        public final void run() {
            block2: {
                try {
                    this.realRun();
                    JSR166TestCase.this.threadShouldThrow(this.exceptionClass.getSimpleName());
                }
                catch (Throwable t) {
                    if (this.exceptionClass.isInstance(t)) break block2;
                    JSR166TestCase.this.threadUnexpectedException(t);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class RunnableShouldThrow
    implements Runnable {
        final Class<?> exceptionClass;

        protected abstract void realRun() throws Throwable;

        <T extends Throwable> RunnableShouldThrow(Class<T> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        @Override
        public final void run() {
            block2: {
                try {
                    this.realRun();
                    JSR166TestCase.this.threadShouldThrow(this.exceptionClass.getSimpleName());
                }
                catch (Throwable t) {
                    if (this.exceptionClass.isInstance(t)) break block2;
                    JSR166TestCase.this.threadUnexpectedException(t);
                }
            }
        }
    }

    public abstract class CheckedRunnable
    implements Runnable {
        protected abstract void realRun() throws Throwable;

        public final void run() {
            try {
                this.realRun();
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
            }
        }
    }

    public static class AdjustablePolicy
    extends Policy {
        Permissions perms = new Permissions();

        AdjustablePolicy(Permission ... permissions) {
            for (Permission permission : permissions) {
                this.perms.add(permission);
            }
        }

        void addPermission(Permission perm) {
            this.perms.add(perm);
        }

        void clearPermissions() {
            this.perms = new Permissions();
        }

        public PermissionCollection getPermissions(CodeSource cs) {
            return this.perms;
        }

        public PermissionCollection getPermissions(ProtectionDomain pd) {
            return this.perms;
        }

        public boolean implies(ProtectionDomain pd, Permission p) {
            return this.perms.implies(p);
        }

        public void refresh() {
        }
    }
}

