/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class FutureTaskTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(FutureTaskTest.class);
    }

    public void testConstructor() {
        try {
            FutureTask task = new FutureTask(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            FutureTask<Boolean> task = new FutureTask<Boolean>(null, Boolean.TRUE);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIsDone() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        task.run();
        FutureTaskTest.assertTrue((boolean)task.isDone());
        FutureTaskTest.assertFalse((boolean)task.isCancelled());
    }

    public void testRunAndReset() {
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.runAndReset());
        FutureTaskTest.assertFalse((boolean)task.isDone());
    }

    public void testResetAfterCancel() {
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.cancel(false));
        FutureTaskTest.assertFalse((boolean)task.runAndReset());
        FutureTaskTest.assertTrue((boolean)task.isDone());
        FutureTaskTest.assertTrue((boolean)task.isCancelled());
    }

    public void testSet() throws Exception {
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        task.set(one);
        FutureTaskTest.assertSame(task.get(), (Object)one);
    }

    public void testSetException() throws Exception {
        NoSuchElementException nse = new NoSuchElementException();
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        task.setException(nse);
        try {
            Object x = task.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertSame((Object)success.getCause(), (Object)nse);
        }
    }

    public void testCancelBeforeRun() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.cancel(false));
        task.run();
        FutureTaskTest.assertTrue((boolean)task.isDone());
        FutureTaskTest.assertTrue((boolean)task.isCancelled());
    }

    public void testCancelBeforeRun2() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.cancel(true));
        task.run();
        FutureTaskTest.assertTrue((boolean)task.isDone());
        FutureTaskTest.assertTrue((boolean)task.isCancelled());
    }

    public void testCancelAfterRun() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        task.run();
        FutureTaskTest.assertFalse((boolean)task.cancel(false));
        FutureTaskTest.assertTrue((boolean)task.isDone());
        FutureTaskTest.assertFalse((boolean)task.isCancelled());
    }

    public void testCancelInterrupt() throws InterruptedException {
        FutureTask<Object> task = new FutureTask<Object>(new JSR166TestCase.CheckedInterruptedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                return Boolean.TRUE;
            }
        });
        Thread t = new Thread(task);
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        FutureTaskTest.assertTrue((boolean)task.cancel(true));
        t.join();
        FutureTaskTest.assertTrue((boolean)task.isDone());
        FutureTaskTest.assertTrue((boolean)task.isCancelled());
    }

    public void testCancelNoInterrupt() throws InterruptedException {
        FutureTask<Object> task = new FutureTask<Object>(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                Thread.sleep(JSR166TestCase.MEDIUM_DELAY_MS);
                return Boolean.TRUE;
            }
        });
        Thread t = new Thread(task);
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        FutureTaskTest.assertTrue((boolean)task.cancel(false));
        t.join();
        FutureTaskTest.assertTrue((boolean)task.isDone());
        FutureTaskTest.assertTrue((boolean)task.isCancelled());
    }

    public void testGet1() throws InterruptedException {
        final FutureTask<Object> ft = new FutureTask<Object>(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                return Boolean.TRUE;
            }
        });
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws Exception {
                Assert.assertSame((Object)Boolean.TRUE, ft.get());
            }
        });
        FutureTaskTest.assertFalse((boolean)ft.isDone());
        FutureTaskTest.assertFalse((boolean)ft.isCancelled());
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        ft.run();
        t.join();
        FutureTaskTest.assertTrue((boolean)ft.isDone());
        FutureTaskTest.assertFalse((boolean)ft.isCancelled());
    }

    public void testTimedGet1() throws InterruptedException {
        final FutureTask<Object> ft = new FutureTask<Object>(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                return Boolean.TRUE;
            }
        });
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws Exception {
                Assert.assertSame((Object)Boolean.TRUE, ft.get(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        FutureTaskTest.assertFalse((boolean)ft.isDone());
        FutureTaskTest.assertFalse((boolean)ft.isCancelled());
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        ft.run();
        t.join();
        FutureTaskTest.assertTrue((boolean)ft.isDone());
        FutureTaskTest.assertFalse((boolean)ft.isCancelled());
    }

    public void testTimedGet_Cancellation() throws InterruptedException {
        final FutureTask<Object> ft = new FutureTask<Object>(new JSR166TestCase.CheckedInterruptedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                return Boolean.TRUE;
            }
        });
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(CancellationException.class){

            public void realRun() throws Exception {
                ft.get(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        Thread t2 = new Thread(ft);
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ft.cancel(true);
        t1.join();
        t2.join();
    }

    public void testGet_Cancellation() throws InterruptedException {
        final FutureTask<Object> ft = new FutureTask<Object>(new JSR166TestCase.CheckedInterruptedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                return Boolean.TRUE;
            }
        });
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(CancellationException.class){

            public void realRun() throws Exception {
                ft.get();
            }
        };
        Thread t2 = new Thread(ft);
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        ft.cancel(true);
        t1.join();
        t2.join();
    }

    public void testGet_ExecutionException() throws InterruptedException {
        FutureTask ft = new FutureTask(new Callable(){

            public Object call() {
                return 5 / 0;
            }
        });
        ft.run();
        try {
            ft.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertTrue((boolean)(success.getCause() instanceof ArithmeticException));
        }
    }

    public void testTimedGet_ExecutionException2() throws Exception {
        FutureTask ft = new FutureTask(new Callable(){

            public Object call() {
                return 5 / 0;
            }
        });
        ft.run();
        try {
            ft.get(SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertTrue((boolean)(success.getCause() instanceof ArithmeticException));
        }
    }

    public void testGet_InterruptedException() throws InterruptedException {
        final FutureTask ft = new FutureTask(new JSR166TestCase.NoOpCallable());
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws Exception {
                ft.get();
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedGet_InterruptedException2() throws InterruptedException {
        final FutureTask ft = new FutureTask(new JSR166TestCase.NoOpCallable());
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws Exception {
                ft.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testGet_TimeoutException() throws Exception {
        try {
            FutureTask ft = new FutureTask(new JSR166TestCase.NoOpCallable());
            ft.get(1L, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    static class PublicFutureTask
    extends FutureTask {
        public PublicFutureTask(Callable r) {
            super(r);
        }

        public boolean runAndReset() {
            return super.runAndReset();
        }

        public void set(Object x) {
            super.set(x);
        }

        public void setException(Throwable t) {
            super.setException(t);
        }
    }
}

