/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ExchangerTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ExchangerTest.class);
    }

    public void testExchange() throws InterruptedException {
        final Exchanger e = new Exchanger();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertSame((Object)JSR166TestCase.one, (Object)e.exchange(JSR166TestCase.two));
                Assert.assertSame((Object)JSR166TestCase.two, (Object)e.exchange(JSR166TestCase.one));
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertSame((Object)JSR166TestCase.two, (Object)e.exchange(JSR166TestCase.one));
                Assert.assertSame((Object)JSR166TestCase.one, (Object)e.exchange(JSR166TestCase.two));
            }
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    public void testTimedExchange() throws InterruptedException {
        final Exchanger e = new Exchanger();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws Exception {
                Assert.assertSame((Object)JSR166TestCase.one, (Object)e.exchange(JSR166TestCase.two, JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertSame((Object)JSR166TestCase.two, (Object)e.exchange(JSR166TestCase.one, JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws Exception {
                Assert.assertSame((Object)JSR166TestCase.two, (Object)e.exchange(JSR166TestCase.one, JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertSame((Object)JSR166TestCase.one, (Object)e.exchange(JSR166TestCase.two, JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    public void testExchange_InterruptedException() throws InterruptedException {
        final Exchanger e = new Exchanger();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                e.exchange(JSR166TestCase.one);
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedExchange_InterruptedException() throws InterruptedException {
        final Exchanger e = new Exchanger();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws Exception {
                e.exchange(null, JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testExchange_TimeOutException() throws InterruptedException {
        final Exchanger e = new Exchanger();
        JSR166TestCase.ThreadShouldThrow t = new JSR166TestCase.ThreadShouldThrow(TimeoutException.class){

            public void realRun() throws Exception {
                e.exchange(null, JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        t.start();
        t.join();
    }

    public void testReplacementAfterExchange() throws InterruptedException {
        final Exchanger e = new Exchanger();
        Thread t1 = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertSame((Object)JSR166TestCase.two, (Object)e.exchange(JSR166TestCase.one));
                e.exchange(JSR166TestCase.two);
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertSame((Object)JSR166TestCase.one, (Object)e.exchange(JSR166TestCase.two));
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                Assert.assertSame((Object)JSR166TestCase.three, (Object)e.exchange(JSR166TestCase.one));
            }
        });
        Thread t3 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                Assert.assertSame((Object)JSR166TestCase.one, (Object)e.exchange(JSR166TestCase.three));
            }
        });
        t1.start();
        t2.start();
        t3.start();
        Thread.sleep(SHORT_DELAY_MS);
        t1.interrupt();
        t1.join();
        t2.join();
        t3.join();
    }
}

