/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class DelayQueueTest
extends JSR166TestCase {
    private static final int NOCAP = Integer.MAX_VALUE;

    public static Test suite() {
        return new TestSuite(DelayQueueTest.class);
    }

    private DelayQueue populatedQueue(int n) {
        int i;
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        DelayQueueTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            DelayQueueTest.assertTrue((boolean)q.offer(new PDelay(i)));
        }
        for (i = n & 1; i < n; i += 2) {
            DelayQueueTest.assertTrue((boolean)q.offer(new PDelay(i)));
        }
        DelayQueueTest.assertFalse((boolean)q.isEmpty());
        DelayQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        DelayQueueTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        DelayQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)new DelayQueue().remainingCapacity());
    }

    public void testConstructor3() {
        try {
            DelayQueue q = new DelayQueue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            PDelay[] ints = new PDelay[20];
            DelayQueue<PDelay> q = new DelayQueue<PDelay>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            PDelay[] ints = new PDelay[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new PDelay(i);
            }
            DelayQueue<PDelay> q = new DelayQueue<PDelay>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        PDelay[] ints = new PDelay[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new PDelay(i);
        }
        DelayQueue<PDelay> q = new DelayQueue<PDelay>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmpty() {
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        DelayQueueTest.assertTrue((boolean)q.isEmpty());
        DelayQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        q.add(new PDelay(1));
        DelayQueueTest.assertFalse((boolean)q.isEmpty());
        q.add(new PDelay(2));
        q.remove();
        q.remove();
        DelayQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemainingCapacity() {
        int i;
        DelayQueue q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
            DelayQueueTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
            DelayQueueTest.assertEquals((int)i, (int)q.size());
            q.add(new PDelay(i));
        }
    }

    public void testOfferNull() {
        try {
            DelayQueue<Object> q = new DelayQueue<Object>();
            q.offer((Object)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            DelayQueue<Object> q = new DelayQueue<Object>();
            q.add((Object)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        DelayQueueTest.assertTrue((boolean)q.offer(new PDelay(0)));
        DelayQueueTest.assertTrue((boolean)q.offer(new PDelay(1)));
    }

    public void testAdd() {
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((int)i, (int)q.size());
            DelayQueueTest.assertTrue((boolean)q.add(new PDelay(i)));
        }
    }

    public void testAddAll1() {
        try {
            DelayQueue q = new DelayQueue();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            DelayQueue q = this.populatedQueue(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            DelayQueue<PDelay> q = new DelayQueue<PDelay>();
            PDelay[] ints = new PDelay[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            DelayQueue<PDelay> q = new DelayQueue<PDelay>();
            PDelay[] ints = new PDelay[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new PDelay(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        PDelay[] empty = new PDelay[]{};
        PDelay[] ints = new PDelay[20];
        for (int i = 19; i >= 0; --i) {
            ints[i] = new PDelay(i);
        }
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        DelayQueueTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        DelayQueueTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testPutNull() {
        try {
            DelayQueue<Object> q = new DelayQueue<Object>();
            q.put((Object)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut() {
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        for (int i = 0; i < 20; ++i) {
            PDelay I2 = new PDelay(i);
            q.put(I2);
            DelayQueueTest.assertTrue((boolean)q.contains(I2));
        }
        DelayQueueTest.assertEquals((int)20, (int)q.size());
    }

    public void testPutWithTake() throws InterruptedException {
        final DelayQueue q = new DelayQueue();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                q.put(new PDelay(0));
                q.put(new PDelay(0));
                q.put(new PDelay(0));
                q.put(new PDelay(0));
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        q.take();
        t.interrupt();
        t.join();
    }

    public void testTimedOffer() throws InterruptedException {
        final DelayQueue q = new DelayQueue();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                q.put(new PDelay(0));
                q.put(new PDelay(0));
                Assert.assertTrue((boolean)q.offer(new PDelay(0), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)q.offer(new PDelay(0), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        Thread.sleep(SMALL_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTake() throws InterruptedException {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.take()));
        }
    }

    public void testTakeFromEmpty() throws InterruptedException {
        final DelayQueue q = new DelayQueue();
        JSR166TestCase.ThreadShouldThrow t = new JSR166TestCase.ThreadShouldThrow(InterruptedException.class){

            public void realRun() throws InterruptedException {
                q.take();
            }
        };
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testBlockingTake() throws InterruptedException {
        final DelayQueue q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.take()));
                }
                try {
                    q.take();
                    DelayQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPoll() {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.poll()));
        }
        DelayQueueTest.assertNull((Object)q.poll());
    }

    public void testTimedPoll0() throws InterruptedException {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.poll(0L, TimeUnit.MILLISECONDS)));
        }
        DelayQueueTest.assertNull((Object)q.poll(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPoll() throws InterruptedException {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS)));
        }
        DelayQueueTest.assertNull((Object)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testInterruptedTimedPoll() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                DelayQueue q = DelayQueueTest.this.populatedQueue(20);
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS)));
                }
                try {
                    q.poll(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
                    DelayQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedPollWithOffer() throws InterruptedException {
        final DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        final PDelay pdelay = new PDelay(0);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertNull((Object)q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertSame((Object)pdelay, (Object)q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    DelayQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SMALL_DELAY_MS);
        DelayQueueTest.assertTrue((boolean)q.offer(pdelay, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        t.interrupt();
        t.join();
    }

    public void testPeek() {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.peek()));
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.poll()));
            if (q.isEmpty()) {
                DelayQueueTest.assertNull((Object)q.peek());
                continue;
            }
            DelayQueueTest.assertFalse((boolean)new PDelay(i).equals(q.peek()));
        }
        DelayQueueTest.assertNull((Object)q.peek());
    }

    public void testElement() {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.element()));
            q.poll();
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals((Object)new PDelay(i), (Object)((PDelay)q.remove()));
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        DelayQueue q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            DelayQueueTest.assertTrue((boolean)q.remove(new PDelay(i)));
        }
        for (i = 0; i < 20; i += 2) {
            DelayQueueTest.assertTrue((boolean)q.remove(new PDelay(i)));
            DelayQueueTest.assertFalse((boolean)q.remove(new PDelay(i + 1)));
        }
        DelayQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        DelayQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertTrue((boolean)q.contains(new PDelay(i)));
            q.poll();
            DelayQueueTest.assertFalse((boolean)q.contains(new PDelay(i)));
        }
    }

    public void testClear() {
        DelayQueue q = this.populatedQueue(20);
        q.clear();
        DelayQueueTest.assertTrue((boolean)q.isEmpty());
        DelayQueueTest.assertEquals((int)0, (int)q.size());
        DelayQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        PDelay x = new PDelay(1);
        q.add(x);
        DelayQueueTest.assertFalse((boolean)q.isEmpty());
        DelayQueueTest.assertTrue((boolean)q.contains(x));
        q.clear();
        DelayQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        DelayQueue q = this.populatedQueue(20);
        DelayQueue<PDelay> p = new DelayQueue<PDelay>();
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertTrue((boolean)q.containsAll(p));
            DelayQueueTest.assertFalse((boolean)p.containsAll(q));
            p.add(new PDelay(i));
        }
        DelayQueueTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        DelayQueue q = this.populatedQueue(20);
        DelayQueue p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                DelayQueueTest.assertFalse((boolean)changed);
            } else {
                DelayQueueTest.assertTrue((boolean)changed);
            }
            DelayQueueTest.assertTrue((boolean)q.containsAll(p));
            DelayQueueTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            DelayQueue q = this.populatedQueue(20);
            DelayQueue p = this.populatedQueue(i);
            DelayQueueTest.assertTrue((boolean)q.removeAll(p));
            DelayQueueTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                PDelay I2 = (PDelay)p.remove();
                DelayQueueTest.assertFalse((boolean)q.contains(I2));
            }
        }
    }

    public void testToArray() throws InterruptedException {
        DelayQueue q = this.populatedQueue(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            DelayQueueTest.assertEquals((Object)o[i], (Object)q.take());
        }
    }

    public void testToArray2() throws InterruptedException {
        DelayQueue q = this.populatedQueue(20);
        Object[] ints = new PDelay[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            DelayQueueTest.assertEquals((Object)ints[i], (Object)q.take());
        }
    }

    public void testToArray_BadArg() {
        DelayQueue q = this.populatedQueue(20);
        try {
            T[] o = q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        DelayQueue q = this.populatedQueue(20);
        try {
            String[] o = q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        DelayQueue q = this.populatedQueue(20);
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            DelayQueueTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        DelayQueueTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorRemove() {
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        q.add(new PDelay(2));
        q.add(new PDelay(1));
        q.add(new PDelay(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        DelayQueueTest.assertEquals(it.next(), (Object)new PDelay(2));
        DelayQueueTest.assertEquals(it.next(), (Object)new PDelay(3));
        DelayQueueTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        DelayQueue q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            DelayQueueTest.assertTrue((s.indexOf(String.valueOf(Integer.MIN_VALUE + i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testPollInExecutor() {
        final DelayQueue q = new DelayQueue();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertNull((Object)q.poll());
                Assert.assertTrue((null != q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)q.isEmpty());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SHORT_DELAY_MS);
                q.put(new PDelay(1));
            }
        });
        this.joinPool(executor);
    }

    public void testDelay() throws InterruptedException {
        int i;
        DelayQueue<NanoDelay> q = new DelayQueue<NanoDelay>();
        NanoDelay[] elements = new NanoDelay[20];
        for (i = 0; i < 20; ++i) {
            elements[i] = new NanoDelay(1000000000L + 1000000L * (long)(20 - i));
        }
        for (i = 0; i < 20; ++i) {
            q.add(elements[i]);
        }
        long last = 0L;
        for (int i2 = 0; i2 < 20; ++i2) {
            NanoDelay e = (NanoDelay)q.take();
            long tt = e.getTriggerTime();
            DelayQueueTest.assertTrue((tt <= System.nanoTime() ? 1 : 0) != 0);
            if (i2 != 0) {
                DelayQueueTest.assertTrue((tt >= last ? 1 : 0) != 0);
            }
            last = tt;
        }
    }

    public void testPeekDelayed() {
        DelayQueue<NanoDelay> q = new DelayQueue<NanoDelay>();
        q.add(new NanoDelay(Long.MAX_VALUE));
        assert (q.peek() != null);
    }

    public void testPollDelayed() {
        DelayQueue<NanoDelay> q = new DelayQueue<NanoDelay>();
        q.add(new NanoDelay(Long.MAX_VALUE));
        DelayQueueTest.assertNull((Object)q.poll());
    }

    public void testTimedPollDelayed() throws InterruptedException {
        DelayQueue<NanoDelay> q = new DelayQueue<NanoDelay>();
        q.add(new NanoDelay(LONG_DELAY_MS * 1000000L));
        DelayQueueTest.assertNull((Object)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testDrainToNull() {
        DelayQueue q = this.populatedQueue(20);
        try {
            q.drainTo(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelf() {
        DelayQueue q = this.populatedQueue(20);
        try {
            q.drainTo(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainTo() {
        int i;
        DelayQueue<PDelay> q = new DelayQueue<PDelay>();
        PDelay[] elems = new PDelay[20];
        for (int i2 = 0; i2 < 20; ++i2) {
            elems[i2] = new PDelay(i2);
            q.add(elems[i2]);
        }
        ArrayList l = new ArrayList();
        q.drainTo(l);
        DelayQueueTest.assertEquals((int)q.size(), (int)0);
        for (i = 0; i < 20; ++i) {
            DelayQueueTest.assertEquals(l.get(i), (Object)elems[i]);
        }
        q.add(elems[0]);
        q.add(elems[1]);
        DelayQueueTest.assertFalse((boolean)q.isEmpty());
        DelayQueueTest.assertTrue((boolean)q.contains(elems[0]));
        DelayQueueTest.assertTrue((boolean)q.contains(elems[1]));
        l.clear();
        q.drainTo(l);
        DelayQueueTest.assertEquals((int)q.size(), (int)0);
        DelayQueueTest.assertEquals((int)l.size(), (int)2);
        for (i = 0; i < 2; ++i) {
            DelayQueueTest.assertEquals(l.get(i), (Object)elems[i]);
        }
    }

    public void testDrainToWithActivePut() throws InterruptedException {
        final DelayQueue q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                q.put(new PDelay(21));
            }
        });
        t.start();
        ArrayList l = new ArrayList();
        q.drainTo(l);
        DelayQueueTest.assertTrue((l.size() >= 20 ? 1 : 0) != 0);
        t.join();
        DelayQueueTest.assertTrue((q.size() + l.size() >= 20 ? 1 : 0) != 0);
    }

    public void testDrainToNullN() {
        DelayQueue q = this.populatedQueue(20);
        try {
            q.drainTo(null, 0);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelfN() {
        DelayQueue q = this.populatedQueue(20);
        try {
            q.drainTo(q, 0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainToN() {
        for (int i = 0; i < 22; ++i) {
            DelayQueue q = this.populatedQueue(20);
            ArrayList l = new ArrayList();
            q.drainTo(l, i);
            int k = i < 20 ? i : 20;
            DelayQueueTest.assertEquals((int)q.size(), (int)(20 - k));
            DelayQueueTest.assertEquals((int)l.size(), (int)k);
        }
    }

    static class NanoDelay
    implements Delayed {
        long trigger;

        NanoDelay(long i) {
            this.trigger = System.nanoTime() + i;
        }

        public int compareTo(NanoDelay y) {
            long i = this.trigger;
            long j = y.trigger;
            if (i < j) {
                return -1;
            }
            if (i > j) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Delayed y) {
            return this.compareTo((NanoDelay)y);
        }

        public boolean equals(Object other) {
            return this.equals((NanoDelay)other);
        }

        public boolean equals(NanoDelay other) {
            return other.trigger == this.trigger;
        }

        public long getDelay(TimeUnit unit) {
            long n = this.trigger - System.nanoTime();
            return unit.convert(n, TimeUnit.NANOSECONDS);
        }

        public long getTriggerTime() {
            return this.trigger;
        }

        public String toString() {
            return String.valueOf(this.trigger);
        }
    }

    static class PDelay
    implements Delayed {
        int pseudodelay;

        PDelay(int i) {
            this.pseudodelay = Integer.MIN_VALUE + i;
        }

        public int compareTo(PDelay y) {
            int i = this.pseudodelay;
            int j = y.pseudodelay;
            if (i < j) {
                return -1;
            }
            if (i > j) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Delayed y) {
            return this.compareTo((PDelay)y);
        }

        public boolean equals(Object other) {
            return this.equals((PDelay)other);
        }

        public boolean equals(PDelay other) {
            return other.pseudodelay == this.pseudodelay;
        }

        public long getDelay(TimeUnit ignore) {
            return this.pseudodelay;
        }

        public int intValue() {
            return this.pseudodelay;
        }

        public String toString() {
            return String.valueOf(this.pseudodelay);
        }
    }
}

