/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class CyclicBarrierTest
extends JSR166TestCase {
    private volatile int countAction;

    public static Test suite() {
        return new TestSuite(CyclicBarrierTest.class);
    }

    public void testConstructor1() {
        try {
            new CyclicBarrier(-1, null);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            new CyclicBarrier(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetParties() {
        CyclicBarrier b = new CyclicBarrier(2);
        CyclicBarrierTest.assertEquals((int)2, (int)b.getParties());
        CyclicBarrierTest.assertEquals((int)0, (int)b.getNumberWaiting());
    }

    public void testSingleParty() throws Exception {
        CyclicBarrier b = new CyclicBarrier(1);
        CyclicBarrierTest.assertEquals((int)1, (int)b.getParties());
        CyclicBarrierTest.assertEquals((int)0, (int)b.getNumberWaiting());
        b.await();
        b.await();
        CyclicBarrierTest.assertEquals((int)0, (int)b.getNumberWaiting());
    }

    public void testBarrierAction() throws Exception {
        this.countAction = 0;
        CyclicBarrier b = new CyclicBarrier(1, new MyAction());
        CyclicBarrierTest.assertEquals((int)1, (int)b.getParties());
        CyclicBarrierTest.assertEquals((int)0, (int)b.getNumberWaiting());
        b.await();
        b.await();
        CyclicBarrierTest.assertEquals((int)0, (int)b.getNumberWaiting());
        CyclicBarrierTest.assertEquals((int)this.countAction, (int)2);
    }

    public void testTwoParties() throws Exception {
        final CyclicBarrier b = new CyclicBarrier(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws Exception {
                b.await();
                b.await();
                b.await();
                b.await();
            }
        });
        t.start();
        b.await();
        b.await();
        b.await();
        b.await();
        t.join();
    }

    public void testAwait1_Interrupted_BrokenBarrier() throws Exception {
        final CyclicBarrier c = new CyclicBarrier(3);
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(InterruptedException.class){

            public void realRun() throws Exception {
                c.await();
            }
        };
        JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

            public void realRun() throws Exception {
                c.await();
            }
        };
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        t1.interrupt();
        t1.join();
        t2.join();
    }

    public void testAwait2_Interrupted_BrokenBarrier() throws Exception {
        final CyclicBarrier c = new CyclicBarrier(3);
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(InterruptedException.class){

            public void realRun() throws Exception {
                c.await(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

            public void realRun() throws Exception {
                c.await(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        t1.interrupt();
        t1.join();
        t2.join();
    }

    public void testAwait3_TimeOutException() throws InterruptedException {
        final CyclicBarrier c = new CyclicBarrier(2);
        JSR166TestCase.ThreadShouldThrow t = new JSR166TestCase.ThreadShouldThrow(TimeoutException.class){

            public void realRun() throws Exception {
                c.await(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        t.start();
        t.join();
    }

    public void testAwait4_Timeout_BrokenBarrier() throws InterruptedException {
        final CyclicBarrier c = new CyclicBarrier(3);
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(TimeoutException.class){

            public void realRun() throws Exception {
                c.await(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

            public void realRun() throws Exception {
                c.await(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    public void testAwait5_Timeout_BrokenBarrier() throws InterruptedException {
        final CyclicBarrier c = new CyclicBarrier(3);
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(TimeoutException.class){

            public void realRun() throws Exception {
                c.await(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

            public void realRun() throws Exception {
                c.await();
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    public void testReset_BrokenBarrier() throws InterruptedException {
        final CyclicBarrier c = new CyclicBarrier(3);
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

            public void realRun() throws Exception {
                c.await();
            }
        };
        JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

            public void realRun() throws Exception {
                c.await();
            }
        };
        t1.start();
        t2.start();
        Thread.sleep(SHORT_DELAY_MS);
        c.reset();
        t1.join();
        t2.join();
    }

    public void testReset_NoBrokenBarrier() throws Exception {
        final CyclicBarrier c = new CyclicBarrier(3);
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws Exception {
                c.await();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws Exception {
                c.await();
            }
        });
        c.reset();
        t1.start();
        t2.start();
        c.await();
        t1.join();
        t2.join();
    }

    public void testReset_Leakage() throws InterruptedException {
        final CyclicBarrier c = new CyclicBarrier(2);
        final AtomicBoolean done = new AtomicBoolean();
        Thread t = new Thread(){

            public void run() {
                while (!done.get()) {
                    try {
                        while (c.isBroken()) {
                            c.reset();
                        }
                        c.await();
                        CyclicBarrierTest.this.threadFail("await should not return");
                    }
                    catch (BrokenBarrierException e) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        t.start();
        for (int i = 0; i < 4; ++i) {
            Thread.sleep(SHORT_DELAY_MS);
            t.interrupt();
        }
        done.set(true);
        t.interrupt();
        t.join();
    }

    public void testResetWithoutBreakage() throws Exception {
        final CyclicBarrier start = new CyclicBarrier(3);
        final CyclicBarrier barrier = new CyclicBarrier(3);
        for (int i = 0; i < 3; ++i) {
            Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await();
                }
            });
            Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await();
                }
            });
            t1.start();
            t2.start();
            start.await();
            barrier.await();
            t1.join();
            t2.join();
            CyclicBarrierTest.assertFalse((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
            if (i == 1) {
                barrier.reset();
            }
            CyclicBarrierTest.assertFalse((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
        }
    }

    public void testResetAfterInterrupt() throws Exception {
        final CyclicBarrier start = new CyclicBarrier(3);
        final CyclicBarrier barrier = new CyclicBarrier(3);
        for (int i = 0; i < 2; ++i) {
            JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(InterruptedException.class){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await();
                }
            };
            JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await();
                }
            };
            t1.start();
            t2.start();
            start.await();
            t1.interrupt();
            t1.join();
            t2.join();
            CyclicBarrierTest.assertTrue((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
            barrier.reset();
            CyclicBarrierTest.assertFalse((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
        }
    }

    public void testResetAfterTimeout() throws Exception {
        final CyclicBarrier start = new CyclicBarrier(3);
        final CyclicBarrier barrier = new CyclicBarrier(3);
        for (int i = 0; i < 2; ++i) {
            JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(TimeoutException.class){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
                }
            };
            JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await();
                }
            };
            t1.start();
            t2.start();
            start.await();
            t1.join();
            t2.join();
            CyclicBarrierTest.assertTrue((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
            barrier.reset();
            CyclicBarrierTest.assertFalse((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
        }
    }

    public void testResetAfterCommandException() throws Exception {
        final CyclicBarrier start = new CyclicBarrier(3);
        final CyclicBarrier barrier = new CyclicBarrier(3, new Runnable(){

            public void run() {
                throw new NullPointerException();
            }
        });
        for (int i = 0; i < 2; ++i) {
            JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await();
                }
            };
            JSR166TestCase.ThreadShouldThrow t2 = new JSR166TestCase.ThreadShouldThrow(BrokenBarrierException.class){

                public void realRun() throws Exception {
                    start.await();
                    barrier.await();
                }
            };
            t1.start();
            t2.start();
            start.await();
            while (barrier.getNumberWaiting() < 2) {
                Thread.yield();
            }
            try {
                barrier.await();
                this.shouldThrow();
            }
            catch (NullPointerException success) {
                // empty catch block
            }
            t1.join();
            t2.join();
            CyclicBarrierTest.assertTrue((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
            barrier.reset();
            CyclicBarrierTest.assertFalse((boolean)barrier.isBroken());
            CyclicBarrierTest.assertEquals((int)0, (int)barrier.getNumberWaiting());
        }
    }

    private class MyAction
    implements Runnable {
        private MyAction() {
        }

        public void run() {
            ++CyclicBarrierTest.this.countAction;
        }
    }
}

