/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class CopyOnWriteArraySetTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(CopyOnWriteArraySetTest.class);
    }

    static CopyOnWriteArraySet populatedSet(int n) {
        CopyOnWriteArraySet<Integer> a = new CopyOnWriteArraySet<Integer>();
        CopyOnWriteArraySetTest.assertTrue((boolean)a.isEmpty());
        for (int i = 0; i < n; ++i) {
            a.add(new Integer(i));
        }
        CopyOnWriteArraySetTest.assertFalse((boolean)a.isEmpty());
        CopyOnWriteArraySetTest.assertEquals((int)n, (int)a.size());
        return a;
    }

    public void testConstructor() {
        CopyOnWriteArraySet a = new CopyOnWriteArraySet();
        CopyOnWriteArraySetTest.assertTrue((boolean)a.isEmpty());
    }

    public void testConstructor3() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 19; ++i) {
            ints[i] = new Integer(i);
        }
        CopyOnWriteArraySet<Integer> a = new CopyOnWriteArraySet<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            CopyOnWriteArraySetTest.assertTrue((boolean)a.contains(ints[i]));
        }
    }

    public void testAddAll() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(three);
        v.add(four);
        v.add(five);
        full.addAll(v);
        CopyOnWriteArraySetTest.assertEquals((int)6, (int)full.size());
    }

    public void testAddAll2() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(three);
        v.add(four);
        v.add(one);
        full.addAll(v);
        CopyOnWriteArraySetTest.assertEquals((int)5, (int)full.size());
    }

    public void testAdd2() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        full.add(one);
        CopyOnWriteArraySetTest.assertEquals((int)3, (int)full.size());
    }

    public void testAdd3() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        full.add(three);
        CopyOnWriteArraySetTest.assertTrue((boolean)full.contains(three));
    }

    public void testClear() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        full.clear();
        CopyOnWriteArraySetTest.assertEquals((int)0, (int)full.size());
    }

    public void testContains() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        CopyOnWriteArraySetTest.assertTrue((boolean)full.contains(one));
        CopyOnWriteArraySetTest.assertFalse((boolean)full.contains(five));
    }

    public void testEquals() {
        CopyOnWriteArraySet a = CopyOnWriteArraySetTest.populatedSet(3);
        CopyOnWriteArraySet b = CopyOnWriteArraySetTest.populatedSet(3);
        CopyOnWriteArraySetTest.assertTrue((boolean)a.equals(b));
        CopyOnWriteArraySetTest.assertTrue((boolean)b.equals(a));
        CopyOnWriteArraySetTest.assertEquals((int)a.hashCode(), (int)b.hashCode());
        a.add(m1);
        CopyOnWriteArraySetTest.assertFalse((boolean)a.equals(b));
        CopyOnWriteArraySetTest.assertFalse((boolean)b.equals(a));
        b.add(m1);
        CopyOnWriteArraySetTest.assertTrue((boolean)a.equals(b));
        CopyOnWriteArraySetTest.assertTrue((boolean)b.equals(a));
        CopyOnWriteArraySetTest.assertEquals((int)a.hashCode(), (int)b.hashCode());
    }

    public void testContainsAll() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(one);
        v.add(two);
        CopyOnWriteArraySetTest.assertTrue((boolean)full.containsAll(v));
        v.add(six);
        CopyOnWriteArraySetTest.assertFalse((boolean)full.containsAll(v));
    }

    public void testIsEmpty() {
        CopyOnWriteArraySet empty = new CopyOnWriteArraySet();
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        CopyOnWriteArraySetTest.assertTrue((boolean)empty.isEmpty());
        CopyOnWriteArraySetTest.assertFalse((boolean)full.isEmpty());
    }

    public void testIterator() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Iterator i = full.iterator();
        int j = 0;
        while (i.hasNext()) {
            CopyOnWriteArraySetTest.assertEquals((Object)j, i.next());
            ++j;
        }
        CopyOnWriteArraySetTest.assertEquals((int)3, (int)j);
    }

    public void testIteratorRemove() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Iterator it = full.iterator();
        it.next();
        try {
            it.remove();
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToString() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        String s = full.toString();
        for (int i = 0; i < 3; ++i) {
            CopyOnWriteArraySetTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testRemoveAll() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(one);
        v.add(two);
        full.removeAll(v);
        CopyOnWriteArraySetTest.assertEquals((int)1, (int)full.size());
    }

    public void testRemove() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        full.remove(one);
        CopyOnWriteArraySetTest.assertFalse((boolean)full.contains(one));
        CopyOnWriteArraySetTest.assertEquals((int)2, (int)full.size());
    }

    public void testSize() {
        CopyOnWriteArraySet empty = new CopyOnWriteArraySet();
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        CopyOnWriteArraySetTest.assertEquals((int)3, (int)full.size());
        CopyOnWriteArraySetTest.assertEquals((int)0, (int)empty.size());
    }

    public void testToArray() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Object[] o = full.toArray();
        CopyOnWriteArraySetTest.assertEquals((int)3, (int)o.length);
        CopyOnWriteArraySetTest.assertEquals((Object)0, (Object)o[0]);
        CopyOnWriteArraySetTest.assertEquals((Object)1, (Object)o[1]);
        CopyOnWriteArraySetTest.assertEquals((Object)2, (Object)o[2]);
    }

    public void testToArray2() {
        CopyOnWriteArraySet full = CopyOnWriteArraySetTest.populatedSet(3);
        Integer[] i = new Integer[3];
        i = full.toArray(i);
        CopyOnWriteArraySetTest.assertEquals((int)3, (int)i.length);
        CopyOnWriteArraySetTest.assertEquals((int)0, (int)i[0]);
        CopyOnWriteArraySetTest.assertEquals((int)1, (int)i[1]);
        CopyOnWriteArraySetTest.assertEquals((int)2, (int)i[2]);
    }

    public void testToArray_ArrayStoreException() {
        try {
            CopyOnWriteArraySet<String> c = new CopyOnWriteArraySet<String>();
            c.add("zfasdfsdf");
            c.add("asdadasd");
            c.toArray(new Long[5]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testSerialization() throws Exception {
        CopyOnWriteArraySet q = CopyOnWriteArraySetTest.populatedSet(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        CopyOnWriteArraySet r = (CopyOnWriteArraySet)in.readObject();
        CopyOnWriteArraySetTest.assertEquals((int)q.size(), (int)r.size());
        CopyOnWriteArraySetTest.assertTrue((boolean)q.equals(r));
        CopyOnWriteArraySetTest.assertTrue((boolean)r.equals(q));
    }
}

