/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSkipListSetTest
extends JSR166TestCase {
    Random rnd = new Random(666L);
    BitSet bs;

    public static Test suite() {
        return new TestSuite(ConcurrentSkipListSetTest.class);
    }

    private ConcurrentSkipListSet populatedSet(int n) {
        int i;
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.add(new Integer(i)));
        }
        for (i = n & 1; i < n; i += 2) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.add(new Integer(i)));
        }
        ConcurrentSkipListSetTest.assertFalse((boolean)q.isEmpty());
        ConcurrentSkipListSetTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    private ConcurrentSkipListSet set5() {
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.isEmpty());
        q.add(one);
        q.add(two);
        q.add(three);
        q.add(four);
        q.add(five);
        ConcurrentSkipListSetTest.assertEquals((int)5, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        ConcurrentSkipListSetTest.assertEquals((int)0, (int)new ConcurrentSkipListSet().size());
    }

    public void testConstructor3() {
        try {
            ConcurrentSkipListSet q = new ConcurrentSkipListSet((Collection)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertEquals((Object)ints[i], (Object)q.pollFirst());
        }
    }

    public void testConstructor7() {
        int i;
        MyReverseComparator cmp = new MyReverseComparator();
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>(cmp);
        ConcurrentSkipListSetTest.assertEquals((Object)cmp, q.comparator());
        Integer[] ints = new Integer[20];
        for (i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        q.addAll(Arrays.asList(ints));
        for (i = 19; i >= 0; --i) {
            ConcurrentSkipListSetTest.assertEquals((Object)ints[i], q.pollFirst());
        }
    }

    public void testEmpty() {
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        ConcurrentSkipListSetTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.pollFirst();
        q.pollFirst();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        ConcurrentSkipListSet q = this.populatedSet(20);
        for (i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertEquals((int)(20 - i), (int)q.size());
            q.pollFirst();
        }
        for (i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testAddNull() {
        try {
            ConcurrentSkipListSet<Object> q = new ConcurrentSkipListSet<Object>();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAdd() {
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.add(zero));
        ConcurrentSkipListSetTest.assertTrue((boolean)q.add(one));
    }

    public void testAddDup() {
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.add(zero));
        ConcurrentSkipListSetTest.assertFalse((boolean)q.add(zero));
    }

    public void testAddNonComparable() {
        try {
            ConcurrentSkipListSet<Object> q = new ConcurrentSkipListSet<Object>();
            q.add(new Object());
            q.add(new Object());
            q.add(new Object());
            this.shouldThrow();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            ConcurrentSkipListSet q = new ConcurrentSkipListSet();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(19 - i);
        }
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSetTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ConcurrentSkipListSetTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertEquals((Object)i, q.pollFirst());
        }
    }

    public void testPollFirst() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertEquals((Object)i, q.pollFirst());
        }
        ConcurrentSkipListSetTest.assertNull(q.pollFirst());
    }

    public void testPollLast() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        for (int i = 19; i >= 0; --i) {
            ConcurrentSkipListSetTest.assertEquals((Object)i, q.pollLast());
        }
        ConcurrentSkipListSetTest.assertNull(q.pollFirst());
    }

    public void testRemoveElement() {
        int i;
        ConcurrentSkipListSet q = this.populatedSet(20);
        for (i = 1; i < 20; i += 2) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.remove(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.remove(new Integer(i)));
            ConcurrentSkipListSetTest.assertFalse((boolean)q.remove(new Integer(i + 1)));
        }
        ConcurrentSkipListSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.pollFirst();
            ConcurrentSkipListSetTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        q.clear();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.isEmpty());
        ConcurrentSkipListSetTest.assertEquals((int)0, (int)q.size());
        q.add(new Integer(1));
        ConcurrentSkipListSetTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        ConcurrentSkipListSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        ConcurrentSkipListSet<Integer> p = new ConcurrentSkipListSet<Integer>();
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentSkipListSetTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        ConcurrentSkipListSetTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        ConcurrentSkipListSet p = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                ConcurrentSkipListSetTest.assertFalse((boolean)changed);
            } else {
                ConcurrentSkipListSetTest.assertTrue((boolean)changed);
            }
            ConcurrentSkipListSetTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentSkipListSetTest.assertEquals((int)(20 - i), (int)q.size());
            p.pollFirst();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            ConcurrentSkipListSet q = this.populatedSet(20);
            ConcurrentSkipListSet p = this.populatedSet(i);
            ConcurrentSkipListSetTest.assertTrue((boolean)q.removeAll(p));
            ConcurrentSkipListSetTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I2 = (Integer)p.pollFirst();
                ConcurrentSkipListSetTest.assertFalse((boolean)q.contains(I2));
            }
        }
    }

    public void testLower() {
        ConcurrentSkipListSet q = this.set5();
        Integer e1 = q.lower(three);
        ConcurrentSkipListSetTest.assertEquals((Object)two, (Object)e1);
        Integer e2 = q.lower(six);
        ConcurrentSkipListSetTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.lower(one);
        ConcurrentSkipListSetTest.assertNull((Object)e3);
        Integer e4 = q.lower(zero);
        ConcurrentSkipListSetTest.assertNull((Object)e4);
    }

    public void testHigher() {
        ConcurrentSkipListSet q = this.set5();
        Integer e1 = q.higher(three);
        ConcurrentSkipListSetTest.assertEquals((Object)four, (Object)e1);
        Integer e2 = q.higher(zero);
        ConcurrentSkipListSetTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.higher(five);
        ConcurrentSkipListSetTest.assertNull((Object)e3);
        Integer e4 = q.higher(six);
        ConcurrentSkipListSetTest.assertNull((Object)e4);
    }

    public void testFloor() {
        ConcurrentSkipListSet q = this.set5();
        Integer e1 = q.floor(three);
        ConcurrentSkipListSetTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.floor(six);
        ConcurrentSkipListSetTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.floor(one);
        ConcurrentSkipListSetTest.assertEquals((Object)one, (Object)e3);
        Integer e4 = q.floor(zero);
        ConcurrentSkipListSetTest.assertNull((Object)e4);
    }

    public void testCeiling() {
        ConcurrentSkipListSet q = this.set5();
        Integer e1 = q.ceiling(three);
        ConcurrentSkipListSetTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.ceiling(zero);
        ConcurrentSkipListSetTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.ceiling(five);
        ConcurrentSkipListSetTest.assertEquals((Object)five, (Object)e3);
        Integer e4 = q.ceiling(six);
        ConcurrentSkipListSetTest.assertNull((Object)e4);
    }

    public void testToArray() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            ConcurrentSkipListSetTest.assertEquals((Object)o[i], q.pollFirst());
        }
    }

    public void testToArray2() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        Object[] ints = new Integer[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            ConcurrentSkipListSetTest.assertEquals((Object)ints[i], q.pollFirst());
        }
    }

    public void testIterator() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentSkipListSetTest.assertEquals((int)i, (int)20);
    }

    public void testEmptyIterator() {
        ConcurrentSkipListSet q = new ConcurrentSkipListSet();
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ConcurrentSkipListSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentSkipListSetTest.assertEquals((int)i, (int)0);
    }

    public void testIteratorRemove() {
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        q.add(new Integer(2));
        q.add(new Integer(1));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        ConcurrentSkipListSetTest.assertEquals(it.next(), (Object)new Integer(2));
        ConcurrentSkipListSetTest.assertEquals(it.next(), (Object)new Integer(3));
        ConcurrentSkipListSetTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        ConcurrentSkipListSet q = this.populatedSet(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSetTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        ConcurrentSkipListSet q = this.populatedSet(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ConcurrentSkipListSet r = (ConcurrentSkipListSet)in.readObject();
        ConcurrentSkipListSetTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            ConcurrentSkipListSetTest.assertEquals(q.pollFirst(), r.pollFirst());
        }
    }

    public void testSubSetContents() {
        ConcurrentSkipListSet set = this.set5();
        SortedSet sm = set.subSet(two, four);
        ConcurrentSkipListSetTest.assertEquals((Object)two, sm.first());
        ConcurrentSkipListSetTest.assertEquals((Object)three, sm.last());
        ConcurrentSkipListSetTest.assertEquals((int)2, (int)sm.size());
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(one));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(three));
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(four));
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSetTest.assertFalse((boolean)set.contains(two));
        ConcurrentSkipListSetTest.assertEquals((int)4, (int)set.size());
        ConcurrentSkipListSetTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSetTest.assertEquals((Object)three, sm.first());
        ConcurrentSkipListSetTest.assertEquals((Object)three, sm.last());
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.remove(three));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSetTest.assertEquals((int)3, (int)set.size());
    }

    public void testSubSetContents2() {
        ConcurrentSkipListSet set = this.set5();
        SortedSet sm = set.subSet(two, three);
        ConcurrentSkipListSetTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSetTest.assertEquals((Object)two, sm.first());
        ConcurrentSkipListSetTest.assertEquals((Object)two, sm.last());
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(one));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(three));
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(four));
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)two, (Object)k);
        ConcurrentSkipListSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSetTest.assertFalse((boolean)set.contains(two));
        ConcurrentSkipListSetTest.assertEquals((int)4, (int)set.size());
        ConcurrentSkipListSetTest.assertEquals((int)0, (int)sm.size());
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.remove(three));
        ConcurrentSkipListSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testHeadSetContents() {
        ConcurrentSkipListSet set = this.set5();
        SortedSet sm = set.headSet(four);
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(one));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(three));
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(four));
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)one, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListSetTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSetTest.assertEquals((int)2, (int)set.size());
        ConcurrentSkipListSetTest.assertEquals((Object)four, set.first());
    }

    public void testTailSetContents() {
        ConcurrentSkipListSet set = this.set5();
        SortedSet sm = set.tailSet(two);
        ConcurrentSkipListSetTest.assertFalse((boolean)sm.contains(one));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(three));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(four));
        ConcurrentSkipListSetTest.assertTrue((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)three, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)four, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSetTest.assertEquals((Object)five, (Object)k);
        ConcurrentSkipListSetTest.assertFalse((boolean)i.hasNext());
        SortedSet<Integer> ssm = sm.tailSet(four);
        ConcurrentSkipListSetTest.assertEquals((Object)four, (Object)ssm.first());
        ConcurrentSkipListSetTest.assertEquals((Object)five, (Object)ssm.last());
        ConcurrentSkipListSetTest.assertTrue((boolean)ssm.remove(four));
        ConcurrentSkipListSetTest.assertEquals((int)1, (int)ssm.size());
        ConcurrentSkipListSetTest.assertEquals((int)3, (int)sm.size());
        ConcurrentSkipListSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testRecursiveSubSets() throws Exception {
        int setSize = 1000;
        Class<ConcurrentSkipListSet> cl = ConcurrentSkipListSet.class;
        NavigableSet<Integer> set = ConcurrentSkipListSetTest.newSet(cl);
        this.bs = new BitSet(setSize);
        this.populate(set, setSize);
        this.check(set, 0, setSize - 1, true);
        this.check(set.descendingSet(), 0, setSize - 1, false);
        this.mutateSet(set, 0, setSize - 1);
        this.check(set, 0, setSize - 1, true);
        this.check(set.descendingSet(), 0, setSize - 1, false);
        this.bashSubSet(set.subSet(0, true, setSize, false), 0, setSize - 1, true);
    }

    static NavigableSet<Integer> newSet(Class cl) throws Exception {
        NavigableSet result = (NavigableSet)cl.newInstance();
        ConcurrentSkipListSetTest.assertEquals((int)result.size(), (int)0);
        ConcurrentSkipListSetTest.assertFalse((boolean)result.iterator().hasNext());
        return result;
    }

    void populate(NavigableSet<Integer> set, int limit) {
        int n = 2 * limit / 3;
        for (int i = 0; i < n; ++i) {
            int element = this.rnd.nextInt(limit);
            this.put(set, element);
        }
    }

    void mutateSet(NavigableSet<Integer> set, int min, int max) {
        int size = set.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(set, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator<Integer> it = set.iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear(it.next());
            it.remove();
        }
        while (set.size() < size) {
            int element = min + this.rnd.nextInt(rangeSize);
            ConcurrentSkipListSetTest.assertTrue((element >= min && element <= max ? 1 : 0) != 0);
            this.put(set, element);
        }
    }

    void mutateSubSet(NavigableSet<Integer> set, int min, int max) {
        int size = set.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(set, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator<Integer> it = set.iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear(it.next());
            it.remove();
        }
        while (set.size() < size) {
            int element = min - 5 + this.rnd.nextInt(rangeSize + 10);
            if (element >= min && element <= max) {
                this.put(set, element);
                continue;
            }
            try {
                set.add(element);
                this.shouldThrow();
            }
            catch (IllegalArgumentException success) {}
        }
    }

    void put(NavigableSet<Integer> set, int element) {
        if (set.add(element)) {
            this.bs.set(element);
        }
    }

    void remove(NavigableSet<Integer> set, int element) {
        if (set.remove(element)) {
            this.bs.clear(element);
        }
    }

    void bashSubSet(NavigableSet<Integer> set, int min, int max, boolean ascending) {
        this.check(set, min, max, ascending);
        this.check(set.descendingSet(), min, max, !ascending);
        this.mutateSubSet(set, min, max);
        this.check(set, min, max, ascending);
        this.check(set.descendingSet(), min, max, !ascending);
        if (max - min < 2) {
            return;
        }
        int midPoint = (min + max) / 2;
        boolean incl = this.rnd.nextBoolean();
        NavigableSet<Integer> hm = set.headSet(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(hm, min, midPoint - (incl ? 0 : 1), true);
            } else {
                this.bashSubSet(hm.descendingSet(), min, midPoint - (incl ? 0 : 1), false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubSet(hm, midPoint + (incl ? 0 : 1), max, false);
        } else {
            this.bashSubSet(hm.descendingSet(), midPoint + (incl ? 0 : 1), max, true);
        }
        incl = this.rnd.nextBoolean();
        NavigableSet<Integer> tm = set.tailSet(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(tm, midPoint + (incl ? 0 : 1), max, true);
            } else {
                this.bashSubSet(tm.descendingSet(), midPoint + (incl ? 0 : 1), max, false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubSet(tm, min, midPoint - (incl ? 0 : 1), false);
        } else {
            this.bashSubSet(tm.descendingSet(), min, midPoint - (incl ? 0 : 1), true);
        }
        int rangeSize = max - min + 1;
        int[] endpoints = new int[]{min + this.rnd.nextInt(rangeSize), min + this.rnd.nextInt(rangeSize)};
        Arrays.sort(endpoints);
        boolean lowIncl = this.rnd.nextBoolean();
        boolean highIncl = this.rnd.nextBoolean();
        if (ascending) {
            NavigableSet<Integer> sm = set.subSet(endpoints[0], lowIncl, endpoints[1], highIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            } else {
                this.bashSubSet(sm.descendingSet(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            }
        } else {
            NavigableSet<Integer> sm = set.subSet(endpoints[1], highIncl, endpoints[0], lowIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            } else {
                this.bashSubSet(sm.descendingSet(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            }
        }
    }

    void check(NavigableSet<Integer> set, final int min, final int max, final boolean ascending) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ReferenceSet {
            ReferenceSet() {
            }

            int lower(int element) {
                return ascending ? this.lowerAscending(element) : this.higherAscending(element);
            }

            int floor(int element) {
                return ascending ? this.floorAscending(element) : this.ceilingAscending(element);
            }

            int ceiling(int element) {
                return ascending ? this.ceilingAscending(element) : this.floorAscending(element);
            }

            int higher(int element) {
                return ascending ? this.higherAscending(element) : this.lowerAscending(element);
            }

            int first() {
                return ascending ? this.firstAscending() : this.lastAscending();
            }

            int last() {
                return ascending ? this.lastAscending() : this.firstAscending();
            }

            int lowerAscending(int element) {
                return this.floorAscending(element - 1);
            }

            int floorAscending(int element) {
                if (element < min) {
                    return -1;
                }
                if (element > max) {
                    element = max;
                }
                while (element >= min) {
                    if (ConcurrentSkipListSetTest.this.bs.get(element)) {
                        return element;
                    }
                    --element;
                }
                return -1;
            }

            int ceilingAscending(int element) {
                if (element < min) {
                    element = min;
                } else if (element > max) {
                    return -1;
                }
                int result = ConcurrentSkipListSetTest.this.bs.nextSetBit(element);
                return result > max ? -1 : result;
            }

            int higherAscending(int element) {
                return this.ceilingAscending(element + 1);
            }

            private int firstAscending() {
                int result = this.ceilingAscending(min);
                return result > max ? -1 : result;
            }

            private int lastAscending() {
                int result = this.floorAscending(max);
                return result < min ? -1 : result;
            }
        }
        ReferenceSet rs = new ReferenceSet();
        int size = 0;
        for (int i = min; i <= max; ++i) {
            boolean bsContainsI = this.bs.get(i);
            ConcurrentSkipListSetTest.assertEquals((boolean)bsContainsI, (boolean)set.contains(i));
            if (!bsContainsI) continue;
            ++size;
        }
        ConcurrentSkipListSetTest.assertEquals((int)set.size(), (int)size);
        int size2 = 0;
        int previousElement = -1;
        for (int element : set) {
            ConcurrentSkipListSetTest.assertTrue((boolean)this.bs.get(element));
            ++size2;
            ConcurrentSkipListSetTest.assertTrue((previousElement < 0 || (ascending ? element - previousElement > 0 : element - previousElement < 0) ? 1 : 0) != 0);
            previousElement = element;
        }
        ConcurrentSkipListSetTest.assertEquals((int)size2, (int)size);
        for (int element = min - 1; element <= max + 1; ++element) {
            ConcurrentSkipListSetTest.assertEq(set.lower(element), rs.lower(element));
            ConcurrentSkipListSetTest.assertEq(set.floor(element), rs.floor(element));
            ConcurrentSkipListSetTest.assertEq(set.higher(element), rs.higher(element));
            ConcurrentSkipListSetTest.assertEq(set.ceiling(element), rs.ceiling(element));
        }
        if (set.size() != 0) {
            ConcurrentSkipListSetTest.assertEq((Integer)set.first(), rs.first());
            ConcurrentSkipListSetTest.assertEq((Integer)set.last(), rs.last());
        } else {
            ConcurrentSkipListSetTest.assertEq(rs.first(), -1);
            ConcurrentSkipListSetTest.assertEq(rs.last(), -1);
            try {
                set.first();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
            try {
                set.last();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
        }
    }

    static void assertEq(Integer i, int j) {
        if (i == null) {
            ConcurrentSkipListSetTest.assertEquals((int)j, (int)-1);
        } else {
            ConcurrentSkipListSetTest.assertEquals((int)i, (int)j);
        }
    }

    static boolean eq(Integer i, int j) {
        return i == null ? j == -1 : i == j;
    }

    static class MyReverseComparator
    implements Comparator {
        MyReverseComparator() {
        }

        public int compare(Object x, Object y) {
            return ((Comparable)y).compareTo(x);
        }
    }
}

