/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSkipListMapTest
extends JSR166TestCase {
    Random rnd = new Random(666L);
    BitSet bs;

    public static Test suite() {
        return new TestSuite(ConcurrentSkipListMapTest.class);
    }

    private static ConcurrentSkipListMap map5() {
        ConcurrentSkipListMap<Integer, String> map = new ConcurrentSkipListMap<Integer, String>();
        ConcurrentSkipListMapTest.assertTrue((boolean)map.isEmpty());
        map.put(one, "A");
        map.put(five, "E");
        map.put(three, "C");
        map.put(two, "B");
        map.put(four, "D");
        ConcurrentSkipListMapTest.assertFalse((boolean)map.isEmpty());
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)map.size());
        return map;
    }

    public void testClear() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        map.clear();
        ConcurrentSkipListMapTest.assertEquals((int)map.size(), (int)0);
    }

    public void testConstructFromSorted() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMap map2 = new ConcurrentSkipListMap(map);
        ConcurrentSkipListMapTest.assertEquals((Object)map, map2);
    }

    public void testEquals() {
        ConcurrentSkipListMap map1 = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMap map2 = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertEquals((Object)map1, (Object)map2);
        ConcurrentSkipListMapTest.assertEquals((Object)map2, (Object)map1);
        map1.clear();
        ConcurrentSkipListMapTest.assertFalse((boolean)map1.equals(map2));
        ConcurrentSkipListMapTest.assertFalse((boolean)map2.equals(map1));
    }

    public void testContainsKey() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertTrue((boolean)map.containsKey(one));
        ConcurrentSkipListMapTest.assertFalse((boolean)map.containsKey(zero));
    }

    public void testContainsValue() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertTrue((boolean)map.containsValue("A"));
        ConcurrentSkipListMapTest.assertFalse((boolean)map.containsValue("Z"));
    }

    public void testGet() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertEquals((String)"A", (String)((String)map.get(one)));
        ConcurrentSkipListMap empty = new ConcurrentSkipListMap();
        ConcurrentSkipListMapTest.assertNull(empty.get(one));
    }

    public void testIsEmpty() {
        ConcurrentSkipListMap empty = new ConcurrentSkipListMap();
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertTrue((boolean)empty.isEmpty());
        ConcurrentSkipListMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testFirstKey() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertEquals((Object)one, map.firstKey());
    }

    public void testLastKey() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertEquals((Object)five, map.lastKey());
    }

    public void testKeySetToArray() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Set s = map.keySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)ar.length);
        ar[0] = m10;
        ConcurrentSkipListMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testDescendingKeySetToArray() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableSet s = map.descendingKeySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)ar.length);
        ConcurrentSkipListMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ar[0] = m10;
        ConcurrentSkipListMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testKeySet() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Set s = map.keySet();
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains(one));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains(two));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains(three));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains(four));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains(five));
    }

    public void testKeySetOrder() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Set s = map.keySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)last, (Object)one);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            ConcurrentSkipListMapTest.assertTrue((last.compareTo(k) < 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        ConcurrentSkipListMapTest.assertEquals((int)count, (int)5);
    }

    public void testKeySetDescendingIteratorOrder() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableSet s = map.navigableKeySet();
        Iterator i = s.descendingIterator();
        Integer last = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)last, (Object)five);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            ConcurrentSkipListMapTest.assertTrue((last.compareTo(k) > 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        ConcurrentSkipListMapTest.assertEquals((int)count, (int)5);
    }

    public void testDescendingKeySetOrder() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableSet s = map.descendingKeySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)last, (Object)five);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            ConcurrentSkipListMapTest.assertTrue((last.compareTo(k) > 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        ConcurrentSkipListMapTest.assertEquals((int)count, (int)5);
    }

    public void testDescendingKeySetDescendingIteratorOrder() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableSet s = map.descendingKeySet();
        Iterator i = s.descendingIterator();
        Integer last = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)last, (Object)one);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            ConcurrentSkipListMapTest.assertTrue((last.compareTo(k) < 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        ConcurrentSkipListMapTest.assertEquals((int)count, (int)5);
    }

    public void testValuesToArray() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Collection v = map.values();
        Object[] ar = v.toArray();
        ArrayList<Object> s = new ArrayList<Object>(Arrays.asList(ar));
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)ar.length);
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testValues() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Collection s = map.values();
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentSkipListMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testEntrySet() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Set s = map.entrySet();
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            ConcurrentSkipListMapTest.assertTrue((e.getKey().equals(one) && e.getValue().equals("A") || e.getKey().equals(two) && e.getValue().equals("B") || e.getKey().equals(three) && e.getValue().equals("C") || e.getKey().equals(four) && e.getValue().equals("D") || e.getKey().equals(five) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testDescendingEntrySet() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Set s = map.descendingMap().entrySet();
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            ConcurrentSkipListMapTest.assertTrue((e.getKey().equals(one) && e.getValue().equals("A") || e.getKey().equals(two) && e.getValue().equals("B") || e.getKey().equals(three) && e.getValue().equals("C") || e.getKey().equals(four) && e.getValue().equals("D") || e.getKey().equals(five) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testEntrySetToArray() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Set s = map.entrySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)ar.length);
        for (int i = 0; i < 5; ++i) {
            ConcurrentSkipListMapTest.assertTrue((boolean)map.containsKey(((Map.Entry)ar[i]).getKey()));
            ConcurrentSkipListMapTest.assertTrue((boolean)map.containsValue(((Map.Entry)ar[i]).getValue()));
        }
    }

    public void testDescendingEntrySetToArray() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Set s = map.descendingMap().entrySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)ar.length);
        for (int i = 0; i < 5; ++i) {
            ConcurrentSkipListMapTest.assertTrue((boolean)map.containsKey(((Map.Entry)ar[i]).getKey()));
            ConcurrentSkipListMapTest.assertTrue((boolean)map.containsValue(((Map.Entry)ar[i]).getValue()));
        }
    }

    public void testPutAll() {
        ConcurrentSkipListMap empty = new ConcurrentSkipListMap();
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        empty.putAll(map);
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)empty.size());
        ConcurrentSkipListMapTest.assertTrue((boolean)empty.containsKey(one));
        ConcurrentSkipListMapTest.assertTrue((boolean)empty.containsKey(two));
        ConcurrentSkipListMapTest.assertTrue((boolean)empty.containsKey(three));
        ConcurrentSkipListMapTest.assertTrue((boolean)empty.containsKey(four));
        ConcurrentSkipListMapTest.assertTrue((boolean)empty.containsKey(five));
    }

    public void testPutIfAbsent() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        map.putIfAbsent(six, "Z");
        ConcurrentSkipListMapTest.assertTrue((boolean)map.containsKey(six));
    }

    public void testPutIfAbsent2() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertEquals((Object)"A", (Object)map.putIfAbsent(one, "Z"));
    }

    public void testReplace() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertNull((Object)map.replace(six, "Z"));
        ConcurrentSkipListMapTest.assertFalse((boolean)map.containsKey(six));
    }

    public void testReplace2() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertNotNull((Object)map.replace(one, "Z"));
        ConcurrentSkipListMapTest.assertEquals((Object)"Z", map.get(one));
    }

    public void testReplaceValue() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertEquals((Object)"A", map.get(one));
        ConcurrentSkipListMapTest.assertFalse((boolean)map.replace(one, "Z", "Z"));
        ConcurrentSkipListMapTest.assertEquals((Object)"A", map.get(one));
    }

    public void testReplaceValue2() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertEquals((Object)"A", map.get(one));
        ConcurrentSkipListMapTest.assertTrue((boolean)map.replace(one, "A", "Z"));
        ConcurrentSkipListMapTest.assertEquals((Object)"Z", map.get(one));
    }

    public void testRemove() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        map.remove(five);
        ConcurrentSkipListMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListMapTest.assertFalse((boolean)map.containsKey(five));
    }

    public void testRemove2() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMapTest.assertTrue((boolean)map.containsKey(five));
        ConcurrentSkipListMapTest.assertEquals((Object)"E", map.get(five));
        map.remove(five, "E");
        ConcurrentSkipListMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListMapTest.assertFalse((boolean)map.containsKey(five));
        map.remove(four, "A");
        ConcurrentSkipListMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListMapTest.assertTrue((boolean)map.containsKey(four));
    }

    public void testLowerEntry() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Map.Entry e1 = map.lowerEntry(three);
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)e1.getKey());
        Map.Entry e2 = map.lowerEntry(six);
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.lowerEntry(one);
        ConcurrentSkipListMapTest.assertNull(e3);
        Map.Entry e4 = map.lowerEntry(zero);
        ConcurrentSkipListMapTest.assertNull(e4);
    }

    public void testHigherEntry() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Map.Entry e1 = map.higherEntry(three);
        ConcurrentSkipListMapTest.assertEquals((Object)four, (Object)e1.getKey());
        Map.Entry e2 = map.higherEntry(zero);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.higherEntry(five);
        ConcurrentSkipListMapTest.assertNull(e3);
        Map.Entry e4 = map.higherEntry(six);
        ConcurrentSkipListMapTest.assertNull(e4);
    }

    public void testFloorEntry() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Map.Entry e1 = map.floorEntry(three);
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.floorEntry(six);
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.floorEntry(one);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e3.getKey());
        Map.Entry e4 = map.floorEntry(zero);
        ConcurrentSkipListMapTest.assertNull(e4);
    }

    public void testCeilingEntry() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Map.Entry e1 = map.ceilingEntry(three);
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.ceilingEntry(zero);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.ceilingEntry(five);
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)e3.getKey());
        Map.Entry e4 = map.ceilingEntry(six);
        ConcurrentSkipListMapTest.assertNull(e4);
    }

    public void testEntryImmutablity() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Map.Entry<Integer, String> e = map.lowerEntry(three);
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)e.getKey());
        try {
            e.setValue("X");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException success) {
            // empty catch block
        }
        e = map.higherEntry(zero);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e.getKey());
        try {
            e.setValue("X");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException success) {
            // empty catch block
        }
        e = map.floorEntry(one);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e.getKey());
        try {
            e.setValue("X");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException success) {
            // empty catch block
        }
        e = map.ceilingEntry(five);
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)e.getKey());
        try {
            e.setValue("X");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testLowerKey() {
        ConcurrentSkipListMap q = ConcurrentSkipListMapTest.map5();
        Integer e1 = q.lowerKey(three);
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)e1);
        Integer e2 = q.lowerKey(six);
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.lowerKey(one);
        ConcurrentSkipListMapTest.assertNull((Object)e3);
        Integer e4 = q.lowerKey(zero);
        ConcurrentSkipListMapTest.assertNull((Object)e4);
    }

    public void testHigherKey() {
        ConcurrentSkipListMap q = ConcurrentSkipListMapTest.map5();
        Integer e1 = q.higherKey(three);
        ConcurrentSkipListMapTest.assertEquals((Object)four, (Object)e1);
        Integer e2 = q.higherKey(zero);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.higherKey(five);
        ConcurrentSkipListMapTest.assertNull((Object)e3);
        Integer e4 = q.higherKey(six);
        ConcurrentSkipListMapTest.assertNull((Object)e4);
    }

    public void testFloorKey() {
        ConcurrentSkipListMap q = ConcurrentSkipListMapTest.map5();
        Integer e1 = q.floorKey(three);
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.floorKey(six);
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.floorKey(one);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e3);
        Integer e4 = q.floorKey(zero);
        ConcurrentSkipListMapTest.assertNull((Object)e4);
    }

    public void testCeilingKey() {
        ConcurrentSkipListMap q = ConcurrentSkipListMapTest.map5();
        Integer e1 = q.ceilingKey(three);
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.ceilingKey(zero);
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.ceilingKey(five);
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)e3);
        Integer e4 = q.ceilingKey(six);
        ConcurrentSkipListMapTest.assertNull((Object)e4);
    }

    public void testPollFirstEntry() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Map.Entry e = map.pollFirstEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)one, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)two, e.getKey());
        map.put(one, "A");
        e = map.pollFirstEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)one, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)three, e.getKey());
        map.remove(four);
        e = map.pollFirstEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)five, e.getKey());
        try {
            e.setValue("A");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollFirstEntry();
        ConcurrentSkipListMapTest.assertNull(e);
    }

    public void testPollLastEntry() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        Map.Entry e = map.pollLastEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)five, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)four, e.getKey());
        map.put(five, "E");
        e = map.pollLastEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)five, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)three, e.getKey());
        map.remove(two);
        e = map.pollLastEntry();
        ConcurrentSkipListMapTest.assertEquals((Object)one, e.getKey());
        try {
            e.setValue("E");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollLastEntry();
        ConcurrentSkipListMapTest.assertNull(e);
    }

    public void testSize() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        ConcurrentSkipListMap empty = new ConcurrentSkipListMap();
        ConcurrentSkipListMapTest.assertEquals((int)0, (int)empty.size());
        ConcurrentSkipListMapTest.assertEquals((int)5, (int)map.size());
    }

    public void testToString() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        String s = map.toString();
        for (int i = 1; i <= 5; ++i) {
            ConcurrentSkipListMapTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGet_NullPointerException() {
        try {
            ConcurrentSkipListMap c = ConcurrentSkipListMapTest.map5();
            c.get(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsKey_NullPointerException() {
        try {
            ConcurrentSkipListMap c = ConcurrentSkipListMapTest.map5();
            c.containsKey(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsValue_NullPointerException() {
        try {
            ConcurrentSkipListMap c = new ConcurrentSkipListMap();
            c.containsValue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut1_NullPointerException() {
        try {
            ConcurrentSkipListMap c = ConcurrentSkipListMapTest.map5();
            c.put(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPutIfAbsent1_NullPointerException() {
        try {
            ConcurrentSkipListMap c = ConcurrentSkipListMapTest.map5();
            c.putIfAbsent(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplace_NullPointerException() {
        try {
            ConcurrentSkipListMap c = ConcurrentSkipListMapTest.map5();
            c.replace(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplaceValue_NullPointerException() {
        try {
            ConcurrentSkipListMap c = ConcurrentSkipListMapTest.map5();
            c.replace(null, one, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove1_NullPointerException() {
        try {
            ConcurrentSkipListMap<String, String> c = new ConcurrentSkipListMap<String, String>();
            c.put("sadsdf", "asdads");
            c.remove(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove2_NullPointerException() {
        try {
            ConcurrentSkipListMap<String, String> c = new ConcurrentSkipListMap<String, String>();
            c.put("sadsdf", "asdads");
            c.remove(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove3() {
        ConcurrentSkipListMap<String, String> c = new ConcurrentSkipListMap<String, String>();
        c.put("sadsdf", "asdads");
        ConcurrentSkipListMapTest.assertFalse((boolean)c.remove("sadsdf", null));
    }

    public void testSerialization() throws Exception {
        ConcurrentSkipListMap q = ConcurrentSkipListMapTest.map5();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ConcurrentSkipListMap r = (ConcurrentSkipListMap)in.readObject();
        ConcurrentSkipListMapTest.assertEquals((int)q.size(), (int)r.size());
        ConcurrentSkipListMapTest.assertTrue((boolean)q.equals(r));
        ConcurrentSkipListMapTest.assertTrue((boolean)r.equals(q));
    }

    public void testSubMapContents() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableMap sm = map.subMap(two, true, four, false);
        ConcurrentSkipListMapTest.assertEquals((Object)two, sm.firstKey());
        ConcurrentSkipListMapTest.assertEquals((Object)three, sm.lastKey());
        ConcurrentSkipListMapTest.assertEquals((int)2, (int)sm.size());
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(one));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(three));
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(four));
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListMapTest.assertFalse((boolean)i.hasNext());
        Iterator r = sm.descendingKeySet().iterator();
        k = (Integer)r.next();
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)k);
        k = (Integer)r.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)k);
        ConcurrentSkipListMapTest.assertFalse((boolean)r.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        ConcurrentSkipListMapTest.assertFalse((boolean)map.containsKey(two));
        ConcurrentSkipListMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListMapTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListMapTest.assertEquals((Object)three, sm.firstKey());
        ConcurrentSkipListMapTest.assertEquals((Object)three, sm.lastKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"C", sm.remove(three));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListMapTest.assertEquals((int)3, (int)map.size());
    }

    public void testSubMapContents2() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableMap sm = map.subMap(two, true, three, false);
        ConcurrentSkipListMapTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListMapTest.assertEquals((Object)two, sm.firstKey());
        ConcurrentSkipListMapTest.assertEquals((Object)two, sm.lastKey());
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(one));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(three));
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(four));
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)k);
        ConcurrentSkipListMapTest.assertFalse((boolean)i.hasNext());
        Iterator r = sm.descendingKeySet().iterator();
        k = (Integer)r.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)k);
        ConcurrentSkipListMapTest.assertFalse((boolean)r.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        ConcurrentSkipListMapTest.assertFalse((boolean)map.containsKey(two));
        ConcurrentSkipListMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListMapTest.assertEquals((int)0, (int)sm.size());
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListMapTest.assertSame(sm.remove(three), null);
        ConcurrentSkipListMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testHeadMapContents() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableMap sm = map.headMap(four, false);
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(one));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(three));
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(four));
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)one, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListMapTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListMapTest.assertEquals((int)2, (int)map.size());
        ConcurrentSkipListMapTest.assertEquals((Object)four, map.firstKey());
    }

    public void testTailMapContents() {
        ConcurrentSkipListMap map = ConcurrentSkipListMapTest.map5();
        NavigableMap sm = map.tailMap(two, true);
        ConcurrentSkipListMapTest.assertFalse((boolean)sm.containsKey(one));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(three));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(four));
        ConcurrentSkipListMapTest.assertTrue((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)four, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)k);
        ConcurrentSkipListMapTest.assertFalse((boolean)i.hasNext());
        Iterator r = sm.descendingKeySet().iterator();
        k = (Integer)r.next();
        ConcurrentSkipListMapTest.assertEquals((Object)five, (Object)k);
        k = (Integer)r.next();
        ConcurrentSkipListMapTest.assertEquals((Object)four, (Object)k);
        k = (Integer)r.next();
        ConcurrentSkipListMapTest.assertEquals((Object)three, (Object)k);
        k = (Integer)r.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, (Object)k);
        ConcurrentSkipListMapTest.assertFalse((boolean)r.hasNext());
        Iterator ei = sm.entrySet().iterator();
        Map.Entry e = ei.next();
        ConcurrentSkipListMapTest.assertEquals((Object)two, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"B", e.getValue());
        e = ei.next();
        ConcurrentSkipListMapTest.assertEquals((Object)three, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"C", e.getValue());
        e = ei.next();
        ConcurrentSkipListMapTest.assertEquals((Object)four, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"D", e.getValue());
        e = ei.next();
        ConcurrentSkipListMapTest.assertEquals((Object)five, e.getKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"E", e.getValue());
        ConcurrentSkipListMapTest.assertFalse((boolean)i.hasNext());
        NavigableMap ssm = sm.tailMap(four, true);
        ConcurrentSkipListMapTest.assertEquals((Object)four, ssm.firstKey());
        ConcurrentSkipListMapTest.assertEquals((Object)five, ssm.lastKey());
        ConcurrentSkipListMapTest.assertEquals((Object)"D", ssm.remove(four));
        ConcurrentSkipListMapTest.assertEquals((int)1, (int)ssm.size());
        ConcurrentSkipListMapTest.assertEquals((int)3, (int)sm.size());
        ConcurrentSkipListMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testRecursiveSubMaps() throws Exception {
        int mapSize = 1000;
        Class<ConcurrentSkipListMap> cl = ConcurrentSkipListMap.class;
        NavigableMap<Integer, Integer> map = ConcurrentSkipListMapTest.newMap(cl);
        this.bs = new BitSet(mapSize);
        this.populate(map, mapSize);
        this.check(map, 0, mapSize - 1, true);
        this.check(map.descendingMap(), 0, mapSize - 1, false);
        this.mutateMap(map, 0, mapSize - 1);
        this.check(map, 0, mapSize - 1, true);
        this.check(map.descendingMap(), 0, mapSize - 1, false);
        this.bashSubMap(map.subMap(0, true, mapSize, false), 0, mapSize - 1, true);
    }

    static NavigableMap<Integer, Integer> newMap(Class cl) throws Exception {
        NavigableMap result = (NavigableMap)cl.newInstance();
        ConcurrentSkipListMapTest.assertEquals((int)result.size(), (int)0);
        ConcurrentSkipListMapTest.assertFalse((boolean)result.keySet().iterator().hasNext());
        return result;
    }

    void populate(NavigableMap<Integer, Integer> map, int limit) {
        int n = 2 * limit / 3;
        for (int i = 0; i < n; ++i) {
            int key = this.rnd.nextInt(limit);
            this.put(map, key);
        }
    }

    void mutateMap(NavigableMap<Integer, Integer> map, int min, int max) {
        int size = map.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(map, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear((Integer)it.next());
            it.remove();
        }
        while (map.size() < size) {
            int key = min + this.rnd.nextInt(rangeSize);
            ConcurrentSkipListMapTest.assertTrue((key >= min && key <= max ? 1 : 0) != 0);
            this.put(map, key);
        }
    }

    void mutateSubMap(NavigableMap<Integer, Integer> map, int min, int max) {
        int size = map.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(map, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear((Integer)it.next());
            it.remove();
        }
        while (map.size() < size) {
            int key = min - 5 + this.rnd.nextInt(rangeSize + 10);
            if (key >= min && key <= max) {
                this.put(map, key);
                continue;
            }
            try {
                map.put(key, 2 * key);
                this.shouldThrow();
            }
            catch (IllegalArgumentException success) {}
        }
    }

    void put(NavigableMap<Integer, Integer> map, int key) {
        if (map.put(key, 2 * key) == null) {
            this.bs.set(key);
        }
    }

    void remove(NavigableMap<Integer, Integer> map, int key) {
        if (map.remove(key) != null) {
            this.bs.clear(key);
        }
    }

    void bashSubMap(NavigableMap<Integer, Integer> map, int min, int max, boolean ascending) {
        this.check(map, min, max, ascending);
        this.check(map.descendingMap(), min, max, !ascending);
        this.mutateSubMap(map, min, max);
        this.check(map, min, max, ascending);
        this.check(map.descendingMap(), min, max, !ascending);
        if (max - min < 2) {
            return;
        }
        int midPoint = (min + max) / 2;
        boolean incl = this.rnd.nextBoolean();
        NavigableMap<Integer, Integer> hm = map.headMap(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(hm, min, midPoint - (incl ? 0 : 1), true);
            } else {
                this.bashSubMap(hm.descendingMap(), min, midPoint - (incl ? 0 : 1), false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubMap(hm, midPoint + (incl ? 0 : 1), max, false);
        } else {
            this.bashSubMap(hm.descendingMap(), midPoint + (incl ? 0 : 1), max, true);
        }
        incl = this.rnd.nextBoolean();
        NavigableMap<Integer, Integer> tm = map.tailMap(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(tm, midPoint + (incl ? 0 : 1), max, true);
            } else {
                this.bashSubMap(tm.descendingMap(), midPoint + (incl ? 0 : 1), max, false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubMap(tm, min, midPoint - (incl ? 0 : 1), false);
        } else {
            this.bashSubMap(tm.descendingMap(), min, midPoint - (incl ? 0 : 1), true);
        }
        int rangeSize = max - min + 1;
        int[] endpoints = new int[]{min + this.rnd.nextInt(rangeSize), min + this.rnd.nextInt(rangeSize)};
        Arrays.sort(endpoints);
        boolean lowIncl = this.rnd.nextBoolean();
        boolean highIncl = this.rnd.nextBoolean();
        if (ascending) {
            NavigableMap<Integer, Integer> sm = map.subMap(endpoints[0], lowIncl, endpoints[1], highIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            } else {
                this.bashSubMap(sm.descendingMap(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            }
        } else {
            NavigableMap<Integer, Integer> sm = map.subMap(endpoints[1], highIncl, endpoints[0], lowIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            } else {
                this.bashSubMap(sm.descendingMap(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            }
        }
    }

    void check(NavigableMap<Integer, Integer> map, final int min, final int max, final boolean ascending) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ReferenceSet {
            ReferenceSet() {
            }

            int lower(int key) {
                return ascending ? this.lowerAscending(key) : this.higherAscending(key);
            }

            int floor(int key) {
                return ascending ? this.floorAscending(key) : this.ceilingAscending(key);
            }

            int ceiling(int key) {
                return ascending ? this.ceilingAscending(key) : this.floorAscending(key);
            }

            int higher(int key) {
                return ascending ? this.higherAscending(key) : this.lowerAscending(key);
            }

            int first() {
                return ascending ? this.firstAscending() : this.lastAscending();
            }

            int last() {
                return ascending ? this.lastAscending() : this.firstAscending();
            }

            int lowerAscending(int key) {
                return this.floorAscending(key - 1);
            }

            int floorAscending(int key) {
                if (key < min) {
                    return -1;
                }
                if (key > max) {
                    key = max;
                }
                while (key >= min) {
                    if (ConcurrentSkipListMapTest.this.bs.get(key)) {
                        return key;
                    }
                    --key;
                }
                return -1;
            }

            int ceilingAscending(int key) {
                if (key < min) {
                    key = min;
                } else if (key > max) {
                    return -1;
                }
                int result = ConcurrentSkipListMapTest.this.bs.nextSetBit(key);
                return result > max ? -1 : result;
            }

            int higherAscending(int key) {
                return this.ceilingAscending(key + 1);
            }

            private int firstAscending() {
                int result = this.ceilingAscending(min);
                return result > max ? -1 : result;
            }

            private int lastAscending() {
                int result = this.floorAscending(max);
                return result < min ? -1 : result;
            }
        }
        ReferenceSet rs = new ReferenceSet();
        int size = 0;
        for (int i = min; i <= max; ++i) {
            boolean bsContainsI = this.bs.get(i);
            ConcurrentSkipListMapTest.assertEquals((boolean)bsContainsI, (boolean)map.containsKey(i));
            if (!bsContainsI) continue;
            ++size;
        }
        ConcurrentSkipListMapTest.assertEquals((int)map.size(), (int)size);
        int size2 = 0;
        int previousKey = -1;
        Iterator i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            ConcurrentSkipListMapTest.assertTrue((boolean)this.bs.get(key));
            ++size2;
            ConcurrentSkipListMapTest.assertTrue((previousKey < 0 || (ascending ? key - previousKey > 0 : key - previousKey < 0) ? 1 : 0) != 0);
            previousKey = key;
        }
        ConcurrentSkipListMapTest.assertEquals((int)size2, (int)size);
        for (int key = min - 1; key <= max + 1; ++key) {
            ConcurrentSkipListMapTest.assertEq(map.lowerKey(key), rs.lower(key));
            ConcurrentSkipListMapTest.assertEq(map.floorKey(key), rs.floor(key));
            ConcurrentSkipListMapTest.assertEq(map.higherKey(key), rs.higher(key));
            ConcurrentSkipListMapTest.assertEq(map.ceilingKey(key), rs.ceiling(key));
        }
        if (map.size() != 0) {
            ConcurrentSkipListMapTest.assertEq((Integer)map.firstKey(), rs.first());
            ConcurrentSkipListMapTest.assertEq((Integer)map.lastKey(), rs.last());
        } else {
            ConcurrentSkipListMapTest.assertEq(rs.first(), -1);
            ConcurrentSkipListMapTest.assertEq(rs.last(), -1);
            try {
                map.firstKey();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
            try {
                map.lastKey();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
        }
    }

    static void assertEq(Integer i, int j) {
        if (i == null) {
            ConcurrentSkipListMapTest.assertEquals((int)j, (int)-1);
        } else {
            ConcurrentSkipListMapTest.assertEquals((int)i, (int)j);
        }
    }

    static boolean eq(Integer i, int j) {
        return i == null ? j == -1 : i == j;
    }
}

