/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ConcurrentLinkedQueueTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ConcurrentLinkedQueueTest.class);
    }

    private ConcurrentLinkedQueue populatedQueue(int n) {
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        ConcurrentLinkedQueueTest.assertFalse((boolean)q.isEmpty());
        ConcurrentLinkedQueueTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        ConcurrentLinkedQueueTest.assertEquals((int)0, (int)new ConcurrentLinkedQueue().size());
    }

    public void testConstructor3() {
        try {
            ConcurrentLinkedQueue q = new ConcurrentLinkedQueue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmpty() {
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.isEmpty());
        q.add(one);
        ConcurrentLinkedQueueTest.assertFalse((boolean)q.isEmpty());
        q.add(two);
        q.remove();
        q.remove();
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        try {
            ConcurrentLinkedQueue<Object> q = new ConcurrentLinkedQueue<Object>();
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            ConcurrentLinkedQueue<Object> q = new ConcurrentLinkedQueue<Object>();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.offer(zero));
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.offer(one));
    }

    public void testAdd() {
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((int)i, (int)q.size());
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.add(new Integer(i)));
        }
    }

    public void testAddAll1() {
        try {
            ConcurrentLinkedQueue q = new ConcurrentLinkedQueue();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            ConcurrentLinkedQueue q = this.populatedQueue(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        ConcurrentLinkedQueueTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testPoll() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)i, q.poll());
        }
        ConcurrentLinkedQueueTest.assertNull(q.poll());
    }

    public void testPeek() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)i, q.peek());
            ConcurrentLinkedQueueTest.assertEquals((Object)i, q.poll());
            ConcurrentLinkedQueueTest.assertTrue((q.peek() == null || !q.peek().equals(i) ? 1 : 0) != 0);
        }
        ConcurrentLinkedQueueTest.assertNull(q.peek());
    }

    public void testElement() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)i, q.element());
            ConcurrentLinkedQueueTest.assertEquals((Object)i, q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)i, q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.remove(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.remove(new Integer(i)));
            ConcurrentLinkedQueueTest.assertFalse((boolean)q.remove(new Integer(i + 1)));
        }
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            ConcurrentLinkedQueueTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        q.clear();
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.isEmpty());
        ConcurrentLinkedQueueTest.assertEquals((int)0, (int)q.size());
        q.add(one);
        ConcurrentLinkedQueueTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        ConcurrentLinkedQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        ConcurrentLinkedQueue<Integer> p = new ConcurrentLinkedQueue<Integer>();
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentLinkedQueueTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        ConcurrentLinkedQueueTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        ConcurrentLinkedQueue p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                ConcurrentLinkedQueueTest.assertFalse((boolean)changed);
            } else {
                ConcurrentLinkedQueueTest.assertTrue((boolean)changed);
            }
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentLinkedQueueTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            ConcurrentLinkedQueue q = this.populatedQueue(20);
            ConcurrentLinkedQueue p = this.populatedQueue(i);
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.removeAll(p));
            ConcurrentLinkedQueueTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I2 = (Integer)p.remove();
                ConcurrentLinkedQueueTest.assertFalse((boolean)q.contains(I2));
            }
        }
    }

    public void testToArray() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)o[i], q.poll());
        }
    }

    public void testToArray2() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        Object[] ints = new Integer[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            ConcurrentLinkedQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testToArray_BadArg() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        try {
            T[] o = q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        try {
            String[] o = q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ConcurrentLinkedQueueTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentLinkedQueueTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorOrdering() {
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        q.add(one);
        q.add(two);
        q.add(three);
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ConcurrentLinkedQueueTest.assertEquals((Object)(++k), it.next());
        }
        ConcurrentLinkedQueueTest.assertEquals((int)3, (int)k);
    }

    public void testWeaklyConsistentIteration() {
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        q.add(one);
        q.add(two);
        q.add(three);
        Iterator it = q.iterator();
        while (it.hasNext()) {
            q.remove();
            it.next();
        }
        ConcurrentLinkedQueueTest.assertEquals((String)"queue should be empty again", (int)0, (int)q.size());
    }

    public void testIteratorRemove() {
        ConcurrentLinkedQueue<Integer> q = new ConcurrentLinkedQueue<Integer>();
        q.add(one);
        q.add(two);
        q.add(three);
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        ConcurrentLinkedQueueTest.assertSame(it.next(), (Object)two);
        ConcurrentLinkedQueueTest.assertSame(it.next(), (Object)three);
        ConcurrentLinkedQueueTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedQueueTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        ConcurrentLinkedQueue q = this.populatedQueue(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ConcurrentLinkedQueue r = (ConcurrentLinkedQueue)in.readObject();
        ConcurrentLinkedQueueTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            ConcurrentLinkedQueueTest.assertEquals(q.remove(), r.remove());
        }
    }
}

