/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ConcurrentHashMapTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ConcurrentHashMapTest.class);
    }

    private static ConcurrentHashMap map5() {
        ConcurrentHashMap<Integer, String> map = new ConcurrentHashMap<Integer, String>(5);
        ConcurrentHashMapTest.assertTrue((boolean)map.isEmpty());
        map.put(one, "A");
        map.put(two, "B");
        map.put(three, "C");
        map.put(four, "D");
        map.put(five, "E");
        ConcurrentHashMapTest.assertFalse((boolean)map.isEmpty());
        ConcurrentHashMapTest.assertEquals((int)5, (int)map.size());
        return map;
    }

    public void testClear() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        map.clear();
        ConcurrentHashMapTest.assertEquals((int)map.size(), (int)0);
    }

    public void testEquals() {
        ConcurrentHashMap map1 = ConcurrentHashMapTest.map5();
        ConcurrentHashMap map2 = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertEquals((Object)map1, (Object)map2);
        ConcurrentHashMapTest.assertEquals((Object)map2, (Object)map1);
        map1.clear();
        ConcurrentHashMapTest.assertFalse((boolean)map1.equals(map2));
        ConcurrentHashMapTest.assertFalse((boolean)map2.equals(map1));
    }

    public void testContains() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertTrue((boolean)map.contains("A"));
        ConcurrentHashMapTest.assertFalse((boolean)map.contains("Z"));
    }

    public void testContainsKey() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertTrue((boolean)map.containsKey(one));
        ConcurrentHashMapTest.assertFalse((boolean)map.containsKey(zero));
    }

    public void testContainsValue() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertTrue((boolean)map.containsValue("A"));
        ConcurrentHashMapTest.assertFalse((boolean)map.containsValue("Z"));
    }

    public void testEnumeration() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Enumeration e = map.elements();
        int count = 0;
        while (e.hasMoreElements()) {
            ++count;
            e.nextElement();
        }
        ConcurrentHashMapTest.assertEquals((int)5, (int)count);
    }

    public void testGet() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertEquals((String)"A", (String)((String)map.get(one)));
        ConcurrentHashMap empty = new ConcurrentHashMap();
        ConcurrentHashMapTest.assertNull(map.get("anything"));
    }

    public void testIsEmpty() {
        ConcurrentHashMap empty = new ConcurrentHashMap();
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertTrue((boolean)empty.isEmpty());
        ConcurrentHashMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testKeys() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Enumeration e = map.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            ++count;
            e.nextElement();
        }
        ConcurrentHashMapTest.assertEquals((int)5, (int)count);
    }

    public void testKeySet() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Set s = map.keySet();
        ConcurrentHashMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentHashMapTest.assertTrue((boolean)s.contains(one));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains(two));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains(three));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains(four));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains(five));
    }

    public void testKeySetToArray() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Set s = map.keySet();
        Object[] ar = s.toArray();
        ConcurrentHashMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ConcurrentHashMapTest.assertEquals((int)5, (int)ar.length);
        ar[0] = m10;
        ConcurrentHashMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testValuesToArray() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Collection v = map.values();
        Object[] ar = v.toArray();
        ArrayList<Object> s = new ArrayList<Object>(Arrays.asList(ar));
        ConcurrentHashMapTest.assertEquals((int)5, (int)ar.length);
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testEntrySetToArray() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Set s = map.entrySet();
        Object[] ar = s.toArray();
        ConcurrentHashMapTest.assertEquals((int)5, (int)ar.length);
        for (int i = 0; i < 5; ++i) {
            ConcurrentHashMapTest.assertTrue((boolean)map.containsKey(((Map.Entry)ar[i]).getKey()));
            ConcurrentHashMapTest.assertTrue((boolean)map.containsValue(((Map.Entry)ar[i]).getValue()));
        }
    }

    public void testValues() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Collection s = map.values();
        ConcurrentHashMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentHashMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testEntrySet() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        Set s = map.entrySet();
        ConcurrentHashMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            ConcurrentHashMapTest.assertTrue((e.getKey().equals(one) && e.getValue().equals("A") || e.getKey().equals(two) && e.getValue().equals("B") || e.getKey().equals(three) && e.getValue().equals("C") || e.getKey().equals(four) && e.getValue().equals("D") || e.getKey().equals(five) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testPutAll() {
        ConcurrentHashMap empty = new ConcurrentHashMap();
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        empty.putAll(map);
        ConcurrentHashMapTest.assertEquals((int)5, (int)empty.size());
        ConcurrentHashMapTest.assertTrue((boolean)empty.containsKey(one));
        ConcurrentHashMapTest.assertTrue((boolean)empty.containsKey(two));
        ConcurrentHashMapTest.assertTrue((boolean)empty.containsKey(three));
        ConcurrentHashMapTest.assertTrue((boolean)empty.containsKey(four));
        ConcurrentHashMapTest.assertTrue((boolean)empty.containsKey(five));
    }

    public void testPutIfAbsent() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        map.putIfAbsent(six, "Z");
        ConcurrentHashMapTest.assertTrue((boolean)map.containsKey(six));
    }

    public void testPutIfAbsent2() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertEquals((Object)"A", (Object)map.putIfAbsent(one, "Z"));
    }

    public void testReplace() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertNull((Object)map.replace(six, "Z"));
        ConcurrentHashMapTest.assertFalse((boolean)map.containsKey(six));
    }

    public void testReplace2() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertNotNull((Object)map.replace(one, "Z"));
        ConcurrentHashMapTest.assertEquals((Object)"Z", map.get(one));
    }

    public void testReplaceValue() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertEquals((Object)"A", map.get(one));
        ConcurrentHashMapTest.assertFalse((boolean)map.replace(one, "Z", "Z"));
        ConcurrentHashMapTest.assertEquals((Object)"A", map.get(one));
    }

    public void testReplaceValue2() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMapTest.assertEquals((Object)"A", map.get(one));
        ConcurrentHashMapTest.assertTrue((boolean)map.replace(one, "A", "Z"));
        ConcurrentHashMapTest.assertEquals((Object)"Z", map.get(one));
    }

    public void testRemove() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        map.remove(five);
        ConcurrentHashMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentHashMapTest.assertFalse((boolean)map.containsKey(five));
    }

    public void testRemove2() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        map.remove(five, "E");
        ConcurrentHashMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentHashMapTest.assertFalse((boolean)map.containsKey(five));
        map.remove(four, "A");
        ConcurrentHashMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentHashMapTest.assertTrue((boolean)map.containsKey(four));
    }

    public void testSize() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        ConcurrentHashMap empty = new ConcurrentHashMap();
        ConcurrentHashMapTest.assertEquals((int)0, (int)empty.size());
        ConcurrentHashMapTest.assertEquals((int)5, (int)map.size());
    }

    public void testToString() {
        ConcurrentHashMap map = ConcurrentHashMapTest.map5();
        String s = map.toString();
        for (int i = 1; i <= 5; ++i) {
            ConcurrentHashMapTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testConstructor1() {
        try {
            new ConcurrentHashMap(-1, 0.0f, 1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            new ConcurrentHashMap(1, 0.0f, -1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            new ConcurrentHashMap(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGet_NullPointerException() {
        try {
            ConcurrentHashMap c = new ConcurrentHashMap(5);
            c.get(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsKey_NullPointerException() {
        try {
            ConcurrentHashMap c = new ConcurrentHashMap(5);
            c.containsKey(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsValue_NullPointerException() {
        try {
            ConcurrentHashMap c = new ConcurrentHashMap(5);
            c.containsValue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContains_NullPointerException() {
        try {
            ConcurrentHashMap c = new ConcurrentHashMap(5);
            c.contains(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut1_NullPointerException() {
        try {
            ConcurrentHashMap<Object, String> c = new ConcurrentHashMap<Object, String>(5);
            c.put(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut2_NullPointerException() {
        try {
            ConcurrentHashMap<String, Object> c = new ConcurrentHashMap<String, Object>(5);
            c.put("whatever", null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPutIfAbsent1_NullPointerException() {
        try {
            ConcurrentHashMap<Object, String> c = new ConcurrentHashMap<Object, String>(5);
            c.putIfAbsent(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplace_NullPointerException() {
        try {
            ConcurrentHashMap<Object, String> c = new ConcurrentHashMap<Object, String>(5);
            c.replace(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplaceValue_NullPointerException() {
        try {
            ConcurrentHashMap<Object, String> c = new ConcurrentHashMap<Object, String>(5);
            c.replace(null, (String)((Object)one), "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPutIfAbsent2_NullPointerException() {
        try {
            ConcurrentHashMap<String, Object> c = new ConcurrentHashMap<String, Object>(5);
            c.putIfAbsent("whatever", null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplace2_NullPointerException() {
        try {
            ConcurrentHashMap<String, Object> c = new ConcurrentHashMap<String, Object>(5);
            c.replace("whatever", null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplaceValue2_NullPointerException() {
        try {
            ConcurrentHashMap<String, String> c = new ConcurrentHashMap<String, String>(5);
            c.replace("whatever", null, "A");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplaceValue3_NullPointerException() {
        try {
            ConcurrentHashMap<String, Integer> c = new ConcurrentHashMap<String, Integer>(5);
            c.replace("whatever", one, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove1_NullPointerException() {
        try {
            ConcurrentHashMap<String, String> c = new ConcurrentHashMap<String, String>(5);
            c.put("sadsdf", "asdads");
            c.remove(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove2_NullPointerException() {
        try {
            ConcurrentHashMap<String, String> c = new ConcurrentHashMap<String, String>(5);
            c.put("sadsdf", "asdads");
            c.remove(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove3() {
        ConcurrentHashMap<String, String> c = new ConcurrentHashMap<String, String>(5);
        c.put("sadsdf", "asdads");
        ConcurrentHashMapTest.assertFalse((boolean)c.remove("sadsdf", null));
    }

    public void testSerialization() throws Exception {
        ConcurrentHashMap q = ConcurrentHashMapTest.map5();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ConcurrentHashMap r = (ConcurrentHashMap)in.readObject();
        ConcurrentHashMapTest.assertEquals((int)q.size(), (int)r.size());
        ConcurrentHashMapTest.assertTrue((boolean)q.equals(r));
        ConcurrentHashMapTest.assertTrue((boolean)r.equals(q));
    }

    public void testSetValueWriteThrough() {
        ConcurrentHashMap<Integer, Integer> map = new ConcurrentHashMap<Integer, Integer>(2, 5.0f, 1);
        ConcurrentHashMapTest.assertTrue((boolean)map.isEmpty());
        for (int i = 0; i < 20; ++i) {
            map.put(new Integer(i), new Integer(i));
        }
        ConcurrentHashMapTest.assertFalse((boolean)map.isEmpty());
        Map.Entry entry1 = map.entrySet().iterator().next();
        ConcurrentHashMapTest.assertTrue((String)"entry is 16, test not valid", (!entry1.getKey().equals(new Integer(16)) ? 1 : 0) != 0);
        map.remove(new Integer(16));
        entry1.setValue("XYZ");
        ConcurrentHashMapTest.assertTrue((boolean)map.containsValue("XYZ"));
    }
}

