/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.concurrent.atomic.AtomicStampedReference;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class AtomicStampedReferenceTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(AtomicStampedReferenceTest.class);
    }

    public void testConstructor() {
        AtomicStampedReference<Integer> ai = new AtomicStampedReference<Integer>(one, 0);
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.getReference());
        AtomicStampedReferenceTest.assertEquals((int)0, (int)ai.getStamp());
        AtomicStampedReference<Object> a2 = new AtomicStampedReference<Object>(null, 1);
        AtomicStampedReferenceTest.assertNull(a2.getReference());
        AtomicStampedReferenceTest.assertEquals((int)1, (int)a2.getStamp());
    }

    public void testGetSet() {
        int[] mark = new int[1];
        AtomicStampedReference<Integer> ai = new AtomicStampedReference<Integer>(one, 0);
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.getReference());
        AtomicStampedReferenceTest.assertEquals((int)0, (int)ai.getStamp());
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)0, (int)mark[0]);
        ai.set(two, 0);
        AtomicStampedReferenceTest.assertSame((Object)two, (Object)ai.getReference());
        AtomicStampedReferenceTest.assertEquals((int)0, (int)ai.getStamp());
        AtomicStampedReferenceTest.assertSame((Object)two, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)0, (int)mark[0]);
        ai.set(one, 1);
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.getReference());
        AtomicStampedReferenceTest.assertEquals((int)1, (int)ai.getStamp());
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)1, (int)mark[0]);
    }

    public void testAttemptStamp() {
        int[] mark = new int[1];
        AtomicStampedReference<Integer> ai = new AtomicStampedReference<Integer>(one, 0);
        AtomicStampedReferenceTest.assertEquals((int)0, (int)ai.getStamp());
        AtomicStampedReferenceTest.assertTrue((boolean)ai.attemptStamp(one, 1));
        AtomicStampedReferenceTest.assertEquals((int)1, (int)ai.getStamp());
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)1, (int)mark[0]);
    }

    public void testCompareAndSet() {
        int[] mark = new int[1];
        AtomicStampedReference<Integer> ai = new AtomicStampedReference<Integer>(one, 0);
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)0, (int)ai.getStamp());
        AtomicStampedReferenceTest.assertEquals((int)0, (int)mark[0]);
        AtomicStampedReferenceTest.assertTrue((boolean)ai.compareAndSet(one, two, 0, 0));
        AtomicStampedReferenceTest.assertSame((Object)two, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)0, (int)mark[0]);
        AtomicStampedReferenceTest.assertTrue((boolean)ai.compareAndSet(two, m3, 0, 1));
        AtomicStampedReferenceTest.assertSame((Object)m3, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)1, (int)mark[0]);
        AtomicStampedReferenceTest.assertFalse((boolean)ai.compareAndSet(two, m3, 1, 1));
        AtomicStampedReferenceTest.assertSame((Object)m3, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)1, (int)mark[0]);
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicStampedReference<Integer> ai = new AtomicStampedReference<Integer>(one, 0);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                while (!ai.compareAndSet(JSR166TestCase.two, JSR166TestCase.three, 0, 0)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicStampedReferenceTest.assertTrue((boolean)ai.compareAndSet(one, two, 0, 0));
        t.join(LONG_DELAY_MS);
        AtomicStampedReferenceTest.assertFalse((boolean)t.isAlive());
        AtomicStampedReferenceTest.assertSame((Object)ai.getReference(), (Object)three);
        AtomicStampedReferenceTest.assertEquals((int)ai.getStamp(), (int)0);
    }

    public void testCompareAndSetInMultipleThreads2() throws Exception {
        final AtomicStampedReference<Integer> ai = new AtomicStampedReference<Integer>(one, 0);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                while (!ai.compareAndSet(JSR166TestCase.one, JSR166TestCase.one, 1, 2)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicStampedReferenceTest.assertTrue((boolean)ai.compareAndSet(one, one, 0, 1));
        t.join(LONG_DELAY_MS);
        AtomicStampedReferenceTest.assertFalse((boolean)t.isAlive());
        AtomicStampedReferenceTest.assertSame((Object)ai.getReference(), (Object)one);
        AtomicStampedReferenceTest.assertEquals((int)ai.getStamp(), (int)2);
    }

    public void testWeakCompareAndSet() {
        int[] mark = new int[1];
        AtomicStampedReference<Integer> ai = new AtomicStampedReference<Integer>(one, 0);
        AtomicStampedReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)0, (int)ai.getStamp());
        AtomicStampedReferenceTest.assertEquals((int)0, (int)mark[0]);
        while (!ai.weakCompareAndSet(one, two, 0, 0)) {
        }
        AtomicStampedReferenceTest.assertSame((Object)two, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)0, (int)mark[0]);
        while (!ai.weakCompareAndSet(two, m3, 0, 1)) {
        }
        AtomicStampedReferenceTest.assertSame((Object)m3, (Object)ai.get(mark));
        AtomicStampedReferenceTest.assertEquals((int)1, (int)mark[0]);
    }
}

