/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class AtomicLongFieldUpdaterTest
extends JSR166TestCase {
    volatile long x = 0L;
    int z;
    long w;

    public static Test suite() {
        return new TestSuite(AtomicLongFieldUpdaterTest.class);
    }

    public void testConstructor() {
        try {
            AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "y");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "z");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "w");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.get(this));
        a.set(this, 2L);
        AtomicLongFieldUpdaterTest.assertEquals((long)2L, (long)a.get(this));
        a.set(this, -3L);
        AtomicLongFieldUpdaterTest.assertEquals((long)-3L, (long)a.get(this));
    }

    public void testGetLazySet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.get(this));
        a.lazySet(this, 2L);
        AtomicLongFieldUpdaterTest.assertEquals((long)2L, (long)a.get(this));
        a.lazySet(this, -3L);
        AtomicLongFieldUpdaterTest.assertEquals((long)-3L, (long)a.get(this));
    }

    public void testCompareAndSet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, 1L, 2L));
        AtomicLongFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, 2L, -4L));
        AtomicLongFieldUpdaterTest.assertEquals((long)-4L, (long)a.get(this));
        AtomicLongFieldUpdaterTest.assertFalse((boolean)a.compareAndSet(this, -5L, 7L));
        AtomicLongFieldUpdaterTest.assertEquals((long)-4L, (long)a.get(this));
        AtomicLongFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, -4L, 7L));
        AtomicLongFieldUpdaterTest.assertEquals((long)7L, (long)a.get(this));
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        this.x = 1L;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                while (!a.compareAndSet(AtomicLongFieldUpdaterTest.this, 2L, 3L)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicLongFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, 1L, 2L));
        t.join(LONG_DELAY_MS);
        AtomicLongFieldUpdaterTest.assertFalse((boolean)t.isAlive());
        AtomicLongFieldUpdaterTest.assertEquals((long)a.get(this), (long)3L);
    }

    public void testWeakCompareAndSet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        while (!a.weakCompareAndSet(this, 1L, 2L)) {
        }
        while (!a.weakCompareAndSet(this, 2L, -4L)) {
        }
        AtomicLongFieldUpdaterTest.assertEquals((long)-4L, (long)a.get(this));
        while (!a.weakCompareAndSet(this, -4L, 7L)) {
        }
        AtomicLongFieldUpdaterTest.assertEquals((long)7L, (long)a.get(this));
    }

    public void testGetAndSet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.getAndSet(this, 0L));
        AtomicLongFieldUpdaterTest.assertEquals((long)0L, (long)a.getAndSet(this, -10L));
        AtomicLongFieldUpdaterTest.assertEquals((long)-10L, (long)a.getAndSet(this, 1L));
    }

    public void testGetAndAdd() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.getAndAdd(this, 2L));
        AtomicLongFieldUpdaterTest.assertEquals((long)3L, (long)a.get(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)3L, (long)a.getAndAdd(this, -4L));
        AtomicLongFieldUpdaterTest.assertEquals((long)-1L, (long)a.get(this));
    }

    public void testGetAndDecrement() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.getAndDecrement(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)0L, (long)a.getAndDecrement(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)-1L, (long)a.getAndDecrement(this));
    }

    public void testGetAndIncrement() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.getAndIncrement(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)2L, (long)a.get(this));
        a.set(this, -2L);
        AtomicLongFieldUpdaterTest.assertEquals((long)-2L, (long)a.getAndIncrement(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)-1L, (long)a.getAndIncrement(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)0L, (long)a.getAndIncrement(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.get(this));
    }

    public void testAddAndGet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)3L, (long)a.addAndGet(this, 2L));
        AtomicLongFieldUpdaterTest.assertEquals((long)3L, (long)a.get(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)-1L, (long)a.addAndGet(this, -4L));
        AtomicLongFieldUpdaterTest.assertEquals((long)-1L, (long)a.get(this));
    }

    public void testDecrementAndGet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)0L, (long)a.decrementAndGet(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)-1L, (long)a.decrementAndGet(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)-2L, (long)a.decrementAndGet(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)-2L, (long)a.get(this));
    }

    public void testIncrementAndGet() {
        AtomicLongFieldUpdater<AtomicLongFieldUpdaterTest> a;
        try {
            a = AtomicLongFieldUpdater.newUpdater(AtomicLongFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1L;
        AtomicLongFieldUpdaterTest.assertEquals((long)2L, (long)a.incrementAndGet(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)2L, (long)a.get(this));
        a.set(this, -2L);
        AtomicLongFieldUpdaterTest.assertEquals((long)-1L, (long)a.incrementAndGet(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)0L, (long)a.incrementAndGet(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.incrementAndGet(this));
        AtomicLongFieldUpdaterTest.assertEquals((long)1L, (long)a.get(this));
    }
}

